<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.job"></cv:cvMessages>
<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
<cv:cvMessages bundle="localization.devices"></cv:cvMessages>
<cv:cvMessages bundle="localization.devicesJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
<cv:cvMessages bundle="localization.users"></cv:cvMessages>
<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12 flex-detail-header padding-bottom-20">
			<cv-changename obj='changeNameObj' service-method='changeServerName.do' class="float-left"> </cv-changename>
 			<cv-capability-links class="flex-page-actions" data-ng-if="permittedOptions" cv-permitted-options="permittedOptions"></cv-capability-links>
	</div>
</div>
<div data-ng-if="details.dlpProperties.dlpStolen">
	<alert-detail-sign data-ng-if="details.isDLPRMEnabledOnClient" text="info.deviceEraseContent"></alert-detail-sign>
	<alert-detail-sign data-ng-if="!details.isDLPRMEnabledOnClient" type="question" text="info.deviceLost"></alert-detail-sign>
</div>
<div class="row">
	<div class="col-md-6">
	<cv-tile-component data-ac-id="deviceDetails-label_summary-servers" data-title='<cv:msg key="label.summary" bundle="servers"/>' loader="details">
		<div class="page-details-box-links" data-ng-if="isCloudLaptop">
				<a href=""  data-ng-click="refreshSummaryContent()">
					<span><cv:msg key="label.refresh" bundle="devices"/></span>
				</a>
			</div>
		<ul class="list-style-secondary" data-ng-if="details">
				<li class="group" data-ng-if="details.subClient.hostName"><span class="pageDetailColumn"><cv:msg key="label.data.serverHostName" bundle="servers" /></span>
					 <span class="pageDetailColumn">{{details.subClient.hostName}}</span></li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.lastbackup.time" bundle="collections" /></span>
					<span class="pageDetailColumn">
					 	<div class="time crop" val="{{lastBackupTime}}" empty="<cv:msg key='detail.neverBackedUp' bundle='devicesJs'/>"></div>
					</span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastbackup.size" bundle="collections" /></span>
					 <span class="pageDetailColumn">{{details.backupSize | capacity}}</span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="header.applicationSize" bundle="devicesJs" /></span>
					 <span class="pageDetailColumn">{{details.totalBackupSize | capacity}}</span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastSeenOnline.time" bundle="devices" /></span>
					 <span class="pageDetailColumn"><div class="time crop" val="{{details.lastOnlineTime.time}}" empty="<cv:msg key='label.noavailable' bundle='devicesJs'/>"></div></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.nextbackup.time" bundle="collections" /></span>
					 <span class="pageDetailColumn">
					 	<div data-ng-show="details.nextBackupTime.time > -1" class="time crop" val="{{details.nextBackupTime.time}}" empty='<cv:msg key="info.notScheduled" bundle="devices" />'></div>
					 	<div data-ng-show="details.nextBackupTime.time == -1"><cv:msg key="schedule.automatic" bundle="messagesJs" /></div>
					 </span>
				 </li>
				 <!-- region add/edit block -->
                <li class="group">
                	<cv-region-select class="planMigration-block" data-ng-if="planRuleEnabled" data-cv-client-id="deviceId" data-cv-client-region-info="clientRegion"  ></cv-region-select>
                </li>
				<!-- End region add/edit block -->
				
				<li data-ng-if="companyId" class="group">
					<span class="pageDetailColumn"><cv:msg key="label.company" bundle="messagesJs" /></span>
					<span class="pageDetailColumn" >
						<a href="#/subscriptions/{{companyId}}" data-ng-bind="companyName"></a>
					</span>
				</li>

		</ul>
	</cv-tile-component>
	<cv-tile-component  data-ng-show="details && isCloudLaptop" data-ac-id="deviceDetails-label_backup-collections" data-title='<cv:msg key="label.recentBackups" bundle="devices"/>' loader="backupJobs">
		<ul class="serverBackupTile">
			<li>
				<span class="page-details-box-links multiLinks">
					<ul>
						<li class="restoreli" data-ng-click="showBackupOptions()"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a>
						</li>
					</ul>
				</span>
			</li>
			<li data-ng-if="isCloudLaptop" class="backupTable">
				<cv-kendo-grid cv-grid-options="globalBackupTblGridOptions" />
			</li>
		</ul>
		<div data-ng-if="backupJobs.length > 5" data-ng-click="navigateToBackupList()"><a href=""><cv:msg
							key="action.viewMore" bundle="devices" /></a></div>
	</cv-tile-component>
	<cv-tile-component  data-ng-show="details && !isCloudLaptop" data-ac-id="deviceDetails-label_backup-collections" data-title='<cv:msg key="label.backup" bundle="collections"/>' loader="details">
		<ul class="serverBackupTile">
			<li>
				<span class="page-details-box-links multiLinks">
					<ul>
						<li data-ng-if="showBackup['backup']" class="restoreli" data-ng-click="showBackupOptions()"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a>
						</li>
						<li data-ng-show="details"> <a data-ng-href="#jobs?serverId={{clientId}}&serverName={{clientName}}&collectionId={{subClientId}}&collectionName={{clientName}}&jobType=Backup,SYNTHFULL"><cv:msg
							key="action.jobs" bundle="servers" /></a> </li>
					</ul>
				</span>
			</li>
			<li data-ng-if="showBackup['backup']">
					<p class="info-place-holder"><cv:msg key="info.nobackupRunning" bundle="collections"/></p>
				</li>
			<li data-ng-if="showBackup['submittingJob']">
				<p class="info-place-holder"><cv:msg key="info.submittingJob" bundle="collections"/></p>
			</li>
			<li data-ng-if="backupJobs.length>0 && !isCloudLaptop">
				<cv-job jobs='backupJobs' show-backup='showBackup' capability="jobCap"></cv-job>
			</li>
		</ul>
	</cv-tile-component>
	<!-- Map  -->
	<cv-tile-component data-ac-id="deviceDetails-header_map-devices" data-ng-show="lastGeoLocation" data-title='<cv:msg key="header.map" bundle="devices"/>' loader="lastGeoLocationLoaded">
		<div id='map-wrapper' ></div>
	</cv-tile-component>
	<div data-ng-if="generatePrivacyParams" data-ng-disabled = "disablePrivacySetting()">
		<cv-passkey-setting-component subscription-data="subscriptionData" generic-entity='genericEntity' client-props="generatePrivacyParams" show-separate-tab="true"></cv-passkey-setting-component>
	</div>
	</div>
	<div class="col-md-6">
		<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded="associationsLoaded" data-show-Owners='true' default-tab='owner' client-props="generatePrivacyParams">
		</cv-security-component>
		<cv-schedule-tile data-ng-if="!noPlanPermission" loader="scheduleIdentifierList" scheduleIdentifierList="scheduleIdentifierList" show-edit="!PlanSet" subclient-id="subclientId"></cv-schedule-tile>
		<cv-tile-component data-ng-if="PlanSet && noPlanPermission" data-title='<cv:msg key="label.associatedSchedule" bundle="schedule"/>' min-height="true">
			<p class="info-place-holder">
				<span class="error">
					<cv:msg key="label.planSchedulesNotViewable" bundle="profiles"/>
				</span>
			</p>
		</cv-tile-component>
		<cv-tile-component data-ac-id="deviceDetails-header_content-collections" data-title='<cv:msg key="header.content" bundle="collections"/>' data-min-height="true" loader="details">
			<p data-ng-if="contentEntityDetails && !contentEntityDetails.length && !contentEntityDetailsSCP.length" class="info-place-holder"><cv:msg key="label.noContent" bundle="clients" /></p>
			<div ng-if="!isUserHaveDefinedContent">
				<ul class="list-style__row group text-group" data-ng-if="contentEntityDetailsSCP.length">
					<li data-ng-repeat="contentEntity in contentEntityDetailsSCP track by $index">
						<span data-ng-if="osType === 'windows'">{{contentEntity.value | trimFolderName}}</span>
						<span data-ng-if="osType === 'unix'">{{contentEntity.value | trimUnixFolderName}}</span>
						<span data-ng-if="!$last" class="comma">,</span>
					</li>
				</ul>
				<ul class="list-style__row group text-group" data-ng-if="contentEntityDetails.length">
					<li data-ng-repeat="contentEntity in contentEntityDetails track by $index">
						<span data-ng-if="osType === 'windows'">{{contentEntity.value | trimFolderName}}</span>
						<span data-ng-if="osType === 'unix'">{{contentEntity.value | trimUnixFolderName}}</span>
						<span data-ng-if="!$last" class="comma">,</span>
					</li>
				</ul>
			</div>
			<div ng-if="isUserHaveDefinedContent">
				<ul class="list-style-secondary">
					<li class="group"><span class="pageDetailColumn" ng-bind="'label.inheritedFromPlan' | cvLoc"></span>
						<span class="pageDetailColumn ">
							<span data-ng-repeat="contentEntity in contentEntityDetailsSCP track by $index">
								<span data-ng-if="osType === 'windows'">{{contentEntity.value | trimFolderName}}</span>
								<span data-ng-if="osType === 'unix'">{{contentEntity.value | trimUnixFolderName}}</span>
								<span data-ng-if="!$last" class="comma">,</span>
							</span>
						</span>
					</li>
					<li  class="group"><span class="pageDetailColumn" ng-bind="'label.userDefined' | cvLoc"></span>
						<span class="pageDetailColumn">
							<span data-ng-repeat="contentEntity in contentEntityDetails track by $index">
								<span data-ng-if="osType === 'windows'">{{contentEntity.value | trimFolderName}}</span>
								<span data-ng-if="osType === 'unix'">{{contentEntity.value | trimUnixFolderName}}</span>
								<span data-ng-if="!$last" class="comma">,</span>
							</span>
						</span>
					</li>
				</ul>
			</div>
			<div class="page-details-box-links">
				<a href="" data-ng-if="isDeviceStolen && !details.isDLPRMEnabledOnClient" data-ng-click="eraseBackupContent()">
					<span><cv:msg key="label.eraseContent" bundle="devices"/></span>
				</a>
			</div>
		</cv-tile-component>
		<cv-plan-component subclient-id="subclientId" data-ng-if="(subclientId && showPlan && PlanSet) || (!PlanSet && editStorageEnabled) && !showActivateOption"
				type="Laptop" is-device="true" plan-entity="details.plan" disable-plan-link="noPlanPermission" data-show-loader="planLoading">
		</cv-plan-component>
		<cv-alert-component alerts='alerts'></cv-alert-component>

		<cv-tile-component data-ac-id="deviceDetails-label_archiving-exchange" data-title='<cv:msg key="label.archiving" bundle="exchange"/>' loader="details" min-height="true">
			<ul class="list-style-secondary">
			<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.archiving" bundle="devices"/></span>
					<span class="pageDetailColumn"> <toggle-control
								disabled="true"
								status="enableArchiving ? 'enabled-activity' : 'disabled-activity'"
								title="{{'label.enableDisable' | cvLoc}}"></toggle-control></span></li>
			</ul>
		</cv-tile-component>
		<cv-encrytion-setting-component generic-entity='genericEntity' client-props="generatePrivacyParams" show-edit="isClientOwner"></cv-encrytion-setting-component>
		<cv-entity-tags-tile data-ng-if="entityObject" entity="entityObject" has-edit-permissions="userHasEditTagsPermission"></cv-entity-tags-tile>
	</div>
</div>