<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.createLaptopProfile" bundle="profiles"/>
		<cv-help-component help-text="<cv:msg key="label.createPlanHelpText" bundle="profiles" />"></cv-help-component>
	</h1>
</div>
<div class="setup-content" data-ng-controller="createProfileController" data-ng-class="{ 'medium-width' : $state.is('dloSetup') }">
	<p class="{{generalSetupMessage.type}} serverMessage">{{generalSetupMessage.message}}</p>
	<p class="{{backupContentMessage.type}} serverMessage">{{backupContentMessage.message}}</p>
	<p class="{{planExistedMessage.type}} serverMessage">{{planExistedMessage.message}}</p>
	<p class="text-center"><a data-ng-click="goToCreatePlan()" data-ng-hide="showCreatePlanForm || !showPlanSkip"> <cv:msg key="label.CreateNewPlan" bundle="profiles" /></a></p>
	<cv-plan-creation-messages data-ng-if="showMessagesLoaded"show-messages=showMessages></cv-plan-creation-messages>
	<form data-ng-show="showPlanCreationForm && (showPlanSkip===false || showCreatePlanForm)" name="createProfileForm"
			data-cv-submit="createPlanFromSetup()" data-cv-validate="true" novalidate autocomplete="off" class="bootstrap-wrapper form-horizontal">
		<div class="panel panel-default">
		<div class="panel-body">
		<!-- // profile name start // -->
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="profileName"><cv:msg key="label.profileName" bundle="profiles" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input id="profileName" type="text" name="profileName" data-ng-model="globalTemplate.name" autofocus />
			</div>
		</div>
		<!-- // profile name end // -->
		<!-- // Primary Storage start // -->
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="storage"><cv:msg key="label.primaryStorage" bundle="profiles" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select id="storage"
						name="storage"
						data-ng-model="globalTemplate.storageInfo.primaryStorage"
						data-ng-options="storagePool.storagePoolEntity.storagePoolName for storagePool in storagePools">
					<option value=""><cv:msg key="placeholder.selectStorage" bundle="profiles" /></option>
				</select>
			</div>
		</div>
		<!-- // Primary Storage  end // -->
		<!-- // backup frequency start // -->
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="rpoHours"><cv:msg key="label.backupFrequency" bundle="profiles" /><cv-help-component help-text="<cv:msg key="info.help.rpo" bundle="profiles" /> <cv:msg key="info.help.laptopRpo" bundle="profiles" />"></cv-help-component></label>
			<div class="col-xs-12 col-md-8 col-lg-8 text-align-left cv-inline-wrapper">
				<input id="rpoHours"
						name="rpoHours"
						class="frequency-input"
						type="number"
						min="1"
						max="{{!isLaptopPlan ? '' : maximumRPOlimit}}"
						data-ng-pattern="/^[0-9]*$/"
						required
						data-ng-model="globalTemplate.rpoHours" /> <div ng-if="!isLaptopPlan">&nbsp;<cv:msg key="label.hours" bundle="schedule" /></div>
				<select data-ng-if="isLaptopPlan" ng-model="automaticScheduleType" data-ng-change="backupFreqChanged(automaticScheduleType)" data-ng-options="incrementalBackupFreq.value as incrementalBackupFreq.name for incrementalBackupFreq in automaticIncrementalBackupFreqs" class="no-float-auto laptop-backup-frequency-select"></select>
			</div>
		</div>
		<!-- // backup frequency end // -->
		<!-- // schedule start // -->
		<div class="form-group" data-ng-if="associatedSchedulesEnabled">
			<label class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="label.schedule" bundle="schedule" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div data-ng-repeat="schedule in addedSchedules" class="text-align-left line-height-31">
					<span data-uib-tooltip='<cv:msg key="error.rpoHours" bundle="profiles" />' data-tooltip-enable="(schedule.flags === slaFlag) && !globalTemplate.rpoHours">
						<a id="autoschedule" data-ng-click="editSchedule(schedule)"
								data-ng-class="{disabled: (schedule.flags === slaFlag) && !globalTemplate.rpoHours}">
							{{schedule.name}}
						</a>
					</span>
					<span data-ng-if="schedule.flags === slaFlag" class='parenthetical-text'>- <cv:msg key="label.rpoSchedule" bundle="profiles" /></span>
				</div>
			</div>
		</div>
		<!-- // schedule end // -->
		<!-- // Folders to backup start // -->
		<div class="form-group" data-ng-controller="profileBackupContentController">
			<label class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="label.folderToBackup" bundle="profiles" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<span>
					<uib-tabset justified="true">
						<!-- // windows tab starts // -->
						<uib-tab heading="Windows">
							<div class="create-profile-wrapper">
								<!-- // windows guts start  // -->
								<div class="peopleInfos ownerInfo">
									<div class="users-list margin" >
										<ul class="users-list__user less-padding group" data-ng-repeat="folder in windowsFolderSelected | orderBy track by $index">
											<li title="{{folder | trimFolderName}}">
												<span class="content-library-folder content-library-{{folder | trimFolderName}}" data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
													<span class="ellipsis-parent ellipsis-content padding-left-30">{{folder | trimFolderName}}
														<span data-ng-if="folder == '\\'" class='laptop-content-help-text'><cv:msg key='label.allContents' bundle='profiles' /></span>
													</span>
													<span class="delete-row"><a href="javascript:void(0);" data-ng-click="toggleWindowsFolderSelection(folder)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimFolderName}}">&times;</a></span>
												</span>
											</li>
										</ul>
									</div>
								</div>
								<!-- // windows guts end// -->
							</div>
							<!-- // windows add folder construct start // -->
							<div class="add-folder-options">
								<ul>
									<li data-ng-click="addFolder('windows')" ><a class="profile-action-link"><cv:msg key="label.addFolder" bundle="profiles"/></a></li>
								</ul>
							</div>
							<!-- // windows add folder construct end  // -->
						</uib-tab>
						<!-- // windows tab ends // -->
						<!-- // mac tab starts // -->
						<uib-tab heading="Mac">
							<div class="create-profile-wrapper">
								<!-- // mac guts start  // -->
								<div class="peopleInfos ownerInfo">
									<div class="users-list margin" >
										<ul class="users-list__user less-padding group" data-ng-repeat="folder in macFolderSelected | orderBy track by $index">
											<li title="{{folder | trimUnixFolderName}}">
												<span class="content-library-folder content-library-{{folder | trimUnixFolderName}}" data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
													<span class="ellipsis-parent ellipsis-content padding-left-30">{{folder | trimUnixFolderName}}
														<span data-ng-if="folder == '/'" class='laptop-content-help-text'><cv:msg key='label.allContents' bundle='profiles' /></span>
													</spam>
													<span class="delete-row"><a href="javascript:void(0);" data-ng-click="toggleMacFolderSelection(folder)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimUnixFolderName}}">&times;</a></span>
												</span>
											</li>
										</ul>
									</div>
								</div>
								<!-- // mac guts end// -->
							</div>
							<!-- // mac add folder construct start // -->
							<div class="add-folder-options">
								<ul>
									<li data-ng-click="addFolder('mac')"><a class="profile-action-link"><cv:msg key="label.addFolder" bundle="profiles" /></a></li>
								</ul>
							</div>
							<!-- // mac add folder construct end  // -->
						</uib-tab>
						<!-- // mac tab ends // -->
						<!-- // unix tab starts // -->
						<uib-tab heading="Unix">
							<div class="create-profile-wrapper">
								<!-- // unix guts start  // -->
								<div class="peopleInfos ownerInfo">
									<div class="users-list margin" >
										<ul class="users-list__user less-padding group" data-ng-repeat="folder in unixFolderSelected | orderBy track by $index">
											<li title="{{folder | trimUnixFolderName}}">
												<span class="content-library-folder content-library-{{folder | trimUnixFolderName}}" data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
													<span class="ellipsis-parent ellipsis-content padding-left-30">{{folder | trimUnixFolderName}}
														<span data-ng-if="folder == '/'" class='laptop-content-help-text'><cv:msg key='label.allContents' bundle='profiles' /></span>
													</span>
													<span class="delete-row"><a href="javascript:void(0);" data-ng-click="toggleUnixFolderSelection(folder)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimUnixFolderName}}">&times;</a></span>
												</span>
											</li>
										</ul>
									</div>
								</div>
								<!-- // unix guts end// -->
							</div>
							<!-- // unix add folder construct start // -->
							<div class="add-folder-options">
								<ul>
									<li data-ng-click="addFolder('unix')"><a class="profile-action-link"><cv:msg key="label.addFolder" bundle="profiles" /></a></li>
								</ul>
							</div>
							<!-- // unix add folder construct end  // -->
						</uib-tab>
						<!-- // Unix tab ends // -->
					</uib-tabset><!-- // entire tab set ends // -->
				</span>
			</div>
		</div>
		<!-- // Folders to backup end // -->
		<!-- // edge drive start // -->
		<div class="form-group" data-ng-if="maList.length > 0" data-ng-hide="maList.length === 1">
			<div class="col-lg-12">
				<input type="checkbox" id="setupEdgeDrive" name="setupEdgeDrive" data-ng-model="showSetupEdgeDrive" data-ng-change="toggleSetupEdgeDrive()" />
				<label for="setupEdgeDrive"><cv:msg key="label.setupEdgeDrive" bundle="profiles" /></label>
			</div>
		</div>
		<div class="form-group" data-ng-if="maList.length > 0" data-ng-hide="maList.length === 1">
			<label class="col-xs-12 col-md-4 col-lg-4" for="mediaAgent"><cv:msg key="label.indexServer" bundle="profiles" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select id="mediaAgent" name="mediaAgent" data-ng-model="globalTemplate.edgeDrive"
					data-ng-options="agent.clientName for agent in maList track by agent.clientId"
					data-ng-disabled="!showSetupEdgeDrive">
					<option value=""><cv:msg key="placeholder.mediaAgent" bundle="storage" /></option>
				</select>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for=""><cv:msg key="label.overrideRestrictions" bundle="profiles" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<cv-derive-settings class="create-plan-anchor" data-sealed="globalTemplate.sealed"
						data-tooltip-placement="top" data-model="globalTemplate.deriveSettingsInputModel">
					<cv-derive-select
							data-name="SubclientPolicyWin"
							data-label-class="col-xs-12"
							data-select-class="col-xs-12" data-class="row"><cv:msg key="label.folderToBackup" bundle="profiles" /></cv-derive-select>
					<cv-derive-select data-name="SubclientPolicyLin" data-group-with="SubclientPolicyWin"></cv-derive-select>
					<cv-derive-select data-name="SubclientPolicyMac" data-group-with="SubclientPolicyWin"></cv-derive-select>
					<cv-derive-select
							data-name="StoragePolicy"
							data-label-class="col-xs-12"
							data-select-class="col-xs-12"
							data-class="row"><span><cv:msg key="label.storagePool" bundle="profiles" /></span></cv-derive-select>
					<cv-derive-select
							data-name="SchedulePolicy"
							data-label-class="col-xs-12"
							data-select-class="col-xs-12"
							data-class="row"><cv:msg key="label.rpo" bundle="profiles" /></cv-derive-select>
					<cv-derive-select data-name="SubclientRetentionWin"
						data-label-class="col-xs-12"
						data-select-class="col-xs-12" data-class="row">
						<cv:msg key="label.retention" bundle="profiles" />
					</cv-derive-select>
					<cv-derive-select data-name="SubclientRetentionLin" data-group-with="SubclientRetentionWin"></cv-derive-select>
					<cv-derive-select data-name="SubclientRetentionMac" data-group-with="SubclientRetentionWin"></cv-derive-select>
				</cv-derive-settings>
			</div>
		</div>
		<!-- // edge drive  end// -->
		</div></div>
		<div class="button-container">
			<button id="createProfileSetup_button_#1102" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()" data-ng-if="showPlanSkip"><cv:msg key="Skip" /></button>
			<button id="createProfileSetup_button_#8663" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="disableNext"><cv:msg key="Save" /></button>
		</div>
	</form>
	<div data-ng-hide="showCreatePlanForm || !showPlanSkip" class="button-container centered">
		<button id="createProfileSetup_button_#9326" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="label.continue" bundle="profiles" /></button>
	</div>
</div>
