<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row bootstrap-wrapper">
	<div class="col-xs-12"
		data-ng-class="{'col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2': $state.current.name === 'createFsPlan'}">
		<cv-plan-creation-messages data-ng-if="showMessagesLoaded"show-messages=showMessages></cv-plan-creation-messages>
		<form class="form-horizontal" name="createFsProfileForm"
			data-cv-submit="createFsPlan()" data-cv-validate="true" novalidate autocomplete="off"
			data-ng-show="showPlanCreationForm && (!skipForSetup || showPlanSkip===false || showCreatePlanForm)"
			name="addServerPLanForm">
			<h1 class="page-header" data-ng-hide="acSetupPlan">
				<cv:msg key="label.createFsProfile" bundle="profiles" />
				<cv-help-component
					data-help-text="<cv:msg key="label.addServerPlanHelpText" bundle="profiles"/>"></cv-help-component>
				<br />
				<span data-ng-if="isDerived" class="subtext-unspaced small-size italic">
					<span><cv:msg key="label.basePlan" bundle="profiles" /></span>
					<span>-</span>
					<a data-ng-href="#profileDetails/{{baseProfileId}}">{{basePlanName}}</a>
				</span>
			</h1>
			<p class="{{generalSetupMessage.type}} serverMessage text-center">{{generalSetupMessage.message}}</p>
			<p class="{{serverMessage.type}} serverMessage text-center">{{serverMessage.message}}</p>
			<a data-ng-click="goToCreatePlan()"
				data-ng-hide="showCreatePlanForm || !showPlanSkip || !skipForSetup">
				<cv:msg key="label.CreateNewPlan" bundle="profiles" />
			</a>
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-lg-3" for="{{id}}planName"><cv:msg
								key="label.profileName" bundle="profiles" /></label>
						<div class="col-xs-12 col-lg-6">
							<input type="text" name="planName" data-autoselect="{{autoSelect || id === 'gold'}}"
								data-ng-model="globalTemplate.name" id="{{id}}planName" autofocus/>
						</div>
					</div>
				</div>
			</div>
			<uib-accordion close-others="true" class="text-left">
			<div uib-accordion-group data-ng-init="status.storagePool=true"
				data-is-open="status.storagePool">
				<uib-accordion-heading>{{'label.storagePool'
				| cvLoc}} <i class="float-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': status.storagePool, 'glyphicon-chevron-right': !status.storagePool}"></i></uib-accordion-heading>
				<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesStorage.definesEntity"
						class="form-group "data-toggle-class="col-xs-12 col-lg-3" data-help-text-class="col-xs-12 col-lg-9"
						data-ng-if="isDerived" data-derive-setting="globalTemplate.deriveSettings.definesStorage.overrideEntity">
				</cv-derivable-input-toggle>
				<div class="form-group" data-cv-derivable-input
							data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
					<label class="col-xs-12 col-lg-3" for="{{id}}primaryStorage"><cv:msg
							key="label.primaryStorage" bundle="profiles" /></label>
					<div class="col-xs-12 col-lg-3">
						<select id="{{id}}primaryStorage" name="primaryStorage"
							data-ng-model="globalTemplate.storageInfo.primaryStorage"
							data-ng-options="storagePool.storagePoolEntity.storagePoolName for storagePool in storagePools"
							data-ng-class="{'has-error': cv.addServerPLanForm.needsAttention(addServerPLanForm.primaryStorage)}"
							data-ng-change="changeSecondaryStorageList(globalTemplate.storageInfo.primaryStorage)">
							<option value=""><cv:msg key="placeholder.selectStorage"
									bundle="profiles" /></option>
						</select>
					</div>
					<div class="col-xs-12 col-lg-6">
						<div class="row">
							<label class="col-xs-4" for="primaryRetention"><cv:msg
									key="label.retentionDays" bundle="collections" /></label>
							<div class="col-xs-8">
								<input type="checkbox" id="primaryInfinite" style="" data-ng-model = "globalTemplate.storageInfo.primaryInfinite">
								<label class = "padding-right-20 inline-label" for="primaryInfinite"><cv:msg key="label.infinite" bundle="profiles"/></label>
								
								<cv-plan-day-input data-ng-if="!globalTemplate.storageInfo.primaryInfinite" data-cv-id="primaryRetention" data-cv-name="primaryRetention"
										data-cv-model="globalTemplate.storageInfo.primaryRetentionInDays">
								</cv-plan-day-input>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group" data-ng-show="globalTemplate.showSecondaryStorage"
						data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
					<label class="col-xs-12 col-lg-3" for="{{id}}secondaryStorage"><cv:msg
							key="label.secondaryStorage" bundle="profiles" /> </label>
					<div class="col-xs-12 col-lg-3">
						<select id="{{id}}secondaryStorage" name="secondaryStorage"
							data-ng-model="globalTemplate.storageInfo.secondaryStorage"
							data-ng-options="storagePool.storagePoolEntity.storagePoolName for storagePool in secondaryStoragePools"
							data-ng-class="{'has-error': cv.addServerPLanForm.needsAttention(addServerPLanForm.secondaryStorage)}">
							<option value=""><cv:msg
									key="placeholder.selectSecondaryStorage" bundle="profiles" /></option>
						</select>
					</div>
					<div class="col-xs-12 col-lg-6">
						<div class="row">
							<label data-ng-if="globalTemplate.storageInfo.secondaryStorage.storagePoolType != 'SECONDARY_COPY'" for="secondaryRetention" class="col-xs-4"><cv:msg
									key="label.retentionDays" bundle="collections" /></label>
							<div class="col-xs-8">
								<input data-ng-if="globalTemplate.storageInfo.secondaryStorage.storagePoolType != 'SECONDARY_COPY'" type="checkbox" id="secondaryInfinite" data-ng-model = "globalTemplate.storageInfo.secondaryInfinite">
								<label data-ng-if="globalTemplate.storageInfo.secondaryStorage.storagePoolType != 'SECONDARY_COPY'" class = "padding-right-20 inline-label" for="secondaryInfinite"><cv:msg key="label.infinite" bundle="profiles"/></label>
							
								<cv-plan-day-input data-ng-if="!globalTemplate.storageInfo.secondaryInfinite && globalTemplate.storageInfo.secondaryStorage.storagePoolType != 'SECONDARY_COPY'" data-cv-id="secondaryRetention" data-cv-name="secondaryRetention"
										data-cv-model="globalTemplate.storageInfo.secondaryRetentionInDays">
								</cv-plan-day-input>
								<label>
									<a href="" data-ng-click="handleAuxCopySchedule(!globalTemplate.showSecondaryStorage); globalTemplate.showSecondaryStorage = false">
										<span class="glyphicon glyphicon-remove"></span>
									</a>
								</label>
							</div>
						</div>
					</div>
					<span class="help-block-top"
						data-ng-show="!showPlanSkip && cv.addServerPLanForm.needsAttention(addServerPLanForm.secondaryRetention)"><cv:msg
							key="error.retentionPeriod" bundle="collections" /></span>
				</div>
				<div class="form-group" data-ng-if="!isSetup && enableSecondaryStorage && !globalTemplate.showSecondaryStorage"
						data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
					<div class="col-xs-12">
						<span
							data-uib-tooltip="{{!secondaryStoragePools || secondaryStoragePools <= 0 ? ('label.noMoreStoragePools' | cvLoc) : ''}}"
							data-ng-disabled="!secondaryStoragePools || secondaryStoragePools <= 0">
							<a href=""
							data-ng-click="handleAuxCopySchedule(!globalTemplate.showSecondaryStorage); globalTemplate.showSecondaryStorage = true">{{'label.addStorage'
								| cvLoc}}</a>
						</span>
					</div>
				</div>
			</div>
			</uib-accordion>
			<uib-accordion close-others="true" class="text-left">
			<div uib-accordion-group data-ng-init="status.openSla=false" is-open="status.openSla">
				<uib-accordion-heading>
					{{'label.rpo' | cvLoc}}
					<cv-help-component help-text="<cv:msg key="info.help.rpo" bundle="profiles"/>"></cv-help-component>
					<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': status.openSla, 'glyphicon-chevron-right': !status.openSla}"></i>
				</uib-accordion-heading>
				<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSchedule.definesEntity"
						class="form-group" data-toggle-class="col-xs-12 col-lg-3" data-help-text-class="col-xs-12 col-lg-9"
						data-ng-if="isDerived" data-derive-setting="globalTemplate.deriveSettings.definesSchedule.overrideEntity">
				</cv-derivable-input-toggle>
				<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
					<!--
					<div class="form-group">
						<label class="col-xs-4 col-lg-3" for="{{id}}sla"><cv:msg
								key="label.backupCoverage" bundle="profiles" /></label>
						<div class="col-xs-8 col-lg-9">
							<div class="form-inline">
								<select id="{{id}}sla" name="sla" data-ng-model="globalTemplate.slaInterval" class="number-select"
									data-ng-options="slaInterval for slaInterval in slaIntervals">
								</select>
								<span><cv:msg key="label.slaDays" bundle="profiles" /></span>
							</div>
						</div>
					</div>
					-->
					<div class="form-group">
						<label class="col-xs-4 col-lg-3" for="{{id}}rpo">
							<cv:msg key="label.backupFrequency" bundle="profiles" />
						</label>
						<div class="col-xs-8 col-lg-6">
							<input id="{{id}}rpo" name="rpo" type="number" min="1" required
								data-ng-model="globalTemplate.rpo"
								class="storage-retention-input sla-input" />
							<cv:msg key="label.hours" bundle="schedule" />
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-4 col-lg-3"><cv:msg key="label.backupWindow" bundle="profiles" /></label>
						<div class="col-xs-8 col-lg-9">
							<label>
								<cv-backup-window-list data-cv-model="globalTemplate.backupWindow"></cv-backup-window-list>
							</label>
						</div>
					</div>
				<div class="schedule" data-ng-if="associatedSchedulesEnabled">
					<div class="row">
						<div class="col-xs-12">
							<uib-accordion close-others="true" class="text-left">
							<div uib-accordion-group is-open="status.schedule">
								<uib-accordion-heading> <i
									class="glyphicon"
									data-ng-class="{'glyphicon-chevron-down': status.schedule, 'glyphicon-chevron-right': !status.schedule}"></i>
								<cv:msg key="label.associatedSchedule" bundle="schedule" /> <a
									data-ng-if="status.schedule" href=""
									class="pull-right accordion-heading-action-link"
									data-ng-class="{disabled: isDerived && !globalTemplate.deriveSettings.definesSchedule.definesEntity}"
									data-ng-click="$event.stopPropagation(); addSchedule()"><cv:msg
										key="label.addSchedule" bundle="profiles" /></a> </uib-accordion-heading>
								<div class="schedule-list">
									<ul class="add-schedule__List group"
										data-ng-repeat="schedule in addedSchedules track by $index">
										<li class="ellipsis-parent ellipsis-content "><a class="always-enabled"
											data-ng-click="editSchedule(schedule)">{{schedule.name}}</a><span
											data-ng-if="schedule.flags === slaFlag"
											class='parenthetical-text'>- <cv:msg
													key="label.rpoSchedule" bundle="profiles" /></span></li>
									</ul>
									<ul class="add-schedule__List group"
										data-ng-if="addedSchedules.length==0">
										<li class="ellipsis-parent ellipsis-content "><cv:msg
												key="error.noScheduleAdded" bundle="schedule" /></li>
									</ul>
								</div>
							</div>
							</uib-accordion>
						</div>
					</div>
				</div>
				</cv-derivable-input>
			</div>
			</uib-accordion>
			<uib-accordion>
			<div uib-accordion-group is-open="status.folderToBackup"
				data-scroll-to-when-open>
				<uib-accordion-heading> <cv:msg
					key="label.folderToBackup" bundle="profiles" /> <i
					class="float-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': status.folderToBackup, 'glyphicon-chevron-right': !status.folderToBackup}"></i></uib-accordion-heading>
				<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSubclientWin.definesEntity"
						class="form-group" data-toggle-class="col-xs-12 col-lg-3" data-help-text-class="col-xs-12 col-lg-9"
						data-ng-if="isDerived" data-derive-setting="globalTemplate.deriveSettings.definesSubclientWin.overrideEntity">
				</cv-derivable-input-toggle>
				<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSubclientWin.definesEntity">
					<div class="backup-content"
						data-ng-controller="profileBackupContentController">
						<div class="col-xs-12 col-lg-10 col-lg-offset-1">
							<div class="{{backupContentMessage.type}} serverMessage">{{backupContentMessage.message}}</div>
							<span class="angular-tab-wrapper"> <uib-tabset
									justified="true"> <!-- // windows starts // --> <uib-tab
									heading="Windows">
								<div id="backup-content-wrapper">
									<div class="content-checkboxes">
										<div id="backup-content-folders">
											<div class="content-header clearfix">
												<h4>
													<cv:msg key="label.contentToBackup" bundle="profiles" />
												</h4>
												<div class="content-header-actions">
													<span class="page-action-item" data-ng-hide="(acSetupPlan && !windowsFolderSelected.length) || (windowsFolderSelected.length ===1 && windowsFolderSelected[0] === '\\')"> 
															<a href="" data-ng-click="deleteAll('windows')"><cv:msg key="label.removeAll" bundle="profiles" /></a>
													</span>
													<span class="page-action-item"> <a href=""
														data-ng-click="addFolder('windows')"><cv:msg
																key="action.add" bundle="profiles" /></a>
													</span>
												</div>
											</div>
											<div class="peopleInfos ownerInfo">
												<div class="users-list limit-modal-height">
													<ul class="users-list__user less-padding group"
														data-ng-repeat="folder in windowsFolderSelected track by $index">
														<li title="{{folder | trimFolderName}}"><span
															class="content-library-folder content-library-{{folder | trimFolderName}}"
															data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
																<label for="windows-{{folder}}"
																class="ellipsis-parent ellipsis-content">{{folder
																	| trimFolderName}} <span data-ng-if="folder == '\\'" class='laptop-content-help-text'><cv:msg key='label.allContents' bundle='profiles'/></span></label> <span class="delete-row"><a
																	href="javascript:void(0);"
																	data-ng-click="toggleWindowsFolderSelection(folder)"
																	title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{folder | trimFolderName}}">&times;</a></span>
														</span>
														</li>
													</ul>
													<div class="backup-content-empty" ng-hide="windowsFolderSelected.length" ng-click="addFolder('windows')">
														<div>
															<svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72">
																<path d="M0,10.2l29.4-4V34.5L0,34.7ZM29.4,37.8V66.1L0,62V37.6ZM33,5.7,72,0V34.1l-39,.3ZM72,38V72L33,66.5V38Z"/>
															</svg>
														</div>														
														<div>
															<h4><cv:msg key="label.addContentToBackup" bundle="profiles" /></h4>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div id="exclude-folders">
											<div class="content-header clearfix">
												<h4>
													<cv:msg key="label.excludes" bundle="profiles" />
												</h4>
												<div class="content-header-actions">													
													<span class="page-action-item" data-ng-if="windowsExcludeSelected.length"> 
														<a href="" data-ng-click="deleteAll('windows', true)"><cv:msg key="label.removeAll" bundle="profiles" /></a>
													</span>
													<span class="page-action-item" > <a href=""
														data-ng-click="addFolder('windows', true)"><cv:msg
																key="action.add" bundle="profiles" /></a>
													</span>
												</div>
											</div>
											<div class="peopleInfos ownerInfo">
												<div class="users-list limit-modal-height">
													<ul class="users-list__user less-padding group"
														data-ng-repeat="exclude in windowsExcludeSelected track by $index">
														<li title="{{exclude}}"><span
															class=" content-library-folder content-library-{{exclude | trimFolderName}}"
															data-ng-class="{'content-library-file' : {{exclude | isFolder}} === false}">
																<label for="windows-{{exclude}}"
																class="ellipsis-parent ellipsis-content">{{exclude
																	| trimFolderName}} </label> <span class="delete-row"><a
																	href="javascript:void(0);"
																	data-ng-click="toggleWindowsExcludeSelection(exclude)"
																	title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{exclude | trimFolderName}}">&times;</a></span>
														</span></li>
													</ul>
													<div class="backup-content-empty" ng-hide="windowsExcludeSelected.length" ng-click="addFolder('windows', true)">
														<div>
															<svg xmlns="http://www.w3.org/2000/svg" width="84" height="84" viewBox="0 0 84 84">
																<path d="M29.1,37.4v28L0,61.4V37.2L29.1,37.4z M71.2,0L32.6,5.6v28.5l38.6-0.3V0z M39.6,64.3
																	c0.1-13.6,11.1-24.6,24.7-24.7c2.3,0,4.7,0.3,6.9,1v-3H32.6v28.2l7.1,1C39.6,66,39.6,65.1,39.6,64.3z M0,10.1v24.2l29.1-0.2v-28
																	L0,10.1z M84,64.2c0-10.9-8.9-19.8-19.8-19.8c-10.9,0-19.8,8.9-19.8,19.8c0,10.9,8.9,19.8,19.8,19.8S84,75.1,84,64.2L84,64.2z
																		M79.1,63.2c0.7,8.2-5.4,15.4-13.6,16.1c-8.2,0.7-15.4-5.4-16.1-13.6c-0.1-0.8-0.1-1.6,0-2.4c0.7-8.2,7.9-14.3,16.1-13.6
																	C72.7,50.2,78.5,55.9,79.1,63.2z M74.1,64.2c0-1.4-1.1-2.5-2.5-2.5H56.8c-1.4,0-2.5,1.1-2.5,2.5c0,1.4,1.1,2.5,2.5,2.5h14.8
																	C73,66.7,74.1,65.6,74.1,64.2z"/>
															</svg>
														</div>														
														<div>
															<h4><cv:msg key="label.addExcludes" bundle="profiles" /></h4>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div>
											<div class="peopleInfos ownerInfo">
												<div class="row">
													<div class="col-xs-12">
														<div class="form-group">
															<input type="checkbox" id="{{id}}backupSystemState"
																data-ng-click="globalTemplate.contentInfo.windows.backupSystemStateforFullBkpOnly = (!globalTemplate.contentInfo.windows.backupSystemState ? false : globalTemplate.contentInfo.windows.backupSystemStateforFullBkpOnly); globalTemplate.contentInfo.windows.useVSSForSystemState = (!globalTemplate.contentInfo.windows.backupSystemState ? false : globalTemplate.contentInfo.windows.useVSSForSystemState);"
																data-ng-model="globalTemplate.contentInfo.windows.backupSystemState"
																data-ng-true-value="true" data-ng-false-value="false" />
															<label for="{{id}}backupSystemState">{{'label.backupSystemState'
																| cvLoc}}</label>
														</div>
														<div class="row systemstate-options"
															data-ng-disabled="!globalTemplate.contentInfo.windows.backupSystemState">
															<div class="col-md-4 form-group">
																<input type="checkbox"
																	id="{{id}}backupSystemStateforFullBkpOnly"
																	data-ng-model="globalTemplate.contentInfo.windows.backupSystemStateforFullBkpOnly"
																	data-ng-true-value="true" data-ng-false-value="false" />
																<label for="{{id}}backupSystemStateforFullBkpOnly">{{'label.backupSystemStateforFullBkpOnly'
																	| cvLoc}}</label>
															</div>
															<div class="col-md-4 form-group">
																<input type="checkbox" id="{{id}}useVSSForSystemState"
																	data-ng-model="globalTemplate.contentInfo.windows.useVSSForSystemState"
																	data-ng-true-value="true" data-ng-false-value="false" />
																<label for="{{id}}useVSSForSystemState">{{'label.useVSSForSystemState'
																	| cvLoc}}</label>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								</uib-tab> <!-- // windows ends // --> <!-- // mac starts // --> <uib-tab
									heading="Mac" data-ng-if="!fsPlan">
								<div id="backup-content-wrapper">
									<div class="content-checkboxes">
										<div id="backup-content-folders">
											<div class="content-header clearfix">
												<h4>
													<cv:msg key="label.contentToBackup" bundle="profiles" />
												</h4>
												<div class="content-header-actions">
													<span class="page-action-item" data-ng-hide="(acSetupPlan && !macFolderSelected.length) || (macFolderSelected.length ===1 && macFolderSelected[0] === '/')"> 
														<a href="" data-ng-click="deleteAll('mac')"><cv:msg key="label.removeAll" bundle="profiles" /></a>
													</span>
													<span class="page-action-item"> <a href=""
														data-ng-click="addFolder('mac')"><cv:msg
																key="action.add" bundle="profiles" /></a>
													</span>
												</div>
											</div>
											<div class="peopleInfos ownerInfo">
												<div class="users-list limit-modal-height">
													<ul class="users-list__user less-padding group"
														data-ng-repeat="folder in macFolderSelected track by $index">
														<li title="{{folder | trimFolderName}}"><span
															class=" content-library-folder content-library-{{folder | trimUnixFolderName}}"
															data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
																<label for="mac-{{folder}}"
																class="ellipsis-parent ellipsis-content">{{folder
																	| trimUnixFolderName}} <span data-ng-if="folder == '/'" class='laptop-content-help-text'><cv:msg key='label.allContents' bundle='profiles'/></span></label> <span class="delete-row"><a
																	href="javascript:void(0);"
																	data-ng-click="toggleMacFolderSelection(folder)"
																	title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{folder | trimUnixFolderName}} ">&times;</a></span>
														</span></li>
													</ul>
													<div class="backup-content-empty" ng-hide="macFolderSelected.length" ng-click="addFolder('mac')">
														<div>
															<svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72">
																<path d="M66.5,52.8a55.1,55.1,0,0,1-4.6,8.7c-3,4.7-7.2,10.4-12.5,10.5s-5.8-3.1-12.1-3.1S29.7,72,25,
																72s-9.2-5.3-12.2-9.9C4.4,49.2,3.5,34,8.7,25.9c3.7-5.7,9.5-9,14.9-9s9,3,13.6,3,7.2-3.1,13.6-3.1c4.8,0,
																10,2.7,13.6,7.3C52.4,30.8,54.4,48.2,66.5,52.8ZM45.9,11.7A15.8,15.8,0,0,0,49.4,0,17,17,0,0,0,38.5,5.9c-2.3,2.9-4.3,7.2-3.5,
																11.4C39.1,17.4,43.4,14.9,45.9,11.7Z"/>
															</svg>
														</div>
														<div>
															<h4><cv:msg key="label.addContentToBackup" bundle="profiles" /></h4>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div id="exclude-folders">
											<div class="content-header clearfix">
												<h4>
													<cv:msg key="label.excludes" bundle="profiles" />
												</h4>
												<div class="content-header-actions">
													<span class="page-action-item" data-ng-if="macExcludeSelected.length"> 
														<a href="" data-ng-click="deleteAll('mac', true)"><cv:msg key="label.removeAll" bundle="profiles" /></a>
													</span>
													<span class="page-action-item"> <a href=""
														data-ng-click="addFolder('mac', true)"><cv:msg
																key="action.add" bundle="profiles" /></a>
													</span>
												</div>
											</div>
											<div class="peopleInfos ownerInfo">
												<div class="users-list limit-modal-height">
													<ul class="users-list__user less-padding group"
														data-ng-repeat="exclude in macExcludeSelected track by $index">
														<li title="{{exclude}}"><span
															class=" content-library-folder content-library-{{exclude | trimUnixFolderName}}"
															data-ng-class="{'content-library-file' : {{exclude | isFolder}} === false}">
																<label for="mac-{{exclude}}"
																class="ellipsis-parent ellipsis-content">{{exclude
																	| trimUnixFolderName}} </label> <span class="delete-row"><a
																	href="javascript:void(0);"
																	data-ng-click="toggleMacExcludeSelection(exclude)"
																	title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{exclude | trimUnixFolderName}}">&times;</a></span>
														</span></li>
													</ul>
													<div class="backup-content-empty" ng-hide="macExcludeSelected.length" ng-click="addFolder('mac', true)">
														<div>
															<svg xmlns="http://www.w3.org/2000/svg" width="84" height="84" viewBox="0 0 84 84">
																<path d="M29.2,17.1c-0.8-4.1,1.2-8.4,3.5-11.2c2.7-3.2,6.5-5.3,10.7-5.9c0.7,4.3-1.1,8.6-3.4,11.6S33.3,17.3,29.2,17.1
																	z M39.6,64.3c0-8.6,4.5-16.6,11.8-21.1c-2.9-7.3,0-15.6,6.9-19.3c-3.6-4.6-8.7-7.2-13.5-7.2s-9,3-13.4,3s-8-3-13.5-3
																	S6.8,20,3.2,25.7c-5.1,8-4.3,23,4,35.8c3,4.5,6.9,9.7,12.1,9.7s5.9-2.9,12.2-3c4.6,0,6.4,1.7,8.9,2.5
																	C39.9,68.6,39.6,66.5,39.6,64.3z M84,64.2c0-10.9-8.9-19.8-19.8-19.8c-10.9,0-19.8,8.9-19.8,19.8c0,10.9,8.9,19.8,19.8,19.8
																	S84,75.1,84,64.2L84,64.2z M79.1,63.2c0.7,8.2-5.4,15.4-13.6,16.1c-8.2,0.7-15.4-5.4-16.1-13.6c-0.1-0.8-0.1-1.6,0-2.4
																	c0.7-8.2,7.9-14.3,16.1-13.6C72.7,50.2,78.5,55.9,79.1,63.2z M74.1,64.2c0-1.4-1.1-2.5-2.5-2.5H56.8c-1.4,0-2.5,1.1-2.5,2.5
																	c0,1.4,1.1,2.5,2.5,2.5h14.8C73,66.7,74.1,65.6,74.1,64.2z"/>
															</svg>
														</div>
														<div>
															<h4><cv:msg key="label.addExcludes" bundle="profiles" /></h4>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								</uib-tab> <!-- // mac ends // --><!-- // Unix starts // --> <uib-tab
									heading="Unix">
								<div id="backup-content-wrapper">
									<div class="content-checkboxes">
										<div id="backup-content-folders">
											<div class="content-header clearfix">
												<h4>
													<cv:msg key="label.contentToBackup" bundle="profiles" />
												</h4>
												<div class="content-header-actions">
													<span class="page-action-item" data-ng-hide="(acSetupPlan && !unixFolderSelected.length) || (unixFolderSelected.length ===1 && unixFolderSelected[0] === '/')"> 
														<a href="" data-ng-click="deleteAll('unix')"><cv:msg key="label.removeAll" bundle="profiles" /></a>
													</span>
													<span class="page-action-item"> <a href=""
														data-ng-click="addFolder('unix')"><cv:msg
																key="action.add" bundle="profiles" /></a>
													</span>
												</div>
											</div>
											<div class="peopleInfos ownerInfo">
												<div class="users-list limit-modal-height">
													<ul class="users-list__user less-padding group"
														data-ng-repeat="folder in unixFolderSelected track by $index">
														<li title="{{folder | trimFolderName}}"><span
															class=" content-library-folder content-library-{{folder | trimUnixFolderName}}"
															data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
																<label for="unix-{{folder}}"
																class="ellipsis-parent ellipsis-content">{{folder
																	| trimUnixFolderName}} <span data-ng-if="folder == '/'" class='laptop-content-help-text'><cv:msg key='label.allContents' bundle='profiles'/></span> </label> <span class="delete-row"><a
																	href="javascript:void(0);"
																	data-ng-click="toggleUnixFolderSelection(folder)"
																	title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{folder | trimUnixFolderName}}">&times;</a></span>
														</span></li>
													</ul>
													<div class="backup-content-empty" ng-hide="unixFolderSelected.length" ng-click="addFolder('unix')">
														<div>
															<svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72">
																<path d="M19.9,50a1.1,1.1,0,0,1-.2-.6l.8.9C20.4,50.4,20.2,50.2,19.9,50ZM66.4,61a2,2,0,0,1-.9,
																1.8c-.7.6-3.9,2.3-6.1,3.7a33,33,0,0,0-4.6,3.6A5.9,5.9,0,0,1,50,72a5.1,5.1,0,0,1-3.6-1,4.6,4.6,0,0,
																1-1.1-2c-4.5-1.2-5.8-1-10.5-.7s-3.8-.1-6.2,1l-1.1.9c-1.4,1.2-1.8,1.9-4.1,
																1.8s-5.6-2.1-9.1-2.8c-6.6-1.4-7.7-1.7-8.5-2.9a3,3,0,0,1,0-2.3,18.5,18.5,0,0,0,.3-2.9c0-2.9-.8-4.4,0-5.5s4-1,
																5.3-1.9,2.1-2.8,2.9-3.5.1-.1.1-.2c-.8-3.2-.6-3.6.9-7.4a57.7,57.7,0,0,1,5.1-10.3c2.8-4.2,5.8-6.5,5.6-9.7-.9-12.2-1.6-18.3,
																3.8-21.1A11.9,11.9,0,0,1,44.3,3.8,12.1,12.1,0,0,1,47,9.6c1.2,5-.5,3.4.9,9.1s3.9,8.6,7.1,13.1,6.6,12.1,5.5,16.4a24.3,24.3,
																0,0,1-1,2.8,1.2,1.2,0,0,1,1,.5c.9,1.3,0,3,.6,4a17,17,0,0,0,4,3.8C65.6,59.6,66.5,60,66.4,61ZM35.2,14.5a5.1,5.1,0,0,0,.2,
																1.3l1.1.4.5.4a8.8,8.8,0,0,1-.2-1.6,3,3,0,0,1,.6-1.8,2,2,0,0,1,1.3-.4c1.1,0,1.7.9,1.9,2.2a2,2,0,0,1-.4,1.6,2.2,2.2,0,0
																,1-1.3.8,11.4,11.4,0,0,1,2.2.7,3.2,3.2,0,0,0,1-1.8,4.9,4.9,0,0,0-.6-4.3c-.8-1.6-1.4-1.8-2.6-1.9a3.3,3.3,0,0,0-3.4,2.2A3.8,
																3.8,0,0,0,35.2,14.5Zm-7.4,2.4a4.1,4.1,0,0,0,.8,1.3c.1-.2.3-.3.4-.4l.5-.4c-.3-.1-.4-.3-.8-.7a3,3,0,0,1-.6-1.7,3.2,3.2,0,0,1,
																.2-1.6,1.2,1.2,0,0,1,1.1-.5,1.6,1.6,0,0,1,1.2.6,2.5,2.5,0,0,1,.5,1.5,5.1,5.1,0,0,1-.2,1.3l.6-.3.6-.2a6.3,6.3,0,0,0,.2-1.6,4.2,
																4.2,0,0,0-1.1-2.8,2.3,2.3,0,0,0-2.3-.8c-.4,0-.9.5-1.2,1.2a4.7,4.7,0,0,0-.4,1.7A8.4,8.4,0,0,0,27.8,16.9ZM45.2,59.8a9.4,9.4,0,0,
																0,1-1c.1-1.3,0-2.8,0-4.1s.1-3.6.5-3.9a2.4,2.4,0,0,1,1.8-.5h1.2c.1-1.1.3-2.8.3-3.7a32.6,32.6,0,0,0-1-8.1,43,43,0,0,
																0-2.5-5.3c-1.7-3.7-1.6-5.4-3.1-7.8s-1.2-3.1-1.7-3.8A2.8,2.8,0,0,1,39.9,23c-1.4.4-3.7,2.7-5.6,2.7a7.4,7.4,0,0,1-2.6-.2,17.2,
																17.2,0,0,1-2.5-2.1l-1.3-1.1h0a21.7,21.7,0,0,0-.2,3.6c0,1.1-.6,1.2-1.7,3a15.9,15.9,0,0,0-1.5,2.9l-.6,1.9c0,.3-.2.6-.2.9-.6,2.2-2.7,
																4.8-3.1,6.9a19.3,19.3,0,0,0-1,6.3,6.2,6.2,0,0,0,.1,1.6,7.2,7.2,0,0,1-1.1-1.5,7.1,7.1,0,0,1-.6-3.8,16.1,16.1,0,0,1,1.5-5.2c1.1-2.5,
																1.9-3.1,1.6-3.3s-1.1,1.6-1.4,2.3a20.8,20.8,0,0,0-2,6.1,7.3,7.3,0,0,0,.5,3.8A10.1,10.1,0,0,0,19.9,50l.6.5c.9.7,1.8,1.4,3.1,2.6s4.3,
																3.3,4.7,4a2.4,2.4,0,0,1,.2,2.7c-.5.7-1.9.8-2.7.8,1,1.5,1.9,2.4,2.6,3.4s3.2,1.5,8.3.5A17.2,17.2,0,0,0,45.2,59.8Z"/>
															</svg>
														</div>
														<div>
															<h4><cv:msg key="label.addContentToBackup" bundle="profiles" /></h4>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div id="exclude-folders">
											<div class="content-header clearfix">
												<h4>
													<cv:msg key="label.excludes" bundle="profiles" />
												</h4>
												<div class="content-header-actions">
													<span class="page-action-item" data-ng-if="unixExcludeSelected.length"> 
														<a href="" data-ng-click="deleteAll('unix', true)"><cv:msg key="label.removeAll" bundle="profiles" /></a>
													</span>
													<span class="page-action-item"> <a href=""
														data-ng-click="addFolder('unix', true)"><cv:msg
																key="action.add" bundle="profiles" /></a>
													</span>
												</div>
											</div>
											<div class="peopleInfos ownerInfo">
												<div class="users-list limit-modal-height">
													<ul class="users-list__user less-padding group"
														data-ng-repeat="exclude in unixExcludeSelected track by $index">
														<li title="{{exclude}}"><span
															class=" content-library-folder content-library-{{exclude | trimUnixFolderName}}"
															data-ng-class="{'content-library-file' : {{exclude | isFolder}} === false}">
																<label for="unix-{{exclude}}"
																class="ellipsis-parent ellipsis-content">{{exclude
																	| trimUnixFolderName}} </label> <span class="delete-row"><a
																	href="javascript:void(0);"
																	data-ng-click="toggleUnixExcludeSelection(exclude)"
																	title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{exclude | trimUnixFolderName}}">&times;</a></span>
														</span></li>
													</ul>
													<div class="backup-content-empty" ng-hide="unixExcludeSelected.length" ng-click="addFolder('unix', true)">
														<div>
															<svg xmlns="http://www.w3.org/2000/svg" width="84" height="84" viewBox="0 0 84 84">
																<path d="M39.6,64.3c0-9.6,5.6-18.3,14.3-22.4c-1.1-3.7-2.8-7.2-5-10.4c-3.2-4.5-5.8-7.3-7.1-13s0.4-4-0.8-9
																	c-0.4-2.1-1.3-4-2.6-5.7c-0.9-1.1-2-1.9-3.3-2.5C31.6-0.5,27.4-0.4,24,1.5c-5.3,2.7-4.6,8.8-3.8,20.8c0.3,3.3-2.8,5.5-5.5,9.7
																	c-2,3.2-3.7,6.6-5.1,10.1c-1.5,3.8-1.6,4.2-0.8,7.4l-0.2,0.2c-0.7,0.7-1.6,2.5-2.8,3.5S1.3,54,0.5,55s0,2.6,0,5.5
																	c0,0.9-0.1,1.9-0.3,2.8C-0.1,64,0,64.9,0.3,65.6c0.7,1.2,1.8,1.5,8.3,2.8c3.5,0.8,6.8,2.6,9.1,2.8s2.6-0.5,4-1.7l1.1-0.9
																	c2.4-1.1,1.7-0.7,6.1-1s6-0.5,10.4,0.7c0.1,0.7,0.5,1.3,1,1.8C39.8,68.2,39.6,66.3,39.6,64.3z M29.6,12.1c0.5-1.3,1.9-2.2,3.3-2.2
																	c1.3,0.1,1.8,0.4,2.7,2c0.8,1.3,1,2.8,0.6,4.2c-0.1,0.7-0.5,1.4-1.1,1.8L33,17.2c0.5-0.1,1-0.4,1.3-0.8c0.3-0.5,0.5-1,0.4-1.6
																	c-0.2-1.2-0.8-2.1-1.9-2.1c-0.5-0.1-0.9,0.1-1.3,0.4c-0.4,0.5-0.7,1.1-0.6,1.7c0,0.5,0.1,1.1,0.2,1.6l-0.5-0.3l-1.1-0.5
																	c-0.1-0.4-0.2-0.8-0.2-1.2C29.2,13.6,29.3,12.8,29.6,12.1z M21.5,13.3c0-0.6,0.2-1.1,0.4-1.6c0.3-0.7,0.8-1.2,1.2-1.2
																	c0.8-0.2,1.7,0.1,2.2,0.8C26,12,26.4,13,26.4,14c0,0.5,0,1.1-0.1,1.6l-0.6,0.2l-0.6,0.3c0.1-0.4,0.1-0.8,0.1-1.2
																	c0-0.5-0.1-1-0.4-1.5c-0.3-0.4-0.7-0.6-1.2-0.7c-0.4,0-0.9,0.2-1.1,0.6c-0.2,0.5-0.3,1-0.2,1.5c0,0.6,0.2,1.2,0.6,1.7
																	c0.4,0.4,0.5,0.7,0.8,0.7l-0.5,0.4L22.8,18c-0.4-0.4-0.6-0.8-0.8-1.3C21.6,15.6,21.4,14.5,21.5,13.3z M39.2,59.2
																	c-2.2,2.4-5.2,4-8.4,4.6c-5,1-7.3,0.1-8.2-0.5c-0.9-1-1.7-2.1-2.5-3.3c0.9,0,1.9-0.2,2.6-0.8c0.4-0.9,0.4-1.9-0.2-2.7
																	c-0.4-0.7-3.3-2.8-4.7-4s-2.1-1.8-3-2.5l-0.6-0.5c-0.7-0.7-1.2-1.4-1.7-2.2c-0.5-1.2-0.7-2.5-0.5-3.8c0.3-2.1,0.9-4.1,1.9-6
																	c0.4-0.7,1.3-2.5,1.5-2.3s-0.6,0.8-1.6,3.3c-0.8,1.6-1.3,3.4-1.5,5.2c-0.1,1.3,0.1,2.5,0.6,3.7c0.3,0.5,0.7,1,1.1,1.5
																	c-0.1-0.5-0.1-1.1-0.1-1.6c-0.1-2.8,0.5-4.1,0.9-6.2s2.5-4.7,3.1-6.8l0.3-1c0.2-0.6,0.4-1.2,0.6-1.8c0.3-1,0.8-2,1.4-2.9
																	c1.1-1.8,1.7-1.8,1.7-3c0-1.2,0-2.3,0.2-3.5l0,0l1.2,1.1c1.1,0.9,1.9,2,2.6,2.2c0.9,0.2,1.7,0.2,2.6,0.2c1.8,0,4.1-2.3,5.4-2.7
																	c0.8-0.2,1.5-0.7,1.9-1.4c0.5,0.7,0.5,2.1,1.6,3.9s1.4,4,3.1,7.6c0.9,1.7,1.7,3.5,2.4,5.3c0.7,2.6,1.1,5.3,1,8
																	c0,1.2-0.1,2.5-0.3,3.7h-1.1c-0.6-0.1-1.3,0.1-1.8,0.5c-0.4,0.2-0.5,1.9-0.5,3.8s0.1,2.8,0,4.1L39.2,59.2z M14.2,49.5
																	c-0.1-0.2-0.2-0.4-0.2-0.6c0.4,0.5,0.8,0.8,0.7,0.9S14.5,49.7,14.2,49.5z M64.2,84c-10.9,0-19.8-8.9-19.8-19.8
																	c0-10.9,8.9-19.8,19.8-19.8c10.9,0,19.8,8.9,19.8,19.8S75.1,84,64.2,84L64.2,84z M63.2,49.4c-8.2,0.7-14.3,7.9-13.6,16.1
																	c0.6,7.3,6.4,13,13.6,13.6c8.2,0.7,15.4-5.4,16.1-13.6c0.7-8.2-5.4-15.4-13.6-16.1C64.8,49.3,64,49.3,63.2,49.4z M71.6,66.7H56.8
																	c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5h14.8c1.4,0,2.5,1.1,2.5,2.5C74.1,65.6,73,66.7,71.6,66.7z"/>
															</svg>
														</div>
														<div>
															<h4><cv:msg key="label.addExcludes" bundle="profiles" /></h4>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
						</div>
						</uib-tab>
						</uib-tabset>
						</span>
					</div>
					<!-- // plan-global-options div ends // -->
				</cv-derivable-input>
			</div>
			</uib-accordion>
			<cv-derive-settings data-sealed="globalTemplate.sealed" data-model="globalTemplate.deriveSettingsInputModel">
				<cv-derive-select data-name="StoragePolicy" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
					<span><cv:msg key="label.storagePool" bundle="profiles" /></span><%--
					<span class="subtext-spaced full-size"><cv:msg key="label.retentionDays" bundle="collections" /></span>--%>
				</cv-derive-select>
				<cv-derive-select data-name="SchedulePolicy" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
					<cv:msg key="label.rpo" bundle="profiles" />
				</cv-derive-select>
				<cv-derive-select data-name="SubclientPolicyWin" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
					<cv:msg key="label.folderToBackup" bundle="profiles" />
				</cv-derive-select>
				<cv-derive-select data-name="SubclientPolicyLin" data-group-with="SubclientPolicyWin"></cv-derive-select>
				<cv-derive-select data-name="SubclientPolicyMac" data-group-with="SubclientPolicyWin"></cv-derive-select>
			</cv-derive-settings>
			<div class="button-container text-right" data-ng-hide="acSetupPlan">
				<button id="createFsProfile_button_#9837" type="submit" class="btn btn-primary cvBusyOnAjax" 
					data-ng-disabled="!storagePools || addedSchedules.length==0 || storagePools.length==0">
					<cv:msg key="Save" />
				</button>
			</div>
		</form>
	</div>
</div>