<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.createArchivalPlan" bundle="profiles"/>
		<cv-help-component ng-if="!showPlanSkip" help-text='<cv:msg key="label.addArchivalPlanHelpText" bundle="profiles" />'></cv-help-component>
	</h1>
</div>
<div class="setup-content server-plan medium-width server-backup-plan archival-plan setup-page" ng-class="{'archive-dialog-mode': dialogMode}">
	<div ng-class="generalSetupMessage.type" class="serverMessage" ng-bind="generalSetupMessage.message"></div>
	<p class="text-center"><a ng-click="goToCreatePlan()" ng-hide="(showCreateNewProfileLink === false) ? true : showCreatePlanForm || !showPlanSkip || formConfig.hide === false"> <cv:msg key="label.CreateNewPlan" bundle="profiles" /></a></p>
    <cv-plan-creation-messages ng-if="showMessagesLoaded" show-messages=showMessages></cv-plan-creation-messages>
    <form class="bootstrap-wrapper"
  		ng-show="!formConfig.hide && (!skipForSetup || showPlanSkip===false || showCreatePlanForm || $state.current.name === 'acSetup')"
  		name="addArchivalPlanForm"
  		data-cv-submit="addArchivalPlan()"
  		data-cv-validate="true"
  		novalidate
  		autocomplete="off">
        <div class="panel panel-default">
            <div class="panel-body">
                <!-- // name // -->
                <div class="global-options remove-border-padding page-details-box">
                    <ul class="list-style-secondary page-details">
                        <li class="group">
                            <span class="pageDetailColumn">
                                <label for="planName"><cv:msg key="label.profileName" bundle="profiles" /></label>
                            </span>
                            <span class="pageDetailColumn">
                                <input type="text" name="planName" ng-model="globalTemplate.name" id="planName" autofocus />
                            </span>
                        </li>
                    </ul>
                </div>
                <!-- // storage // -->
                <div class="storage" ng-if="storagePoolsLoaded">
                    <h4 class="plan">
                        <span><cv:msg key="label.plan.storageAndRetention" bundle="profiles" /></span>
                        <span ng-hide="skipForSetup" class="pull-right" data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
                            <a ng-click="addStorage()" ng-class="{'disabled' : !storagePoolsLoaded}">
                                <cv:msg key="label.addCopy" bundle="profiles" />
                            </a>
                        </span>
                    </h4>
                    <div class="setup-input-group">
                        <cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesStorage.definesEntity"
                                class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
                                data-derive-setting="globalTemplate.deriveSettings.definesStorage.overrideEntity" ng-if="isDerived">
                        </cv-derivable-input-toggle>
                    </div>
                    <div class="global-options remove-border-padding plan-storage-table"
                            data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
                        <cv-plan-storage-component cv-model="globalTemplate.storages" cv-plan-sub-type ="planSubType" cv-storage-pools="allStoragePools"
                                cv-on-storage-added="onStorageAdded" cv-on-storage-deleted="onStorageDeleted" cv-on-register-api="onRegisterPlanStorageApi">
                        </cv-plan-storage-component>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel panel-default" data-ng-if="archiveType!==1">
            <div class="panel-body no-padding">
                <!-- RPO and SLA start -->
                <h4 class="plan">
                    <cv:msg key="label.rpo" bundle="profiles" /><cv-help-component help-text="<cv:msg key="info.help.rpo" bundle="profiles" />" help-placement="right"></cv-help-component>
                </h4>
                <div class="setup-input-group">
                    <cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSchedule.definesEntity"
                            class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
                            data-derive-setting="globalTemplate.deriveSettings.definesSchedule.overrideEntity" ng-if="isDerived">
                    </cv-derivable-input-toggle>
                </div>
                <cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
                    <div class="page-details-box">
                        <ul class="list-style-secondary page-details">
                            <li class="group">
                                <span class="pageDetailColumn">
                                    <cv-help-text help-label="<cv:msg key="label.archivalFrequency" bundle="profiles" />" help-text="'<cv:msg key='info.help.rpo.archivalFrequency' bundle='profiles' />'"></cv-help-text>
                                </span>
                                <span class="pageDetailColumn frequency-options-container form-group cv-inline-wrapper">
                                    <label class="freqLbl inline-label schedule-repeat-label vertial-align-middle" for="logSlaHours"><cv:msg key="label.incrementalFrequencyText" bundle="profiles"/></label>
                                    <input id="rpo" name="rpo" type="number" min="1" max="{{rpoMaxLimit}}" required="" ng-model="globalTemplate.rpo" class="frequency-input storage-retention-input sla-input" ng-class="{'setup' : skipForSetup, 'invalid-rpo' : invalidRPO}"  ng-disabled="incrementalBackupFreq.type === 'YEARS'"/>
                                    <select ng-model="incrementalBackupFreq.type" ng-change="incrementalBackupFrequencyChanged(incrementalBackupFreq.type)" ng-options="incrementalBackupFreq.value as incrementalBackupFreq.name for incrementalBackupFreq in incrementalBackupFreqs" class="frequency-options"></select>
                                `   <div class="width-auto inline-block padding-left-5 padding-right-5" ng-if="incrementalBackupFreq.type == 'WEEKS'">on</div>
                                    <isteven-multi-select ng-if="incrementalBackupFreq.type === 'WEEKS'"
                                        input-model="incrementalDaysToRun"
                                        button-label="name"
                                        item-label="name"
                                        tick-property="ticked"
                                        class="isteven-multi-select user-group-select width-auto min-width-100"
                                        id="isteven-multi-select2"
                                        on-item-click="incrementalDaysToRunChanged()"
                                        max-labels="1">
                                    </isteven-multi-select>
                                    <div ng-if="incrementalBackupFreq.type === 'MONTHS' || incrementalBackupFreq.type === 'YEARS'">
                                        <div class="margin-top-10">
                                            <span class="margin-right-10">
                                                <input value="RELATIVE" name="incrementalRPOMode" type="radio" data-ng-model="incrementalBackupFreq.incrementalRPOMode" />
                                                <span class="margin-left-10"><cv:msg key="label.on.the" bundle="profiles" /></span>
                                            </span>
                                            <select class="width-auto float-none min-width-80" data-ng-model="incrementalBackupFreq.weekOfMonth"  data-ng-disabled="incrementalBackupFreq.incrementalRPOMode !== 'RELATIVE'"
                                                data-ng-options="weekToRun.value as weekToRun.name for weekToRun in incrementalWeeksToRun"></select>
                                            <select class="width-auto float-none min-width-80" data-ng-model="incrementalBackupFreq.dayOfWeek" data-ng-disabled="incrementalBackupFreq.incrementalRPOMode !== 'RELATIVE'"
                                                data-ng-options="dayOfWeek.value as dayOfWeek.name for dayOfWeek in incrementalDaysOfWeek"></select>
                                        </div>
                                        <div>
                                            <span class="margin-right-10">
                                                <input value="NORMAL" name="incrementalRPOMode" type="radio" data-ng-model="incrementalBackupFreq.incrementalRPOMode" /> 
                                                <span class="margin-left-10"><cv:msg key="label.on.the" bundle="profiles" /></span>
                                            </span>
                                            <input id="incrementalDayOfMonth" name="incrementalDayOfMonth" type="number" required="" data-ng-model="incrementalBackupFreq.dayOfMonth" data-ng-change="incrementalDayOfMonthChanged()" ng-blur="incrementalDayOfMonthChanged(true)"
                                                class="frequency-input" data-ng-disabled="incrementalBackupFreq.incrementalRPOMode === 'RELATIVE'">
                                            	<span ng-bind="getDaySuffix(incrementalBackupFreq.dayOfMonth)"></span>
									            <span><cv:msg key="label.rpoFreq.daily" bundle="profiles" /></span>
                                        </div>
                                        <div ng-if="incrementalBackupFreq.type === 'YEARS'" class="margin-top-10">
                                            <span class="margin-right-10">								
                                                <span><cv:msg key="label.of.month" bundle="profiles" /></span>
                                            </span>
                                            <select class="width-auto float-none min-width-80" data-ng-model="incrementalBackupFreq.monthOfYear" data-ng-change="incrementalDayOfMonthChanged(true)"
                                                data-ng-options="monthOfYear.value as monthOfYear.name for monthOfYear in incrementalMonthsOfYear"></select>
                                        </div>
                                    </div>
                                </span>
                            </li>
                            <li class="group" ng-if="incrementalBackupFreq.type === 'DAYS' || incrementalBackupFreq.type === 'WEEKS' || incrementalBackupFreq.type === 'MONTHS' || incrementalBackupFreq.type === 'YEARS'">
                                <span class="pageDetailColumn">
                                    <cv-help-text help-label="<cv:msg key="label.rpo.startTime" bundle="profiles" />" help-text="'<cv:msg key='info.help.rpoSchedule.archivalTime' bundle='profiles' />'"></cv-help-text>
                                </span>
                                <span class="pageDetailColumn full-backup-rpo-start-time-container">
                                    <table uib-timepicker id="incrementalBackupRPOScheduleTime" name="incrementalBackupRPOScheduleTime" ng-model="incrementalBackupFreq.scheduleTime" hour-step="1" show-meridian="true" show-spinners="false"></table>
                                </span>
                            </li>
                            <li class="group">
                                <span class="pageDetailColumn">	<cv-help-text help-label="<cv:msg key="label.archivalWindow" bundle="profiles"/>" help-text="'<cv:msg key='info.help.rpoSchedule.archivalWindow' bundle='profiles' />'"></cv-help-text> </span>
                                <span class="pageDetailColumn">
                                    <cv-backup-window-list data-cv-model="globalTemplate.backupWindow"></cv-backup-window-list>
                                </span>
                            </li>
                        </ul>
                    </div>
                </cv-derivable-input>
            </div>
        </div>
        <div class="panel panel-default" data-ng-if="!archiveType">
            <div class="panel-body no-padding">
                <!-- Archival rules -->
                <h4 class="plan">
                    <cv:msg key="label.archivingRules" bundle="profiles" /><cv-help-component help-text="<cv:msg key="info.help.archivingRules" bundle="profiles" />" help-placement="right"></cv-help-component>
                </h4>
                <div class="setup-input-group">
                    <cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSubclientArcRulesWin.definesEntity"
                            class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
                            data-derive-setting="globalTemplate.deriveSettings.definesSubclientArcRulesWin.overrideEntity" ng-if="isDerived">
                    </cv-derivable-input-toggle>
                </div>
                <cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSubclientArcRulesWin.definesEntity">
                    <div class="page-details-box">
                        <ul class="list-style-secondary page-details">
                            <li class="group">
                                <span class="pageDetailColumn">
                                    <cv:msg key="label.archivingRules.fileTimestamp" bundle="profiles" />
                                </span>
                                <span class="pageDetailColumn form-group">
                                    <select ng-model="fileTimestampConfig.accessRule" ng-options="fileAccessRule as fileAccessRule.name for fileAccessRule in fileAccessRules"></select>
                                    <input id="accessedAgo" name="accessedAgo" type="number" min="0" max="999" required="" ng-model="fileTimestampConfig.lastAccessedAgo"/>
                                    <select ng-model="fileTimestampConfig.timestampRule" ng-options="fileTimestampRule as fileTimestampRule.name for fileTimestampRule in fileTimestampRules"></select>
                                    <span><cv:msg key="label.ago" bundle="profiles" /></span>
                                </span>
                            </li>
                            <li class="group">
                                <span class="pageDetailColumn">
                                    <cv:msg key="label.archivingRules.fileSize" bundle="profiles" />
                                </span>
                                <span class="pageDetailColumn form-group">
                                    <span><cv:msg key="label.greaterThan" bundle="profiles" /></span>
                                    <input id="size" name="size" type="number" min="0" max="1024" required="" ng-model="fileSizeConfig.size"/>
                                    <select ng-model="fileSizeConfig.rule" ng-options="fileSizeRule as fileSizeRule.name for fileSizeRule in fileSizeRules"></select>
                                </span>
                            </li>
                        </ul>
                    </div>
                </cv-derivable-input>
            </div>
        </div>
        <cv-plain-accordion class="derive-accordion bootstrap-wrapper" accordion-label="label.overrideRestrictions" collapsed="status.deriveSettings" ng-if="dialogMode && !archiveType">
            <cv-derive-settings data-sealed="globalTemplate.sealed" data-model="globalTemplate.deriveSettingsInputModel">
                <cv-derive-select data-name="StoragePolicy" data-class="row" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
                    <span><cv:msg key="label.storagePool" bundle="profiles" /></span><%--
                    <span class="subtext full-size"><cv:msg key="label.retentionDays" bundle="collections" /></span>--%>
                </cv-derive-select>
                <cv-derive-select data-name="SchedulePolicy" data-class="row" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
                    <cv:msg key="label.rpo" bundle="profiles" />
                </cv-derive-select>
                <cv-derive-select data-name="SubclientArcRulesWin" data-class="row" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
                    <cv:msg key="label.archivingRules" bundle="archiving" />
                </cv-derive-select>
                <cv-derive-select data-name="SubclientArcRulesLin" data-group-with="SubclientArcRulesWin"></cv-derive-select>
            </cv-derive-settings>
        </cv-plain-accordion>
		<div class="button-container">
            <button id="archivalPlanTemplate_button_#4721" type="button" class="btn btn-default cvBusyOnAjax" ng-click="skip()" ng-if="showPlanSkip"><cv:msg key="action.skip" bundle="profiles"/></button> 
            <button id="archivalPlanTemplate_button_#4020" type="button" class="btn btn-default cvBusyOnAjax" ng-if="dialogMode" ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
			<button id="archivalPlanTemplate_button_#4019" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
    </form>
	<div ng-hide="showCreatePlanForm || !showPlanSkip || !skipForSetup" class="button-container centered">
		<button id="archivalPlanTemplate_button_#8896" type="button" class="btn btn-default cvBusyOnAjax" ng-click="skip()"><cv:msg key="label.continue" bundle="profiles" /></button> 
	</div>
</div>