<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1>
		    <label for="proxyName" data-ng-if="proxyType && proxyType=='VSA'">
		    <cv:msg key="label.addProxyVSA" bundle="serversJs" />
		    </label>
		    <label for="proxyName" data-ng-if="!proxyType">
				<cv:msg key="label.addProxy" bundle="serversJs" /> <cv-help-component help-text="<cv:msg key="label.addProxyHelpText" bundle="serversJs" />"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-content" data-ng-controller="addProxyController" data-ng-class="{ 'medium-width' : $state.is('dloSetup') }">
			<div data-ng-if="!isResponse">
			<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
			<fmt:bundle basename="localization.servers">
				<a data-ng-click="changeConfig()" data-ng-show="showSkip || formConfig.hide"><fmt:message key="label.addGateway"/></a>
			</fmt:bundle>
				<form name="addProxyForm" novalidate cv-submit="addProxy()" autocomplete="off" class="add-proxy-form form-horizontal bootstrap-wrapper" data-ng-hide="showSkip || formConfig.hide">
		<div class="panel panel-default">
		<div class="panel-body">
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="hostName"><cv:msg key="label.hostName" bundle="serversJs" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input autofocus
						type="text"
						name="hostName"
						id="hostName"
						data-ng-model="model.newProxy.hostName"
						data-ng-class="{'has-error': cv.addProxyForm.needsAttention(addProxyForm.hostName)}"
						required />
						<span class="help-block" data-ng-show="cv.addProxyForm.needsAttention(addProxyForm.hostName)"><cv:msg key="error.hostName" bundle="serversJs" /></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="clientName"><cv:msg key="label.clientName" bundle="serversJs" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="text"
						name="clientName"
						id="clientName"
						data-ng-blur="clientNameChanged()"
						data-ng-model="model.newProxy.clientName"
						data-ng-class="{'has-error': cv.addProxyForm.needsAttention(addProxyForm.clientName)}"
						required />
						<span class="help-block" data-ng-show="cv.addProxyForm.needsAttention(addProxyForm.clientName)"><cv:msg key="error.clientName" bundle="serversJs" /></span>
			</div>
		</div>
		
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="osType"><cv:msg key="label.osType" bundle="serversJs" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="multiple-radio-group">
					<label for="osTypeWINDOWS"><input type="radio" id="osTypeWINDOWS" data-ng-model="model.newProxy.clientType"	value="WINDOWS" name="osType" />
					<span class="block-indent"><cv:msg key="label.osType.windows" bundle="serversJs" /></span></label>
				</div>
				<div class="multiple-radio-group">
					<label for="osTypeUNIX"><input type="radio" id="osTypeUNIX" data-ng-model="model.newProxy.clientType" value="UNIX" name="osType" />
					<span class="block-indent"><cv:msg key="label.osType.unixLinux" bundle="serversJs" /></span></label>
				</div>
			</div>
		</div>
		
		</div></div>
					<div class="button-container margin-right-15">
						<button id="addProxyContent_button_#0203" type="button" data-ng-if="setup" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="Skip" /></button> 
						<button id="addProxyContent_button_#5141" type="button" data-ng-if="!setup" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
						<button id="addProxyContent_button_#7772" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button> 
					</div>
				</form>
			</div>
			<div class="button-container centered" data-ng-show="showSkip || formConfig.hide">
				<fmt:bundle basename="localization.messages">
					<button id="addProxyContent_button_#3548" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><fmt:message key="Continue" /></button> 
				</fmt:bundle>
			</div>
			<div data-ng-if="isResponse">
				<div class="cv-modal-wrapper">
					<p class="cv-modal-wrapper" data-ng-bind-html="responseContent"></p>
				</div>
				<div class="button-container">
					<button id="addProxyContent_button_#0597" type="submit" class="btn btn-primary" data-ng-click="cancel();reload()"><cv:msg key="OK" /></button> 
				</div>
			</div>
	</div>
</div>