<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>

<div>

    <div class="text-center no-padding">
        <span class="{{ctrl.OIDCServerMessage.type}} margin-bottom-0" data-ng-bind="ctrl.OIDCServerMessage.message"></span>
    </div>

    <div class="loading-data margin-top-15 text-center" data-ng-if="!ctrl.dataLoadComplete">
        <div class="loader-skeleton tile-style margin-bottom-15"></div>
        <div class="loader-skeleton tile-style margin-bottom-5"></div>
    </div>

    <form data-cv-submit="ctrl.createOIDCClient()" novalidate autocomplete="off" name="ctrl.addOIDCClientForm" data-ng-if="ctrl.dataLoadComplete">

        <div class="global-options remove-border-padding padding-bottom-50 bootstrap-wrapper modal-margin form-horizontal">
            <div class="panel panel-default padding-bottom-30">
                <div class="panel-body">
                    <div class="form-group">
                        <label for="clientId" class="col-xs-12 col-sm-4">
                            <cv:msg key="label.clientId" bundle="users" />
                        </label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" name="clientId" id="clientId" data-ng-model="ctrl.model.clientId" required />
                            <span class="help-block" data-ng-show="cv['ctrl.addOIDCClientForm'].needsAttention(ctrl.addOIDCClientForm.clientId)"><cv:msg key="error.clientId" bundle="users" /></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="clientSecret" class="col-xs-12 col-sm-4">
                            <cv:msg key="label.clientSecret" bundle="users" />
                        </label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" name="clientSecret" id="clientSecret" data-ng-model="ctrl.model.clientSecret" required />
                            <span class="help-block" data-ng-show="cv['ctrl.addOIDCClientForm'].needsAttention(ctrl.addOIDCClientForm.clientSecret)"><cv:msg key="error.clientSecret" bundle="users" /></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="endPointUrl" class="col-xs-12 col-sm-4">
                            <cv:msg key="label.discoveryEndpointUrl" bundle="users" />
                        </label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" name="endPointUrl" id="endPointUrl" data-ng-model="ctrl.model.endPointUrl" required data-ng-pattern="ctrl.urlRegex" />
                            <span class="help-block" data-ng-show="cv['ctrl.addOIDCClientForm'].needsAttention(ctrl.addOIDCClientForm.endPointUrl)"><cv:msg key="error.endPointUrl" bundle="users" /></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="displayName" class="col-xs-12 col-sm-4">
                            <cv:msg key="label.displayName" bundle="users" />
                        </label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" name="displayName" id="displayName" data-ng-model="ctrl.model.displayName" required />
                            <span class="help-block" data-ng-show="cv['ctrl.addOIDCClientForm'].needsAttention(ctrl.addOIDCClientForm.displayName)"><cv:msg key="error.displayName" bundle="users" /></span>
                        </div>
                    </div>
                    <div data-ng-if="ctrl.showCompanySelection" class="form-group margin-top-20">
                        <label class="col-xs-12 col-sm-4" for="createForCompany">
                            <cv:msg key="label.createForCompany" bundle="users" />
                            <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
                        </label>
                        <div class="col-xs-12 col-sm-8">
                            <isteven-multi-select
                                input-model="ctrl.companiesList"
                                button-label="name"
                                item-label="name"
                                tick-property="ticked"
                                class="isteven-multi-select user-group-select"
                                id="createForCompany"
                                name="createForCompany"
                                helper-elements="none filter reset"
                                max-labels="1"
                                translation="ctrl.companiesDropdownLocalization"
                                disable-property="disabled"
                                selection-mode="single">
                            </isteven-multi-select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="button-container padding-bottom-20">
                <button id="add_oidc_cancel" type="button" class="btn btn-default cvBusyOnAjax"
                    data-ng-click="ctrl.onClickCancel()">
                    <cv:msg key="action.cancel" bundle="users" />
                </button>
                <button id="add_oidc_save" type="submit" class="btn btn-primary cvBusyOnAjax">
                    <cv:msg key="action.save" bundle="users" />
                </button>
            </div>
        </div>
    </form>
</div>