<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="global-options remove-border-padding bootstrap-wrapper modal-margin form-horizontal">
<div data-ng-if="!isEditDomain || (model.focusOn != attrTypeFlags.LDAPQueryParam && model.focusOn != attrTypeFlags.otherAttribute)">
		<div class="alert-warning alert netbios-alert" data-ng-if="model.netBiosName && model.companyAlias && model.netBiosName.toLowerCase() === model.companyAlias.toLowerCase()">
		   	<cv:msg key="label.netbiosConflict" bundle="users" />
		</div>
<div class="panel panel-default">
<div class="panel-body">
		<div class="form-group" data-ng-hide="isHideDirectoryType">
			<label for="directoryType" class="col-xs-12 col-sm-4"><cv:msg key="label.directoryType" bundle="users" /></label>
			<div class="col-xs-12 col-sm-8" data-ng-disabled="isEditDomain">
				<isteven-multi-select
					input-model="directoryTypes"
					button-label="name"
					item-label="name"
					tick-property="ticked"
					output-model="model.directoryType2"
					class="isteven-multi-select user-group-select"
					id="directoryType"
					name="directoryType"
					helper-elements="none filter reset"
					max-labels="1"
					translation="localLang"
					on-item-click="changeDirectory()"
					disable-property="disabled"
					selection-mode="single">
				</isteven-multi-select>
			</div>
		</div>
		<div data-ng-if="model.directoryType != 8 && model.directoryType != 14" class="form-group">
			<label for="netBiosName" class="col-xs-12 col-sm-4"><cv:msg key="label.netbiosName" bundle="users" /></label>
			<div class="col-xs-12 col-sm-8">
				<input data-ng-disabled="disableNetBiosName" type="text" name="netBiosName" id="netBiosName" data-ng-model="model.netBiosName" required />
				<span class="help-block" data-ng-show="cv.addNameServerForm.needsAttention(addNameServerForm.netBiosName)"><cv:msg key="error.netBIOSname" bundle="users" /></span>
			</div>
		</div>
		<div data-ng-if="model.directoryType == 8" class="form-group">
			<label for="netBiosName8" class="col-xs-12 col-sm-4"><cv:msg key="label.OSXServerName" bundle="users" /></label>
			<div class="col-xs-12 col-sm-8">
				<input data-ng-disabled="disableNetBiosName" type="text" name="netBiosName" id="netBiosName8" data-ng-model="model.netBiosName" required />
				<span class="help-block" data-ng-show="cv.addNameServerForm.needsAttention(addNameServerForm.netBiosName)"><cv:msg key="error.OSXServerName" bundle="users" /></span>
			</div>
		</div>
		<div data-ng-if="model.directoryType == 14" class="form-group">
			<label for="netBiosName14" class="col-xs-12 col-sm-4"><cv:msg key="label.host" bundle="users" /></label>
			<div class="col-xs-12 col-sm-8">
				<input data-ng-disabled="disableNetBiosName" type="text" name="netBiosName" id="netBiosName14" data-ng-model="model.netBiosName" required />
				<span class="help-block" data-ng-show="cv.addNameServerForm.needsAttention(addNameServerForm.netBiosName)"><cv:msg key="error.host" bundle="users" /></span>
			</div>
		</div>
		<div class="form-group" data-ng-if="model.directoryType != 14">
			<label for="domainName" class="col-xs-12 col-sm-4"><cv:msg key="label.domainName" bundle="users" /></label>
			<div class="col-xs-12 col-sm-8">
				<input type="text" name="domainName" id="domainName" data-ng-model="model.domainName" required />
				<span class="help-block" data-ng-show="cv.addNameServerForm.needsAttention(addNameServerForm.domainName)"><cv:msg key="error.domainName" bundle="users" /></span>
			</div>
		</div>
		<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials-->
		<input style="display:none" type="text" name="fakeusernameremembered" />
		<input style="display:none" type="password" name="fakepasswordremembered" />
		<div class="show-creds-in-grid"><cv-credential-directive credentials="model" form-name="addNameServerForm" is-edit="isOptional" is-optional="true" password-complexity="1" need-confirm="false"></cv-credential-directive></div>
		
		<div class="form-group" data-ng-if="model.directoryType == 2">
			<div class="col-xs-12">
				 <input name="secureLDAP" id="secureLDAP" type="checkbox" data-ng-model="model.secureLDAP" />
				 <label for="secureLDAP"><cv:msg key="label.useSecureLdap" bundle="users" /></label>
			</div>
		</div>
		
		<div class="form-group" data-ng-if="model.directoryType == 2">
			<div class="col-xs-12">
				 <input name="enableSSO" id="enableSSO" type="checkbox" data-ng-model="model.enableSSO" />
				 <label for="enableSSO"><cv:msg key="label.enableSso" bundle="users" /></label>
			</div>
		</div>
		<div data-ng-if="showProxy">
			<div data-ng-if="!model.secureLDAP">
				<div class="form-group">
					<div class="col-xs-12">
						<input type="checkbox" name="accessADProxy" id="accessADProxy" data-ng-model="model.accessADProxy" />
						<label for="accessADProxy"><cv:msg key="label.accessAdProxy" bundle="users" /></label>
					</div>
				</div>
				<div class="form-group" data-ng-if= "model.accessADProxy">
					<label class="col-xs-12 col-sm-4" for="proxyClientId"><cv:msg key="label.clientName" bundle="users" /></label>
					<div class="col-xs-12 col-sm-8">
						<isteven-multi-select
							input-model="proxyList"
							button-label="clientName"
							item-label="clientName"
							tick-property="ticked"
							output-model="model.proxyClientSelected"
							class="isteven-multi-select user-group-select"
							id="proxyClientId"
							name="proxyClientId"
							helper-elements="none filter reset"
							max-labels="1"
							translation="localLang"
							on-item-click="changeProxyClient()"
							disable-property="disabled"
							selection-mode="single">
						</isteven-multi-select>
					</div>
				</div>
			</div>
			<div data-ng-if="model.secureLDAP">
				<div class="form-group">
					<div class="col-xs-12">
						<input data-ng-disabled="disableSecureLDAP" type="checkbox" name="accessADProxy" id="accessADProxy" data-ng-model="model.accessADProxy" />
						<label for="accessADProxy"><cv:msg key="label.accessAdProxy" bundle="users" /></label>
					</div>
				</div>
				<div class="form-group" data-ng-if= "model.accessADProxy">
					<label data-ng-disabled="disableSecureLDAP"class="col-xs-12 col-sm-4" for="proxyClientId"><cv:msg key="label.clientName" bundle="users" /></label>
					<div class="col-xs-12 col-sm-8" data-ng-disabled="disableSecureLDAP">
						<isteven-multi-select
							input-model="proxyList"
							button-label="clientName"
							item-label="clientName"
							tick-property="ticked"
							output-model="model.proxyClientSelected"
							class="isteven-multi-select user-group-select"
							id="proxyClientId"
							name="proxyClientId"
							helper-elements="none filter reset"
							max-labels="1"
							translation="localLang"
							on-item-click="changeProxyClient()"
							disable-property="disabled"
							selection-mode="single">
						</isteven-multi-select>
					</div>
				</div>
			</div>
		 </div>
		<div data-ng-if="isCommcellUser" class="form-group">
			<label class="col-xs-12 col-sm-4" for="createForCompanies" ng-hide="model.companyName">
				<cv:msg key="label.createForCompany" bundle="users" />
				<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
			</label>
			<div class="col-xs-12 col-sm-8" ng-hide="model.companyName">
				<isteven-multi-select
					input-model="companies"
					button-label="name"
					item-label="name"
					tick-property="ticked"
					class="isteven-multi-select user-group-select"
					id="createForCompanies"
					name="createForCompanies"
					helper-elements="none filter reset"
					max-labels="1"
					translation="localLang"
					disable-property="disabled"
					selection-mode="single">
				</isteven-multi-select>
				<span class="help-block" data-ng-show="showCompanyErrorMessage">
					<i class="ion-alert-circled" ></i><fmt:message key="error.selectACompany" />
				</span>
			</div>
		</div>
			<div class="form-group">
				<label class="col-xs-12 col-sm-4" ng-show="model.companyName">
					<cv:msg key="label.createdForCompany" bundle="users" />
				</label>
				<div class="col-xs-12 col-sm-8" ng-show="model.companyName">
					<label ng-bind="model.companyName"></label>
				</div>
			</div>
</div></div>
</div>
		<div data-ng-if="model.directoryType == 14 && isEditDomain">
			<cv-grid data-ng-if="model.focusOn == attrTypeFlags.LDAPQueryParam" cv-grid-options="gridOptions"></cv-grid>
			<cv-grid data-ng-if="model.focusOn == attrTypeFlags.otherAttribute" cv-grid-options="otherAttributeGridOptions"></cv-grid>
		</div>
		<div data-ng-if="model.directoryType == 14 && !isEditDomain">
		<uib-accordion close-others="true"  class="text-left">
			<div uib-accordion-group data-is-open="accordionStatus.LDAPQueryParams" data-scroll-to-when-open>
				<uib-accordion-heading>
					<!-- <cv:msg key="label.ldapQueryParam" bundle="users"/> -->
					<cv-help-text help-label="label.ldapQueryParam" help-text="helpText.ldapQueryParam" use-icon="true" />
					<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionStatus.LDAPQueryParams, 'glyphicon-chevron-right': !accordionStatus.LDAPQueryParams}"></i>
				</uib-accordion-heading>
				<cv-grid cv-grid-options="gridOptions"></cv-grid>
			</div>
		</uib-accordion>
		</div>
</div>
