<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.databaseConfiguration" bundle="sqlserver" /></h1>
</div>
<div class="setup-content">
<section>
	<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<div data-ng-if="everythingLoaded && !databaseConfigurations.length"><div class="horz-center"><cv:msg key="label.noDatabasesConfigured" bundle="sqlserver"/></div></div>
	<form name="mssqlSubclientContentForm" class="add-collection-form" data-cv-submit="saveDatabaseConfigurations()" autocomplete="off" novalidate>
		<div class="limit-modal-height" data-ng-show="everythingLoaded && databaseConfigurations.length >0">
			<table>
				<thead><tr>
					<td><label class="name"><b><cv:msg key="label.DatabaseName" bundle="sqlserver" /></b></label></td>
					<td><label class="name"><b><cv:msg key="label.SubclientName" bundle="clients" /></b></label></td>
					<%-- <td> <label class="name"> <fmt:message key="label.RecoveryType"/>  </label> </td> --%>
				</tr></thead>
				<tbody>
					<tr data-ng-repeat="content in databaseConfigurations">
						<td><label data-ng-bind="content.sqlDatabaseInfo.databaseName"></label></td>
						<td>
							<label class="select-label" id="select-table">
								<select id="select-table" data-ng-options="subClientEntity.subclientName for subClientEntity in subclientsList | orderBy:'subclientName' track by subClientEntity.subclientId "
										data-ng-model="content.subClientEntity">
								</select>
							</label>
						</td>
						<!-- <td> <label data-ng-bind="content.sqlDatabaseInfo.recoveryModelType"></label></td> -->
					</tr>
				</tbody>
			</table>
		</div>	
		<br>
		<button id="sqlServerDatabaseConfigurationModal_button_#2290" type="button" class="btn" data-ng-click="discover()"><cv:msg key="label.discover" bundle="sqlserver" /></button> 
		<div class="button-container">
			<button id="sqlServerDatabaseConfigurationModal_button_#5595" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden"	data-ng-click="closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="sqlServerDatabaseConfigurationModal_button_#9361" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages"/></button> 
		</div>
	</form>
</section>
</div>
