<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<cv-tile-component
	data-title='<cv:msg key="label.cloudConfig" bundle="sqlserver" />'
	loader="sqlPropLoaded" edit-text="reorderHelpText">
<span class="server-message {{proxyMessage.type}}">{{proxyMessage.message}}</span>
<div data-ng-if="sqlPropLoaded" data-ng-init="init()">
	<ul class="list-style-secondary">
		<li class="group"
			data-ng-if="entityType=='APPTYPE_ENTITY' && isAmazon">
			<span class="pageDetailColumn">
				<cv:msg key="label.s3bucketName" bundle="sqlserver" />
			</span>
			<span data-ng-if="option.isS3BucketConfigured" class="pageDetailColumn">
				<cv:msg key="header.configured" bundle="devicesJs" />
			</span>
			<span data-ng-if="!option.isS3BucketConfigured" class="pageDetailColumn error">
				<cv:msg key="info.noConfigured" bundle="settings" />
			</span>
		</li>
		<li class="group"
			data-ng-if="entityType=='APPTYPE_ENTITY' && isAmazon">
			<span class="pageDetailColumn">
				<cv:msg key="label.sqlServerAccount" bundle="sqlserver" />
			</span>
			<span data-ng-if="option.isAmazonAccountSet" class="pageDetailColumn">{{awsSqlInfo.sqlInstanceCredentials.userName}}</span>
			<span data-ng-if="!option.isAmazonAccountSet" class="pageDetailColumn">
				<cv:msg key="label.notSet" bundle="settingsJs" />
			</span>
		</li>
		<li class="group" data-ng-if="entityType=='APPTYPE_ENTITY' && isAzure">
			<span class="pageDetailColumn">
				<cv:msg key="label.azureStorageConnectionString" bundle="sqlserver" />
			</span>
			<span data-ng-if="option.isAzureStorageConnectionConfigured" class="pageDetailColumn">
				<cv:msg key="header.configured" bundle="devicesJs" />
			</span>
			<span data-ng-if="!option.isAzureStorageConnectionConfigured" class="pageDetailColumn error">
				<cv:msg key="info.noConfigured" bundle="settings" />
			</span>
		</li>
		<li class="group" data-ng-if="entityType=='APPTYPE_ENTITY' && isAzure">
			<span class="pageDetailColumn">
				<cv:msg key="label.sqlServerAccount" bundle="sqlserver" />
			</span>
			<span data-ng-if="option.isAzureAccountSet" class="pageDetailColumn">{{azureSqlInfo.azureSqlInstanceCredentials.userName}}</span>
			<span data-ng-if="!option.isAzureAccountSet" class="pageDetailColumn">
				<cv:msg key="label.notSet" bundle="settingsJs" />
			</span>
		</li>
		<li class="group" data-ng-if="entityType=='INSTANCE_ENTITY'">
			<span class="pageDetailColumn">
				<cv:msg key="lable.useCloudConfigAtInstance" bundle="sqlserver" />
			</span>
			<span class="pageDetailColumn">
				<toggle-control status="option.overWriteStatus"
					data-ng-click="enableDisableOverWrite(awsSqlInfo, genericEntity, entityType,
				            			  proxies, overwriteHigherLevelSettings, azureSqlInfo, option)"
					title="<cv:msg key="lable.useCloudConfigAtInstance" bundle="sqlserver" />">
				</toggle-control>
				<a class="edit-link-float-right-action"
					data-ng-if="option.overWriteStatus === 'enabled-activity'"
					data-ng-click="editSqlCloud(awsSqlInfo, genericEntity, entityType,
				            			  proxies, overwriteHigherLevelSettings, azureSqlInfo, option)"
					title="<cv:msg key="action.edit" bundle="settingsJs" />"><cv:msg
						key="action.edit" bundle="settingsJs" /></a>
			</span>
		</li>
		<li class="group" data-ng-if="showProxy">
			<span class="pageDetailColumn">
				<cv:msg key="lable.acessNodes" bundle="sqlserver" />
			</span>
			<span class="pageDetailColumn">
				<ul data-dragula='"bag-two"'
					data-dragula-scope="$parent" data-dragula-model="option.proxyList">
					<li style="padding: 0 0 3px 0;" class="group"
						data-ng-class="{'draggable-proxy' : proxyReorderingEnabled}"
						data-ng-repeat="srv in option.proxyList | limitTo: proxyClientLimit">{{srv.client.clientName}}</li>
					<li style="padding: 0 0 3px 0;"
						data-ng-show="(option.proxyList.length > 3) && (proxyClientLimit !== option.proxyList.length)"
						class="tile-content-link">
						<a href="" data-ng-click="proxyClientLimit = option.proxyList.length">
							<cv:msg key="label.proxy.more" bundle="sqlserver" /> ( <cv:msg
								key="label.proxy.count" bundle="sqlserver" />
							{{option.proxyList.length}})
						</a>
					</li>
				</ul>
			</span>
		</li>
	</ul>
</div>
<div class="page-details-box-links">
	<a data-ng-show="proxyReorderingEnabled" href=""
		data-ng-click="resetOrder()"> <cv:msg key="Cancel"
			bundle="messages" />
	</a> <a data-ng-show="proxyReorderingEnabled" href=""
		data-ng-click="setOrder()"> <cv:msg key="Save" bundle="messages" />
	</a> <a
		data-ng-show="option.proxyList.length && option.proxyList.length > 1 && !proxyReorderingEnabled"
		href="" data-ng-click="activateReordering()"> <cv:msg
			key="action.reorder" bundle="sqlserver" />
	</a> <a href="" data-ng-if="entityType=='APPTYPE_ENTITY'"
		data-ng-click="editSqlCloud(awsSqlInfo, genericEntity, entityType,
				            			  proxies, overwriteHigherLevelSettings, azureSqlInfo, option)">
		<cv:msg key="action.edit" bundle="settingsJs" />
	</a>
</div>
</cv-tile-component>