<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.cloudConfig" bundle="sqlserver" />
	</h1>
</div>
<div class="form-horizontal bootstrap-wrapper modal-margin">
	<form name="updateCloudConfigInfoForm" autocomplete="off">
		<div class="form-group">
			<div class="col-xs-12">
				<span class="server-message {{serverMessage.type}}"
					data-ng-bind="serverMessage.message"></span>
			</div>
		</div>
<!-- 		<div class="form-group" data-ng-if="entityType=='INSTANCE_ENTITY'"> -->
<!-- 			<div class="col-xs-12"> -->
<!-- 				<input type="checkbox" id="overwriteHigherLevelSettings" -->
<!-- 					data-ng-model="overwriteHigherLevelSettings.value" -->
<!-- 					data-ng-change="overWriteChanged()" /> -->
<!-- 				<label for="overwriteHigherLevelSettings"> -->
<%-- 					<cv:msg key="label.overrideHigherLevelsSettings" bundle="sqlserver" /> --%>
<!-- 				</label> -->
<!-- 			</div> -->
<!-- 		</div> -->
		<div class="form-group" data-ng-if="isAmazon">
			<label class="col-xs-12 col-md-4 col-lg-4" for="s3BucketName">
				<cv:msg key="label.s3bucketName" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="text" id="s3BucketName" name="s3BucketName"
					data-ng-model="model.s3BucketName"
					data-ng-change="inputAlertFlags.s3BucketName = !model.s3BucketName || model.s3BucketName.length <= 0" />
				<span class="help-block" data-ng-show="inputAlertFlags.s3BucketName && atLeastOneNoneEmpty">
					<cv:msg key="error.s3bucketName" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="isAzure">
			<label class="col-xs-12 col-md-4 col-lg-4"
				for="azureStorageConnectionString">
				<cv:msg key="label.azureStorageConnectionString" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<textarea class="textarea" id="azureStorageConnectionString"
					name="azureStorageConnectionString"
					data-ng-model="model.azureStorageConnectionString"
					data-ng-change="inputAlertFlags.azureStorageConnectionString = !model.azureStorageConnectionString || model.azureStorageConnectionString.length <= 0"></textarea>
				<span class="help-block"
					data-ng-show="inputAlertFlags.azureStorageConnectionString && atLeastOneNoneEmpty">
					<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="cloudUserName">
				<cv:msg key="label.userName" bundle="servers" />
			</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="text" id="cloudUserName" name="cloudUserName"
					data-ng-model="model.userName"
					data-ng-change="cloudUserNameChanged()"/>
				<span class="help-block"
					data-ng-show="inputAlertFlags.userName && atLeastOneNoneEmpty">
					<cv:msg key="error.userName" bundle="servers" />
				</span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="cloudPassword">
				<cv:msg key="label.password" bundle="servers" />
			</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="password" id="cloudPassword" name="cloudPassword"
					autocomplete="new-password" data-ng-model="model.password"
					placeholder="{{passwordPlaceholder}}"
					data-ng-change="inputAlertFlags.password = !!model.userName && model.userName.length > 0 && (!model.password || model.password.length <= 0)" />
				<span class="help-block" data-ng-show="inputAlertFlags.password && atLeastOneNoneEmpty">
					<cv:msg key="error.password" bundle="users" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="entityType=='APPTYPE_ENTITY'">
			<label class="col-xs-12 col-md-4 col-lg-4" for="sqlProxyList">
				<cv:msg key="lable.acessNodes" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select input-model="proxyList" id="sqlCloudConfigEditing_button_#5501"
					output-model="model.selectedProxies" button-label="clientName"
					item-label="clientName" tick-property="checked"
					class="isteven-multi-select user-group-select" id="sqlProxyList"
					translation="localLang" helper-elements="all none reset filter"
					max-labels="2" />
				<span class="help-block"
					data-ng-show="inputAlertFlags.proxies">
					<cv:msg key="error.proxies" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<div class="modal-footer">
			<button type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sqlCloudConfigEditing_button_#9795" type="submit"
				class="btn btn-primary cvBusyOnAjax"
				data-ng-click="updateSqlCloudConfigSettings()">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
</div>
