<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
  	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	</script>
<div class="setup-title"><h1><cv:msg key="label.cloneDatabase" bundle="oracle"/> </h1></div>
<div  class="clone-database-markup-holder setup-content" >
	<form name="restoreForm" class="restore-form" novalidate data-cv-submit="submitCloneSnap()" autocomplete="off">
    <cv-tabset-component control="tabControls"  >
        <cv-tab tabname="<cv:msg key="label.general" bundle="profiles"/>" >
		 	<div class="panel form-panel-holder">
			<label>
				<span class="page-detail-column">
					<label for="destClient"> <cv:msg key="label.clientName" bundle="clients" />
					</label>
				</span>
				<span class="page-detail-column select-label float-right">
					<select ng-model="data.destClient" name="destClient" id="destClient" ng-change="destClientChanged(data.destClient)"
						ng-options="client as client.clientName for client in clientsList | orderBy:'clientName'">
					</select>
				</span>
			</label>
			<label>
				<span class="page-detail-column">
					<label for="instanceName"> <cv:msg key="label.instanceName" bundle="clients" /> </label>
				</span>
				<span class="page-detail-column select-label float-right">
					<div uib-dropdown class="uib-dropdown" on-toggle="toggled(open)">
					      <span class="uib-dropdown-toggle" uib-dropdown-toggle>
					      	<input style="cursor: pointer;" type="text" id="oraHomeText" name="oraHomeText" data-ng-model="data.InstanceNameText" ng-change="updateOptions(null)" />
					      </span>
					      <ul uib-dropdown-menu class="dropdown-menustorage  dropdown-fixed" >
					      	<li data-ng-repeat="instance in instanceList | orderBy:'instanceName'" data-ng-click="updateOptions(instance)"><a >{{instance.instanceName}}</a></li>
					      </ul>
					</div>
				</span>
			</label>
			<!--Oracle Home. -->
				<label>
					<span class="page-detail-column">
						<label for="oraHome">
							<cv:msg key="label.oracleHome" bundle="oracle"/>
						</label>
					</span>
					<span class="page-detail-column float-right">
						<input ng-disabled="!isDummyInstance" type="text" id="oraHome" name="oraHome"
							data-ng-model="data.oracleCloneEnv.oraHome" />
					</span>
					<span class="help-block" data-ng-show="cv.AddOracleInstance.needsAttention(AddOracleInstance.oraHome);" >
						<cv:msg key="error.oracleHome" bundle="oracle"/>
					</span>
				</label>
				<!--  Raman :- Need to update the code for this. -->
				<label ng-hide="true">
					<span class="page-detail-column"></span>
					<span class="page-detail-column float-right">
						<button id="oracleHomeBrowse" type="button" class="btn btn-default setup-btn--hidden float-right" data-ng-click="browse('oraHome')">
									<cv:msg key="label.browse" bundle="restore"/></button>
					</span>
				</label>
				<!--Oracle OS User. -->
				<label>
					<span class="page-detail-column">
						<label for="userName">
							<cv:msg key="label.userName" bundle="servers"/>
						</label>
					</span>
					<span class="page-detail-column float-right">
						<input ng-disabled="!isDummyInstance" type="text" id="userName" name="userName"
							data-ng-model="data.oracleCloneEnv.oraUser"/>
					</span>
					<span class="help-block" data-ng-show="cv.AddOracleInstance.needsAttention(AddOracleInstance.osUserName);" >
						<cv:msg key="error.osUserName" bundle="oracle"/>
					</span>
				</label>
				<label>
					<span class="page-detail-column">
						<label for="oraPfile">
							<cv:msg key="label.pFile" bundle="oracle"/>
						</label>
					</span>
					<span class="page-detail-column browse-input-holder float-right">
						<input type="text" id="oraPfile" name="oraPfile" data-ng-required="true"
							data-ng-model="data.oracleCloneEnv.oraPfile"/>
						<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
							client-id='{{data.destClient.clientId}}' folders-only='false' result-function="oraPfileResuleFunction"/>
					</span>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.oraPfile)">
						<cv:msg key="error.oraPfile" bundle="oracle"/>
					</span>
				</label>
				<span ng-hide="data.oracleCloneEnv.cloneType =='RMANDUPLICATE' ">
				<label>
					<span class="page-detail-column">
						<label for="stagingPath">
							<cv:msg key="label.stagingPath" bundle="oracle"/>
						</label>
					</span>
					<span class="page-detail-column browse-input-holder float-right">
						<input type="text" id="stagingPath" name="stagingPath" data-ng-required="true"
							data-ng-model="data.oracleCloneEnv.stagingPath"/>
							<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
							client-id='{{data.destClient.clientId}}' result-function="stagingPathResuleFunction"/>
					</span>
					<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.stagingPath)">
						<cv:msg key="error.stagingPath" bundle="oracle"/>
					</span>
				</label>
				</span>
				<span ng-show="data.oracleCloneEnv.cloneType =='RMANDUPLICATE' ">
					<label>
						<span class="page-detail-column">
							<label for="redirectPath">
								<cv:msg key="label.redirectPath" bundle="oracle"/>
							</label>
						</span>
						<span class="page-detail-column browse-input-holder float-right">
							<input type="text" id="redirectPath" name="redirectPath"
								data-ng-model="data.oracleCloneEnv.redirectPath"/>
							<button id="snapClone_button_#0332" type="button" class="btn btn-default setup-btn--hidden float-right" data-ng-click="browse(data.destClient.clientId,'redirectPath')"> 
								<cv:msg key="label.browse" bundle="restore"/></button>
						</span>
					</label>
					<label>
						<cv:msg key="label.auxConnectStr" bundle="oracle"/>
					</label>
					<label>
						<div class="connection-string">
							<input class="user" id="dbUserName" name="dbUserName" type="text" placeholder="User Name" data-ng-model="data.oracleOpt.catalogConnect1" >
							<label for="dbUserName"> / </label>
							<input class="user" id="dbPassword" name="dbPassword" type="password" placeholder="Password" data-ng-model="data.oracleOpt.catalogConnect22" >
							<label for="dbPassword"> @ </label>
							<input class="sid" id="dbInstanceName" name="dbInstanceName" type="text" placeholder="SID" data-ng-model="data.oracleOpt.catalogConnect3" >
						</div>
							<span class="help-block ng-hide" data-ng-show="validateConnectString(AddOracleInstance.dbUserName,AddOracleInstance.dbPassword,AddOracleInstance.dbInstanceName)">
								<cv:msg key="error.connectString" bundle="oracle"/>
							</span>
					</label>
				</span>
			</div>
      </cv-tab>
      <cv-tab tabname="<cv:msg key="label.options" bundle="oracle"/> " >
      <div class="panel form-panel-holder">
      <span ng-show="data.oracleCloneEnv.cloneType =='RMANDUPLICATE' ">
      	 <label>
			<span class="page-detail-column">
				<label for="scn"><cv:msg key="label.scn" bundle="oracle" /></label>
			</span>
			<span class="page-detail-column float-right">
				<input type="text" id="scn" name="scn" data-ng-model="data.oracleCloneEnv.scn">
			</span>
      	 </label>
      	 <label>
      	 	<span class="page-detail-column">
				<input type="checkbox" id="duplicateStandby" name="duplicateStandby" data-ng-model="data.oracleCloneEnv.duplicateStandby">
				<label for="duplicateStandby"><cv:msg key="label.duplicateStandby" bundle="oracle" /></label>
			</span>
			<span class="page-detail-column float-right">
				<input type="checkbox" id="disableFailover" name="disableFailover" data-ng-model="data.oracleCloneEnv.disableFailover">
				<label for="disableFailover"><cv:msg key="label.disableFailover" bundle="oracle" /></label>
			</span>
      	 </label>
      </span>
      <span ng-hide="data.oracleCloneEnv.cloneType =='RMANDUPLICATE' ">
       	<label> <!-- Clone Type is Snap Clone Selection  -->
			<span class="page-detail-column">
	       		<cv:msg key="label.cloneReservation" bundle="oracle"/>
       		</span>
       		<span class="page-detail-column float-right">
		        <span class="float-right half-percent-class">
	   				<input type="number" id="rsvTPHours" name="rsvTPHours" data-ng-model="data.oracleCloneEnv.rsvTPHours" >
	   				<span><cv:msg key="hours" bundle="messagesJs"/></span>
	   			</span>
       			<span class="float-right half-percent-class">
		        	<input type="number" id="rsvTPDays" name="rsvTPDays" data-ng-model="data.oracleCloneEnv.rsvTPDays" >
		        	<cv:msg key="days" bundle="messagesJs"/>
		        </span>
			</span>
		</label>
		<label>
				<span class="page-detail-column">
					<label for="copyPrec" >
						<cv:msg key="label.copyPrec" bundle="oracle"/>
					</label>
            	</span>
            	<span class="page-detail-column float-right">
					<input type="number" id="copyPrec" name="copyPrec" ng-model="data.oracleCloneEnv.copyPrec" min="0">
            	</span>
      	 </label>
      	 <label > <cv:msg key="label.recoverTo" bundle="oracle"/> </label>
      	  <label class="element-indent-class">
           	<span class="page-detail-column">
				<input type="radio" ng-model="data.oracleCloneEnv.pitType" value="0" id="mostRecent" name="mostRecent" />
				<label for="mostRecent" > <cv:msg key="label.mostRecent" bundle="oracle"/> </label>
           	</span>
           	<span class="page-detail-column float-right">
			</span>
           </label>
      	 <label class="element-indent-class">
           	<span class="page-detail-column float-left">
           		<input type="radio" ng-model="data.oracleCloneEnv.pitType" value="1" id="pitDate1" name="pitDate1" />
				<label for="pitDate1" ><cv:msg key="label.pit" bundle="oracle"/></label>
           	</span>
           	<span  class="page-detail-column date-input-holder float-right">
				<input ng-disabled="(data.oracleCloneEnv.pitType != '1')" name="pitDate" id="pitDate" type="text"  data-ng-model="data.oracleCloneEnv.pitDate" />
			    <cv-date-time ng-disabled="(data.oracleCloneEnv.pitType != '1')" heading-label="To Time" result-function="resultFunction" >
			    	<button id="snapClone_button_#8079" ng-disabled="(data.oracleCloneEnv.pitType != '1')" type="button" class="btn btn-default"  > 
						<i class="glyphicon glyphicon-calendar"></i>
					</button>
				</cv-date-time>
			</span>
           </label>
     	 </div>
	</cv-tab>
    <cv-tab tabname='<cv:msg key="label.summary" bundle="servers" />' >
      <div class="form-panel-holder">
	   <cv-tile-component data-ac-id="heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' data-loader="data">
			<label>
				<span class="page-detail-column"><cv:msg key="label.clientName" bundle="clients"/></span>
				<span class="page-detail-column float-right"	data-ng-bind="data.destClient.clientName"></span>
			</label>
			<label>
				<span class="page-detail-column"><cv:msg key="label.instanceName" bundle="clients"/></span>
				<span class="page-detail-column float-right"	data-ng-bind="data.orclInstance.instanceName"></span>
			</label>
			<label>
				<span class="page-detail-column"><cv:msg key="label.oracleHome" bundle="oracle"/></span>
				<span class="page-detail-column float-right"	data-ng-bind="data.oracleCloneEnv.oraHome"></span>
			</label>
			<label>
				<span class="page-detail-column"><cv:msg key="label.userName" bundle="servers"/></span>
				<span class="page-detail-column float-right" data-ng-bind="data.oracleCloneEnv.oraUser"></span>
			</label>
			<label>
				<span ng-hide="data.oracleCloneEnv.cloneType =='RMANDUPLICATE' ">
				<span class="page-detail-column"><cv:msg key="label.pFile" bundle="oracle"/></span>
				<span class="page-detail-column float-right" data-ng-bind="data.oracleCloneEnv.oraPfile"></span>
				</span>
			</label>
			<label>
				<span ng-hide="data.oracleCloneEnv.cloneType =='RMANDUPLICATE' ">
					<span class="page-detail-column"><cv:msg key="label.cloneDir" bundle="oracle"/></span>
					<span class="page-detail-column float-right" data-ng-bind="data.oracleCloneEnv.stagingPath"></span>
				</span>
			</label>
		</cv-tile-component>
		 <cv-tile-component data-ac-id="label_options-oracle" data-title='<cv:msg key="label.options" bundle="oracle" />'>
			<label>
				<span class="page-detail-column"><cv:msg key="label.cloneReservation" bundle="oracle" /></span>
				<span class="page-detail-column  float-right">
						{{data.oracleCloneEnv.rsvTPDays}}  <cv:msg key="days" bundle="messagesJs"/>
	   					{{data.oracleCloneEnv.rsvTPHours}}  <cv:msg key="hours" bundle="messagesJs"/>
					</span>
			</label>
			<label>
				<span class="page-detail-column"><cv:msg key="label.overfideExists" bundle="oracle" /></span>
				<span class="page-detail-column  float-right"	data-ng-bind="data.oracleCloneEnv.overfideExists | boolToString"></span>
			</label>
			<label>
				<span class="page-detail-column"><cv:msg key="label.copyPrec" bundle="oracle" /></span>
				 <span class="page-detail-column float-right"	data-ng-bind="data.oracleCloneEnv.copyPrec"></span>
			 </label>
			 <label>
				<span class="page-detail-column"><cv:msg key="label.pit" bundle="oracle" /></span>
				<span class="page-detail-column float-right"	data-ng-bind="data.oracleCloneEnv.pitDate"></span>
			</label>
		</cv-tile-component>
		</div>
      </cv-tab>
    </cv-tabset-component>
   		<div class="button-container" >
			<button id="snapClone_button_#8278" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="closeModal()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="snapClone_button_#2600" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Submit" bundle="messages" /></button> 
		</div>
	</form>
</div>
