<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<div class="row" data-ng-if="showClientGroupTiles && clientGroupDetails">
	<div class="col-xs-12 flex-detail-header padding-bottom-20" >
		<cv-changename data-ng-if="clientGroupDetails.userHasAgentManagementPermission" obj="changeClientGroupNameObj" service-method="changeClientGroupName.do" callback="changeClientGroupNameCallback"></cv-changename>
		<h1 data-ng-if="!clientGroupDetails.userHasAgentManagementPermission" class="float-left page-title" data-ng-bind="clientGroupDetails.clientGroup.clientGroupName"></h1>
		<cv-capability-links class="flex-page-actions" data-ng-if="permittedOptions" cv-permitted-options="permittedOptions"></cv-capability-links>
	</div>
</div>
<div data-ng-disabled= "showClientGroupTiles && !clientGroupDetails.userHasAgentManagementPermission">
<div class="row" data-ng-if="showClientGroupTiles && !isServerTabSelected">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="clientDetails-pageHeader_dlp-settings" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' loader="clientGroupDetails.dlpPropertise">
			<ul class="list-style__row group">
				<!-- region add/edit block -->
                <li class="group" data-ng-if="planRuleEnabled">
						<cv-region-select class="planMigration-block" data-cv-client-id="clientGroupId" data-cv-client-region-info="clientRegion" client-api="ClientGroup"></cv-region-select>
				</li>
				 <!-- End region add/edit block -->
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.showDLP" bundle="clients" /> </span>
					<span class="pageDetailColumn pull-right">
						<toggle-control class="dlpShowToggle" status="dlpShowToggle" data-ng-click="showHideDLP()" title="<cv:msg key="label.enableDisable" bundle="messages"/>"></toggle-control>
					</span>
				</li>

               <li class="group">
					<span class="pageDetailColumn"><cv-help-text help-label="label.enableAutoDiscover" help-text="label.autoDiscoverServerGroupHelpText" bundle='clients'/></span>
					<span class="pageDetailColumn pull-right">
						<toggle-control status="autoDiscoverToggle" data-ng-click="enableDisableAutoDiscover()" title="<cv:msg key='label.enableAutoDiscover' bundle='clients'/>"></toggle-control>
					</span>
				</li>


				<li class="group" ng-if="jobStartTimeProps">
					<span class="pageDetailColumn"><cv:msg key="label.jobStartTime" bundle="profiles" /></span>
                	<span class="pageDetailColumn">
                		<cv-job-start-time on-save="jobStartTimeProps.onStartTimeChange(isEnabled, jobStartTime)" on-reset="jobStartTimeProps.onStartTimeChange()" job-start-time="jobStartTimeProps.jobStartTimeObj"></cv-job-start-time>
                	</span>
				</li>
			</ul>
		</cv-tile-component>

		<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded'></cv-security-component>

		<cv-activity-control-component data-ac-params="acParams"></cv-activity-control-component>
	</div>

   	<div class="col-md-6">
		<div data-ng-if="showClientGroupTiles && clientGroupDetails">
			<cv-sla-options data-entity-data="clientGroupDetails" data-entity-type="entityType" data-entity-id="clientGroupId"></cv-sla-options>
		</div>
       	<div data-ng-show=clientGroupDetails.powerManagementInfo.isPowerMgmtSupported>
            <cv-tile-component data-ac-id = "title-powerManagement" data-title='<cv:msg key="title.powerManagement" bundle="storage"/>'>
            <div class="page-details-box-links" >
            <a href="" data-ng-click="editClientGroupPowerMgnt(clientGroupDetails.clientGroup.clientGroupId)"><cv:msg key="action.edit" bundle="storage" /></a>
            </div>

            <ul class="list-style-secondary">
	            <li class="group" data-ng-show="!clientGroupDetails.powerManagementInfo.isPowerManagementEnabled">
	                <span class="pageDetailColumn"><cv:msg key="label.powerManagementDisabled" bundle="storage" /></span>
	            </li>
	            <li class="group" data-ng-show="clientGroupDetails.powerManagementInfo.isPowerManagementEnabled">
	                <span class="pageDetailColumn"><cv:msg key="label.cloudController" bundle="storage" /></span>
	                <span class="pageDetailColumn" data-ng-bind="clientGroupDetails.powerManagementInfo.selectedCloudController.clientName"></span>
	            </li>
            </ul>
            </cv-tile-component>
        </div>
		<cv-global-exceptions-component data="clientGroupDetails" id = "clientGroupId" source-page = "clientGroupDetails"></cv-global-exceptions-component>
		<div>
			<cv-tile-component data-ac-id = "title-blackoutWindow" data-title='<cv:msg key="title.blackoutWindow" bundle="clients"/>' data-loader="gridBackupWindowOptions">
            	<div class="page-details-box-links">
            		<a href="" data-ng-click="_addBackupWindow(undefined)"><cv:msg key="action.addBackupWindow" bundle="clients" /></a>
				</div>
				<div class="backup-window-height" >
					<cv-kendo-grid data-cv-grid-options="gridBackupWindowOptions" data-ng-if="gridBackupWindowOptions && showBackupWindowTable" >
					</cv-kendo-grid>
				</div>
				<div  class="margin-top-30 pageDetailColumn margin-bottom-30" data-ng-if="!showBackupWindowTable"><cv:msg key="action.noBackupWindowAdded" bundle="clients" /></div>

            </cv-tile-component>
		</div>
		<div>
			<cv-tile-component data-ng-if="showHttpProxySettings" data-ac-id="clientGroupDetails-title_httpproxy" data-title='<cv:msg key="label.httpProxy" bundle="navJs" />'>
			   	<div class="page-details-box-links" data-ng-if="clientGroupDetails.httpProxyEnabled" >
	            	<a href="" data-ng-click="editHttpProxy(true)"><cv:msg key="action.edit" bundle="storage" /></a>
	            </div>
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.proxyServer" bundle="settings" /> </span>
						<span class="pageDetailColumn pull-right">
							<toggle-control  status="httpProxyToggle" data-ng-click="editHttpProxy()" title="<cv:msg key="label.enableDisable" bundle="messages"/>"></toggle-control>
						</span>
					</li>
					<li data-ng-if="clientGroupDetails.httpProxyEnabled" class="group">
						<span class="pageDetailColumn"><cv:msg key="label.hostname" bundle="servers" /> </span>
						<span class="pageDetailColumn pull-right" data-ng-bind="clientGroupDetails.httpProxy.server"></span>
					</li>
				</ul>
			</cv-tile-component>
		</div>
		<cv-entity-tags-tile data-ng-if="entityObject" entity="entityObject" has-edit-permissions="userHasEditTagsPermission"></cv-entity-tags-tile>
	</div>
</div>
</div>
<div data-ng-if="!showClientGroupTiles">
<cv-server-filter filter-list="serversFilter" filter-current="currentFilterType"></cv-server-filter>
</div>
<div data-ng-if="!showClientGroupTiles || isServerTabSelected">
<cv-kendo-grid data-cv-grid-options="gridOptions">
	<svg data-cv-on-grid-empty class="add-new-placeholder" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25">
		<path d="M11.3,18A6.3,6.3,0,0,1,17,11.7V1H2V24H15.5A6.3,6.3,0,0,1,11.3,18ZM4,4H15V5H4ZM4,6H15V7H4ZM4,8H15V9H4Zm6,12H8V18h2Zm11.8-2.4,1.1-.4a5.4,5.4,0,0,0-.9-2.2l-1.1.5-.7-.7.5-1.1a5.4,5.4,0,0,0-2.2-.9l-.4,1.1h-.9l-.4-1.1a5.4,5.4,0,0,0-2.2.9l.5,1.1-.7.7-1.1-.5a5.4,5.4,0,0,0-.9,2.2l1.1.4v.9l-1.1.4a5.4,5.4,0,0,0,.9,2.2l1.1-.5.7.7-.5,1.1a5.4,5.4,0,0,0,2.2.9l.4-1.1h.9l.4,1.1a5.4,5.4,0,0,0,2.2-.9l-.5-1.1.7-.7,1.1.5a5.4,5.4,0,0,0,.9-2.2l-1.1-.4Zm-4.2,2.9a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,17.6,20.4Zm1.6-2.5a1.6,1.6,0,1,1-1.6-1.6A1.6,1.6,0,0,1,19.2,17.9Z"/>
	</svg>
</cv-kendo-grid>
