<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
  <cv:cvMessages bundle="localization.collections"></cv:cvMessages>
  <cv:cvMessages bundle="localization.users"></cv:cvMessages>
  <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
  <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
  <cv:cvMessages bundle="localization.security"></cv:cvMessages>
</script>
<style>
	.detailsName {
		padding-left: 24px !important;
		width: calc(50% - 24px) !important;
	}
	.totalLineWidth {
		width: calc(100% - 24px) !important;
		padding-left: 0px;
	}
	.page-details-box .list-style-secondary li.in-app-designer {
		padding: 5px 2px;
	}
</style>
<cv-tile-component hide-title='hideTitle' data-ac-id="heading_Security-clients" data-title='<cv:msg key="heading.Security" bundle="clients"/>' data-min-height="true" loader="associationsLoaded" >
	<div data-ng-if="showOwners && associationsLoaded">
		<cv-tabset-component element="cvtile" default-tab="defaultTab">
			<!-- TAB 1: ASSOCIATIONS -->
			<cv-tab tabname="<cv:msg key="label.associations" bundle="users" />">
				<span data-ng-if="!hasAnyAssociationsAvailable()">
					<p data-ng-if="!loadingInheritedAssociation" class="info-place-holder center"><cv:msg key="info.noSecurityAssociationsDefined" bundle="users" /> </p>
					<p class="info-place-holder center" data-ng-if="loadingInheritedAssociation"><cv:msg key="Loading" bundle="messages" /></p>
				</span>
				<div data-ng-if="hasAnyAssociationsAvailable()">
					<ul class="list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn userGroupColumn"><b><cv:msg key="label.userOrGroupName" bundle="users" /></b></span>
							<span class="pageDetailColumn">
							<b data-ng-if="!hasPermissions"><cv:msg key="label.Role" bundle="users" /></b>
							<b data-ng-if="hasPermissions">Permissions</b>
							<span data-ng-if="visibleInheritedAssociation"> (<cv:msg key="label.DefinedIn" bundle="clients" />)</span></span>
						</li>
					</ul>
					<ul class="list-style-secondary list-overflow-scroll">
						<li class="group" title="{{user.entityType}}"  data-ng-repeat="user in associations.creatorAssociations track by $index">
							<span class="pageDetailColumn inheritedSecurityAssociation {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
							<span class="pageDetailColumn inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
						</li>
						<li class="group" title="{{user.entityType}}" data-ng-repeat="user in associations.associations track by $index">
							<span class="pageDetailColumn {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
							<span class="pageDetailColumn ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
						</li>
						<li data-ng-if="loadingInheritedAssociation">
							<span class="info-place-holder" data-ng-if="loadingInheritedAssociation"><cv:msg key="Loading" bundle="messages" /></span>
						</li>
						<div data-ng-if="!hideInheritedAssociations && visibleInheritedAssociation">
							<li class="group" title="{{user.entityType}}" data-ng-repeat="user in associations.inheritedAssociations track by $index">
								<span class="pageDetailColumn inheritedSecurityAssociation {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
								<span class="pageDetailColumn inheritedSecurityAssociation ellipsis-parent ellipsis-content" title="{{user.roleName  + ' (' + user.definedIn + ')'}}">{{user.roleName  + ' (' + user.definedIn + ')'}}</span>
							</li>
						</div>
					</ul>
				</div>
				<div data-ng-if="!hideInheritedAssociations && associationsLoaded" class="tile-link-wrapper">
					<a data-ng-if="!loadingInheritedAssociation && !loadedInheritedAssociation || !visibleInheritedAssociation" class="tile-content-link" data-ng-click="getInheritedAssociation()"><cv:msg key="label.showInheritedAssociation" bundle="clients" /></a>
					<a data-ng-if="loadedInheritedAssociation && visibleInheritedAssociation" class="tile-content-link"  data-ng-click="setVisibleInheritedAssociation()"><cv:msg key="label.hideInheritedAssociation" bundle="clients"/></a>
				</div>
			</cv-tab>
			<!-- TAB 2: CLIENT OWNERS -->
			<cv-tab tabname="<cv:msg key="label.owners" bundle="users" />">
				<span data-ng-hide="hasOwnerAssociationsConfigured()"><p class="info-place-holder"><cv:msg key="error.noOwnersConfigured" bundle="users" /></p></span>
				<ul class="list-style-secondary list-overflow-scroll" >
					<li class="group" title="{{user.entityType}}" data-ng-repeat="user in associations.ownerAssociations.usersList track by $index">
						<span class="pageDetailColumn {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content full-width" data-ng-bind="user.userName" title="{{user.userName}}"></span>
					</li>
					<li class="group" title="{{userGroup.entityType}}" data-ng-repeat="userGroup in associations.ownerAssociations.userGroupsList track by $index">
						<span class="pageDetailColumn {{userGroup.cssName}} userGroupColumn ellipsis-parent ellipsis-content full-width" data-ng-bind="userGroup.userGroupName" title="{{user.userGroupName}}"></span>
					</li>
				</ul>
			</cv-tab>
			<!-- TAB 3: CLIENT OWNERS PERMISSIONS-->
			<cv-tab tabname="<cv:msg key="label.permissions" bundle="users" />">
				<span data-ng-if="!associations.ownerAssociations.permissionsList || (associations.ownerAssociations.permissionsList.length === 0)"><p class="info-place-holder"><cv:msg key="error.noPermissionConfigured" bundle="users" /></p></span>
				<div data-ng-if="associations.ownerAssociations.permissionsList && (associations.ownerAssociations.permissionsList.length > 0)">
					<ul class="list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn"><b><cv:msg key="label.permissions" bundle="users" /></b></span>
							<span class="pageDetailColumn"><b><cv:msg key="label.definedIn" bundle="users" /></b></span>
						</li>
					</ul>
					<ul class="list-style-secondary" data-ng-repeat="permission in associations.ownerAssociations.permissionsList | orderBy: 'name'">
						<li class="group">
							<span class="pageDetailColumn ellipsis-parent ellipsis-content" title="{{permission.name}}">{{permission.name}} <span data-ng-if="permission.exclusion"> (<cv:msg key="label.withExclusion" bundle="users" />) </span></span>
							<span class="pageDetailColumn ellipsis-parent ellipsis-content" title="{{permission.category}}">{{permission.category}}</span>
						</li>
					</ul>
				</div>
			</cv-tab>
		</cv-tabset-component>
	</div>
	<div data-ng-if = "!showOwners && associationsLoaded">
		<span data-ng-if="!hasAnyAssociationsAvailable()">
			<p class="info-place-holder center"><cv:msg key="info.noSecurityAssociationsDefined" bundle="users" /> </p>
			<p class="info-place-holder center" data-ng-if="loadingInheritedAssociation"><cv:msg key="Loading" bundle="messages" /></p>
		</span>
		<div data-ng-if="hasAnyAssociationsAvailable()">
			<ul class="list-style-secondary" ng-if="!isAdminConsole">
				<li class="group">
					<span class="pageDetailColumn userGroupColumn detailsName"><b><cv:msg key="label.userOrGroupName" bundle="users" /></b></span>
					<span class="pageDetailColumn">
						<b data-ng-if="!hasPermissions"><cv:msg key="label.Role" bundle="users" /></b>
						<b data-ng-if="hasPermissions">Permissions</b>
						<span data-ng-if="visibleInheritedAssociation">(<cv:msg key="label.DefinedIn" bundle="clients" />)</span>
					</span>
				</li>
			</ul>
			<ul ng-if="hasPermissions" class="list-style-secondary list-overflow-scroll">
				<li class="group in-app-designer" title="{{user.entityType}}" data-ng-repeat="user in associations.associations track by $index" ng-if="isAdminConsole && showAssociation(user)">
					<span class="pageDetailColumn totalLineWidth {{user.cssName}} ellipsis-parent ellipsis-content">
						<b>{{ user.userOrGroup[0].userName || user.userOrGroup[0].userGroupName || user.userOrGroup[0].externalGroupName }}</b>
					</span>
					<span ng-if="user.properties.isCreatorAssociation" class="pageDetailColumn totalLineWidth {{user.cssName}} ellipsis-parent ellipsis-content">
						{{ "Owner" }}
					</span>
					<span
						ng-if="!user.properties.isCreatorAssociation"
						class="pageDetailColumn totalLineWidth {{user.cssName}} ellipsis-parent ellipsis-content"
						tooltip-placement="top" uib-tooltip="{{getPermissionsString(user)}}"
					>
						{{getPermissionsString(user)}}
					</span>
				</li>
				<li ng-if="!isAdminConsole" class="group" title="{{user.entityType}}" data-ng-repeat="user in associations.associations track by $index">
					<span class="pageDetailColumn {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content detailsName">
						{{ user.userOrGroup[0].userName || user.userOrGroup[0].userGroupName || user.userOrGroup[0].externalGroupName }}
					</span>
					<span class="pageDetailColumn {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" title="{{user.userOrGroup[0]['userName']}}"></span>
					<span class="pageDetailColumn ellipsis-parent ellipsis-content" ng-if="user.properties.isCreatorAssociation" style="color: #369;">Owner</span>
					<span class="pageDetailColumn ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}" ng-if="!user.properties.isCreatorAssociation"></span>
				</li>
			</ul>
			<ul ng-if="!hasPermissions" class="list-style-secondary list-overflow-scroll">
				<li class="group" title="{{user.entityType}}"  data-ng-repeat="user in associations.creatorAssociations track by $index">
					<span class="pageDetailColumn inheritedSecurityAssociation {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
					<span class="pageDetailColumn inheritedSecurityAssociation ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
				</li>
				<li class="group" title="{{user.entityType}}" data-ng-repeat="user in associations.associations track by $index">
					<span class="pageDetailColumn {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
					<span class="pageDetailColumn ellipsis-parent ellipsis-content" data-ng-bind="user.roleName" title="{{user.roleName}}"></span>
				</li>
				<li data-ng-if="loadingInheritedAssociation">
					<span class="info-place-holder" data-ng-if="loadingInheritedAssociation"><cv:msg key="Loading" bundle="messages" /></span>
				</li>
				<div data-ng-if="!hideInheritedAssociations && visibleInheritedAssociation">
					<li class="group" title="{{user.entityType}}" data-ng-repeat="user in associations.inheritedAssociations track by $index">
						<span class="pageDetailColumn inheritedSecurityAssociation {{user.cssName}} userGroupColumn ellipsis-parent ellipsis-content" data-ng-bind="user.userOrGroupName" title="{{user.userOrGroupName}}"></span>
						<span class="pageDetailColumn inheritedSecurityAssociation ellipsis-parent ellipsis-content" title="{{user.roleName  + ' (' + user.definedIn + ')'}}">{{user.roleName  + ' (' + user.definedIn + ')'}}</span>
					</li>
				</div>
			</ul>
		</div>
		<span data-ng-if="!hideInheritedAssociations && associationsLoaded" class="tile-link-wrapper">
			<a data-ng-if="!loadingInheritedAssociation && !loadedInheritedAssociation || !visibleInheritedAssociation" class="tile-content-link" data-ng-click="getInheritedAssociation()"><cv:msg key="label.showInheritedAssociation" bundle="clients" /></a>
			<a data-ng-if="loadedInheritedAssociation && visibleInheritedAssociation" class="tile-content-link"  data-ng-click="setVisibleInheritedAssociation()"><cv:msg key="label.hideInheritedAssociation" bundle="clients"/></a>
		</span>
	</div>
	<div class="page-details-box-links" data-ng-if="showEdit">
		<a href="" data-ng-click="handleEdit()">
			<cv:msg key="action.edit" bundle="collections" />
		</a>
	</div>
</cv-tile-component>