<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="model.mode=='ADD'"><cv:msg key="label.addSchedule" bundle="schedule"/></h1>
	<h1 data-ng-if="model.mode=='EDIT'"><cv:msg key="label.editSchedule" bundle="profiles"/></h1>
</div>
<div class="setup-content schedule">
	<form name="addReportScheduleForm" id="addReportScheduleForm" data-cv-submit="onReportScheduleFormSubmit()" novalidate autocomplete="off" class="schedules-form" id="schedules-form">
		<!-- // name // -->
		<div class="modal-wrapper">
			<label for="name" class="label wrap-normal"><cv:msg key="label.scheduleName" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<input type="text" name="name" data-ng-model="model.scheduleName" id="name"/>
			</div>
		</div>
		<!-- // Report Custom Name // -->
		<div data-ng-disabled="model.button.endUserSecurity" class="modal-wrapper" data-ng-keyup="enableOrDisableEndUserSecurity()">
					<label for="reportCustomName" class="label wrap-normal"><cv:msg key="label.reportName" bundle="schedule"/></label>
					<div class="inline-wrapper">
						<input data-ng-disabled="model.button.endUserSecurity" type="text" name="reportCustomnName" data-ng-model="model.reportCustomName" id="reportCustomName"/>
					</div>
		</div>
		<!-- // format // -->
		<div class="modal-wrapper">
			<label class="label wrap-normal"><cv:msg key="label.format" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<div class="row">
					<div class="col-xs-12">
						<isteven-multi-select
								directive-id="outputFormatSelect"
								input-model="data.outputTypes"
								output-model="model.selectedFormats"
								tick-property="selected"
								button-label="label"
								class="isteven-multi-select"
								item-label="label"
								on-item-click="handleFormatClick(data)"
								helper-elements="filter"
								selection-mode="single">
						</isteven-multi-select>
					</div>
				</div>
			</div>
		</div>
		<!-- // Component Selection // -->
		<div class="modal-wrapper" data-ng-if="model.showComponentSelection && model.componentList.length > 1">
			<label class="label wrap-normal"><cv:msg key="label.componentSelection" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<isteven-multi-select
					input-model="model.componentList"
					output-model="model.selectedComponents"
					button-label="name"
					item-label="name"
					directive-id="componentSelect"
					tick-property="selected"
					helper-elements="filter"
					max-labels="2"
					translation="model.componentSelectionTranslation">
				</isteven-multi-select>
			</div>
		</div>

		<!-- // Compress // -->
		<div class="modal-wrapper">
			<label class="label wrap-normal"><cv:msg key="label.compressFile" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<cv-toggle toggle-name="compressToggle" value="model.button.compressFile" is-disabled="emailBodySelected" on-click="model.button.changeState('compressFile',model.button.compressFile)"></cv-toggle>
			</div>
		</div>
		<!-- // Hide report Summary // -->
		<div class="modal-wrapper" data-ng-if="model.showComponentSelection">
			<label class="label wrap-normal"><cv:msg key="label.hideReportSummary" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<cv-toggle toggle-name="hideReportSummaryToggle" value="model.button.hideReportSummary" on-click="model.button.changeState('hideReportSummary',model.button.hideReportSummary)"></cv-toggle>
			</div>
		</div>
		<!-- // EndUserSecurity // -->
		<div data-ng-disabled="!model.enableEndUserSecurity" class="modal-wrapper" data-ng-if="model.showEndUserSecurity">
			<label for="format" class="label wrap-normal">
				<span>
					<cv-help-text help-label="<cv:msg key="label.endUserSecurity" bundle="schedule" />" help-text="'<cv:msg key='label.endUserSecurityToolTip' bundle='schedule' />'">
					</cv-help-text>
				</span>
			</label>
			<div class="inline-wrapper">
				<cv-toggle data-ng-disabled="!model.enableEndUserSecurity" toggle-name="endUserSecurity" value="model.button.endUserSecurity" on-click="model.button.changeState('endUserSecurity',model.button.endUserSecurity)"></cv-toggle>
			</div>
		</div>



		<!-- // Users to notify // -->
		<div class="modal-wrapper" data-ng-if="!isSavedUsersToNotifyLoading">
			<label for="usersToNotify" class="label wrap-normal"><cv:msg key="label.Email_to_Users" bundle="schedule"/></label>
			<div class="inline-wrapper users-to-notify-container" id="usersToNotifySearchContainer">
				<input type="text" id="field" name="field" placeholder="<cv:msg key="label.Search_Users_Usergroups" bundle="schedule"/>" data-ng-model="model.userSearchText" data-ng-keyup="searchUsersList()">
				<div data-ng-class="{'loading': model.searchInProgress}"></div>
				<div class="clear-search" data-ng-click="clearUsersSearch()" data-ng-if="model.userSearchText && !model.searchInProgress">&times;</div>
				<div class="search-results" data-ng-if="model.usersSearchList">
						<ul class="search-results-list">
							<li class="search-result" data-ng-repeat="userItem in model.usersSearchList track by $index" data-ng-click="addUserToList(userItem)">
								<span class="user-icon " data-ng-class="{'user-type': userItem.type == 1 ,'group-type': userItem.type == 2}"></span><span class="suggestedText vw-text" title="{{userItem.displayName}}"><span class="displayNameContainer">{{userItem.displayName}}</span></span>
							</li>
							<li class="search-result" data-ng-if="model.usersSearchList.length == 0">
								<cv:msg key="label.noResults" bundle="schedule"/>
							</li>
						</ul>
			    </div>
			    <!-- Displaying added users -->
			    <div data-ng-if="model.usersToNotifyList && model.usersToNotifyList.length > 0">
			    	<ul class="users-list">
							<li class="user-item" data-ng-repeat="userItem in model.usersToNotifyList track by $index">
								<span class="user-icon " data-ng-class="{'user-type': userItem.type == 1 ,'group-type': userItem.type == 2}"></span><span class="suggestedText vw-text" title="{{userItem.displayName}}"><span class="displayNameContainer">{{userItem.displayName}}</span></span>
								<div class="remove-user" data-ng-click="removeUserFromList(userItem)">&times;</div>
							</li>
					</ul>
			    </div>
			</div>
		</div>
		<div class="modal-wrapper" data-ng-if="isSavedUsersToNotifyLoading">
			<cv:msg key="label.loadingUsers" bundle="schedule"/>
		</div>
		<!-- // Email Recipient // -->
		<div data-ng-disabled="model.button.endUserSecurity" class="modal-wrapper">
			<label for="emails" class="label wrap-normal"><cv:msg key="label.emailRecipients" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<input data-ng-disabled="model.button.endUserSecurity" type="text" name="emailRecipients" data-ng-model="model.commaSeparatedEmails"
				placeholder="<cv:msg key="placeholder.commaSeparatedEmails" bundle="schedule"/>" data-ng-class="emailListClass()" />
			</div>
		</div>
		<div data-ng-if="!isPublicCloud && !isTenantUserType">
			<!-- // Save to network path toggle // -->
			<div class="modal-wrapper">
				<label for="save_to_netWork" class="label wrap-normal"><cv:msg key="label.saveToNetWork" bundle="schedule"/></label>
				<div class="inline-wrapper">
					<cv-toggle toggle-name="saveToNetworkToggle" value="model.button.saveToNetworkToggle" is-disabled="emailBodySelected" on-click="model.button.changeState('saveToNetworkToggle',model.button.saveToNetworkToggle)"></cv-toggle>
				</div>
			</div>
			<!-- // Save to network path data // -->
			<div data-ng-show="model.button.saveToNetworkToggle" class="padding-left-10">
					<div class="modal-wrapper">
						<label for="network_path" class="label wrap-normal"><cv:msg key="label.networkPath" bundle="schedule"/></label>
						<div class="inline-wrapper">
							<input type="text" name="network_path" data-ng-model="model.networkPath" data-ng-disabled="emailBodySelected"/>
						</div>
					</div>
					<div class="modal-wrapper">
						<label for="network_username" class="label wrap-normal"><cv:msg key="label.networkUsername" bundle="schedule"/></label>
						<div class="inline-wrapper">
							<input type="text" name="network_username" data-ng-model="model.networkUsername" data-ng-disabled="emailBodySelected"/>
						</div>
					</div>
					<div class="modal-wrapper">
						<label for="network_password" class="label wrap-normal"><cv:msg key="label.networkPassword" bundle="schedule"/></label>
						<div class="inline-wrapper">
							<input type="password" name="network_password" data-ng-focus="networkPasswordFocused()" data-ng-blur="networkPasswordBlurred()" data-ng-model="model.networkPassword" data-ng-disabled="emailBodySelected"/>
						</div>
					</div>
			</div>
		</div>
		<!-- // Locale // -->
		<div class="modal-wrapper" data-ng-if="data.baseInfo.localeList">
			<label for="locale" class="label wrap-normal"><cv:msg key="label.locale" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<isteven-multi-select id="reportScheduleModal_isteven-multi-select_#0262"
					input-model="data.baseInfo.localeList"
					output-model="model.selectedLocale"
					button-label="displayString"
					item-label="displayString"
					tick-property="selected"
					helper-elements="none"
					selection-mode="single"
					class="isteven-multi-select user-group-select"
					max-labels="1"
					ng-cloak>
				</isteven-multi-select>
			</div>
		</div>
		<!-- // Frequency // -->
		<div class="modal-wrapper margin-top-10">
			<label for="frequency" class="label wrap-normal"><cv:msg key="label.frequency" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<div class="row">
					<label class="col-xs-12" data-ng-repeat="freq in data.frequencyTypes">
						<input type="radio" name="frequency" value="{{freq.name}}" data-ng-model="model.scheduleFrequency">{{freq.label}}
					</label>
				</div>
			</div>
		</div>
		<!-- // Time // -->
		<div class="modal-wrapper">
			<label for="report_time" class="label wrap-normal"><cv:msg key="label.time2" bundle="schedule"/></label>
			<div class="inline-wrapper">
					<div uib-timepicker class="timeColumn no-margin" data-ng-model="model.reportTimePicker" minute-step="1" show-spinners="false"></div>
			</div>
		</div>
		<!-- // Time Zone // -->
		<div class="modal-wrapper" data-ng-if="data.baseInfo.timeZonesList.timezones">
			<label for="report_timezone" class="label wrap-normal"><cv:msg key="label.timezone" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<isteven-multi-select id="reportScheduleModal_isteven-multi-select_#1554"
					input-model="data.baseInfo.timeZonesList.timezones"
					output-model="model.selectedTimeZone"
					button-label="timezoneDisplayName"
					item-label="timezoneDisplayName"
					tick-property="selected"
					helper-elements="none"
					selection-mode="single"
					class="isteven-multi-select user-group-select"
					max-labels="1"
					ng-cloak>
				</isteven-multi-select>
			</div>
		</div>
		<!-- // Daily Repeat // -->
		<div class="modal-wrapper" data-ng-if="model.scheduleFrequency == 'DAILY'">
			<hr>
			<div class="col-xs-4 no-padding">
					<input id="daily_repeat_checkbox" class="" type="checkbox" data-ng-model="model.repeatDaily.enabled" />
					<label for="daily_repeat_checkbox"><cv:msg key="label.repeat" bundle="schedule"/> <cv:msg key="label.every" bundle="schedule"/></label>
			</div>
			<div class="inline-wrapper" data-ng-disabled="!model.repeatDaily.enabled">
					<input type="number" min="0" data-ng-model="model.repeatDaily.hours" /> <label class="inline-label no-margin"><cv:msg key="label.hours" bundle="schedule" /></label>
					<input type="number" min="0" data-ng-model="model.repeatDaily.minutes" /> <label class="inline-label no-margin"><cv:msg key="label.minutes" bundle="schedule" /></label>
					<br/>
					<cv:msg key="label.until" bundle="schedule" />
					<div uib-timepicker class="timeColumn no-margin" data-ng-model="model.repeatDaily.untilTime" minute-step="1" show-spinners="false"></div>
			</div>
		</div>
		<!-- // Weekly Repeat // -->
		<div class="modal-wrapper" data-ng-if="model.scheduleFrequency == 'WEEKLY'">
				<hr>
				<label for="report_time" class="label wrap-normal"><cv:msg key="label.daysOfWeek" bundle="settingsJs"/></label>
				<div class="inline-wrapper">
					<isteven-multi-select
						translation="data.multiSelectLocalLang"
						input-model="data.daysOfWeek"
						output-model="model.selectedDaysOfWeek"
						button-label="label"
						item-label="label"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="daysOfWeek"
						name="daysOfWeek"
						max-labels="3"
						helper-elements="all none"
						ng-cloak>
					</isteven-multi-select>
				</div>
		</div>
		<!-- // Monthly Repeat // -->
		<div class="modal-wrapper" data-ng-if="model.scheduleFrequency == 'MONTHLY'">
				<hr>
				<div class="col-xs-12 no-padding">
					<input id="onDay_radio" class="" type="radio" data-ng-model="model.monthlyType" value="ON_DAY"/><cv:msg key="label.onDay" bundle="schedule"/>
					<div class="inline-wrapper" data-ng-disabled="model.monthlyType!='ON_DAY'">
						<input type="number" min="1" data-ng-model="model.monthlyOnDay"/>
					</div>
				</div>
				<div class="col-xs-12 no-padding">
					<input id="custom_radio" class="" type="radio" data-ng-model="model.monthlyType" value="CUSTOM"/><cv:msg key="label.onThe" bundle="schedule"/>
					<div class="inline-wrapper" data-ng-disabled="model.monthlyType!='CUSTOM'">
						<div class="row">
							<div class="col-xs-6">
								<select
										data-ng-model="model.selectedDayNumInMonth"
										data-ng-options="day.value as day.label for day in data.prefixDayList">
								</select>
							</div>
							<div class="col-xs-6">
								<select
										data-ng-model="model.selectedWeekDayInMonth"
										data-ng-options="weekDay.value as weekDay.label for weekDay in data.days">
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="no-padding padding-top-10">
					<label for="repeat_every_month" class="label wrap-normal"><cv:msg key="label.repeatEvery" bundle="schedule"/></label>
					<div class="inline-wrapper">
						<input type="number" name="monthlyRepeat" data-ng-model="model.monthlyRepeat" />
						<cv:msg key="label.reportSchedule.months" bundle="schedule"/>
					</div>
				</div>
		</div>
		<div class="modal-wrapper error">
			{{scheduleErrorMessage}}
		</div>
		<div class="button-container">
				<button id="reportScheduleModal_button_edit_settings" type="button" class="btn btn-secondary cvBusyOnAjax" data-ng-if="model.mode=='EDIT'" data-ng-click="editReportSettings()"><cv:msg key="schedule.Update_schedule" bundle="schedule"/></button>
				<button id="reportScheduleModal_button_#4243" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
				<button id="reportScheduleModal_button_#8826" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="isSaveDisabled || isSavedUsersToNotifyLoading"><cv:msg key="action.save" bundle="profiles"/></button>
		</div>
	</form>
</div>
