<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.affectedServersList" bundle="servers" /></h1>
</div>

<form name="previewChangeCompany" novalidate autocomplete="off" >
	<div class="error" data-ng-if="previewCompanyChangeCtrl.errorMessage" data-ng-bind-html="previewCompanyChangeCtrl.errorMessage"></div>

	<div >
		<div class="padding-left-15 padding-top-15"  data-ng-if="previewCompanyChangeCtrl.eligibleServersString.length>0" >
			<div data-ng-if="previewCompanyChangeCtrl.companyId != 0"><cv:msg key="label.affectedServersMessage" bundle="servers" params="{{previewCompanyChangeCtrl.entityName}}" /><b><span class="padding-left-5" data-ng-bind="previewCompanyChangeCtrl.companyName"></span></b></div>
			<div data-ng-if="previewCompanyChangeCtrl.companyId == 0"><cv:msg key="label.commcellMigration" bundle="servers" params="{{previewCompanyChangeCtrl.entityName}}" /></div>
			<p  class="padding-left-15 padding-top-10" ng-bind-html="previewCompanyChangeCtrl.eligibleServersString"></p>
		</div>

		<div class="padding-left-15 padding-top-15"  data-ng-if="previewCompanyChangeCtrl.isServerGroup && previewCompanyChangeCtrl.eligibleServersString.length==0" >
			<div ><cv:msg key="label.commcellMigrationForServerGroup" bundle="servers" /></div>
			<p  class="padding-left-15 padding-top-10" ng-bind-html="previewCompanyChangeCtrl.serverGroupName"></p>
		</div>

		<div class="padding-left-15 padding-top-15"  data-ng-if="previewCompanyChangeCtrl.notApplicableClientsList.length>0" >
			<p><cv:msg key="label.unAffectedServersMessage" bundle="servers" params="{{previewCompanyChangeCtrl.entityName}}" /></p>
			<p class="padding-left-15 padding-top-10" ng-bind-html="previewCompanyChangeCtrl.inEligibleServersString"></p>
			<ul class="padding-left-15">
				<div data-ng-repeat="client in previewCompanyChangeCtrl.notApplicableClientsList">
					<li>
						<p ng-bind-html="client.status"></p>
						<p class="padding-left-15" ng-bind-html="client.serversString"></p>
					</br>
					</li>
				</div>
			</ul>
		</div>
		</br>

	</div>

	<p class="padding-15" data-ng-if="previewCompanyChangeCtrl.eligibleServersString.length>0"><cv:msg key="label.askProcced" bundle="users" /></p>
	</br>

	<div class="modal-footer">
		<button data-ng-if="!previewCompanyChangeCtrl.isEligibleForMigration"  id="previewChangeCompanyCancelButton" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="previewCompanyChangeCtrl.cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
		<button data-ng-if="previewCompanyChangeCtrl.isEligibleForMigration" id="previewChangeCompanyCancelButton" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="previewCompanyChangeCtrl.cancel()"><cv:msg key="button.no" bundle="messages" /></button>
		<button data-ng-if="previewCompanyChangeCtrl.isEligibleForMigration" id="previewChangeCompanySaveButton" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="previewCompanyChangeCtrl.save()"  ><cv:msg key="button.yes" bundle="messages" /></button>
	</div>
</form>
