<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script> 
<div>
	<div class="setup-title">
		<h1><cv:msg key="pageHeader.createServer" bundle="sqlserver"/></h1>
	</div>
	
	<div class="setup-content">
		<div data-ng-controller = "PanelController as panel">
		<form name="addMssqlServerForm" novalidate data-cv-submit="createNEWServer()" autocomplete="off" class="add-collection-form">
		<section> 
			 <ul class = "nav nav-tabs"> 
				<li data-ng-class="{ active: panel.isSelected(1)}"> 
					 <a href="" data-ng-click="panel.selectTab(1)"><cv:msg key="heading.clientGeneral" bundle="clients"/></a> 
				</li>
			 	<li data-ng-class="{ active: panel.isSelected(2)}">
					<a href="" data-ng-click="panel.selectTab(2)"><cv:msg key="label.accounts" bundle="sqlserver" /></a>
				</li>
				<li data-ng-class="{ active: panel.isSelected(3)}">
					<a href="" data-ng-click="panel.selectTab(3)"><cv:msg key="label.storagePolicies" bundle="sqlserver"/></a>
				</li>
			</ul>
		 	<div class = "panel" data-ng-show="panel.isSelected(1)">
				<label>
					<span class="pageDetailColumn"><cv:msg key="label.clientName" bundle="clients" /></span>
					<span class="pageDetailColumn"  data-ng-bind="sqlserverInfo.clientName"></span>
				</label>
				
				<label for="instanceName" class="select-label" ><cv:msg key="label.serverName" bundle="servers"/>
					<select name="instanceName" id="instanceName" 
						data-ng-options="servers.servername as servers.servername for servers in unconfiguredServers" 
						data-ng-model="sqlserverInfo.instanceName" required class="input">
						<option value=""><cv:msg key="label.selectInstance" bundle="sqlserver"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.addMssqlServerForm.needsAttention(addMssqlServerForm.instanceName);" ><cv:msg key="error.instanceName" bundle="sqlserver"/></span>
					<span class="help-block" data-ng-show= "checkDuplicateName(sqlserverInfo.instanceName)"> <cv:msg key="error.duplicateInstanceName" bundle="sqlserver"/> </span>
				</label>
				
				<label for="vdiTimeOut"><cv:msg key="label.vdiTimeOut" bundle="sqlserver"/>
					<input type="number" min="300" max="2147483647" value="300" id="vdiTimeOut" name="vdiTimeOut" data-ng-model="sqlserverInfo.vdiTimeOut" />
				</label>
				
				<input type="checkbox" id="useVSSenabled" name="useVss" data-ng-model="sqlserverInfo.useVss" />
				<label for="useVSSenabled"><cv:msg key="label.useVSSenabled" bundle="sqlserver" /></label>
									
				<label for="Description"><cv:msg key="Description" bundle="events"/>
					<br>
					<textarea rows="2" cols="65" id="description" name="name" class="resize-none" data-ng-model="sqlserverInfo.description"></textarea>
				</label>
			</div>			 
			<div class = "panel" data-ng-show="panel.isSelected(2)">
			<br>
				<input type="checkbox" id="overrideSettings" name="overrideHigherLevelsSettings" data-ng-model="sqlserverInfo.overrideHigherLevelsSettings"/>
				<label for="overrideSettings"><cv:msg key="label.overrideHigherLevelsSettings" bundle="sqlserver"/></label>
				
				<br>
				
				<input type="radio" name="uselocalSystemAccount" value="1" class="localAccount" data-ng-model="sqlserverInfo.useLocalSystemAccount" data-ng-disabled="sqlserverInfo.overrideHigherLevelsSettings===false">
				<label class="localAccountOption"> <cv:msg key="label.useLocalSystemAccount" bundle="sqlserver"/> </label>
				<input type="radio" name="uselocalSystemAccount" value="2" class="localAccount" data-ng-model="sqlserverInfo.useLocalSystemAccount" data-ng-disabled="sqlserverInfo.overrideHigherLevelsSettings===false">
				<label class="localAccountOption"> <cv:msg key="label.impersonateUser" bundle="sqlserver"/> </label>
				
				<label for="username" id="clientName"> <cv:msg key="label.userName" bundle="servers"/>
					<input type="text" id="username" name="username" class="credentials" data-ng-model="sqlserverInfo.username" data-ng-disabled = "((sqlserverInfo.useLocalSystemAccount == 1) || (sqlserverInfo.overrideHigherLevelsSettings === false))" 
											  																				      data-ng-required = "!((sqlserverInfo.useLocalSystemAccount == 1) || (sqlserverInfo.overrideHigherLevelsSettings === false))" />
					<span class="help-block" data-ng-show="cv.addMssqlServerForm.needsAttention(addMssqlServerForm.username);" ><cv:msg key="error.userName" bundle="users"/></span>
				</label>
				<label for="password" id="clientName"><cv:msg key="label.password" bundle="servers"/>
					<input type="text" id="password" name="password" class="credentials" data-ng-model="sqlserverInfo.password" data-ng-disabled = "((sqlserverInfo.useLocalSystemAccount == 1) || (sqlserverInfo.overrideHigherLevelsSettings === false))" 
																									   data-ng-required = "!((sqlserverInfo.useLocalSystemAccount == 1) || (sqlserverInfo.overrideHigherLevelsSettings === false))" />
					<span class="help-block" data-ng-show="cv.addMssqlServerForm.needsAttention(addMssqlServerForm.password);" ><cv:msg key="error.password" bundle="users"/></span>
				</label>					<br>
			</div>
			<!-- data-ng-required = "!((sqlserverInfo.useLocalSystemAccount == 1) || (sqlserverInfo.overrideHigherLevelsSettings === false))" -->
			<div class = "panel" data-ng-show="panel.isSelected(3)">			
					<label for="DBStoragePolicy" class="select-label" ><cv:msg key="label.defaultDataStoragePolicy" bundle="sqlserver"/>
					<select name="DBStoragePolicy" id="DBStoragePolicy" 
						data-ng-options="sp.storagePolicyName as sp.storagePolicyName for sp in sqlserverInfo.availableStoragePolicies" 
						data-ng-model="sqlserverInfo.associatedDBStoragePolicyName" required class="input">
						<!-- data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.userGroupType)}"> -->
						<option value=""><cv:msg key="label.selectStoragePolicy" bundle="clients"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.addMssqlServerForm.needsAttention(addMssqlServerForm.DBStoragePolicy)"><cv:msg key="error.DBStoragePolicy" bundle="sqlserver"/></span>
					</label>
					<label for="LogStoragePolicy" class="select-label" ><cv:msg key="label.defaultLogStoragePolicy" bundle="sqlserver"/>
					<select name="LogStoragePolicy" id="LogStoragePolicy" 
						data-ng-options="sp.storagePolicyName as sp.storagePolicyName for sp in sqlserverInfo.availableStoragePolicies" 
						data-ng-model="sqlserverInfo.associatedLogStoragePolicyName" required class="input">
						<!-- data-ng-class="{'has-error': cv.addUserForm.needsAttention(addUserForm.userGroupType)}"> -->
						<option value=""><cv:msg key="label.selectStoragePolicy" bundle="clients"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.addMssqlServerForm.needsAttention(addMssqlServerForm.LogStoragePolicy)"><cv:msg key="error.logStoragePolicy" bundle="sqlserver"/></span>
					</label>
			</div>
		
		</section>
				<div class="button-container">					
		  		<button id="newSQLServerDialog_button_#1427" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="closeDialogBox()"><cv:msg key="Cancel" bundle="messages"/></button> 
		  		<button id="newSQLServerDialog_button_#8044" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click=" 
		  			panel.validate( addMssqlServerForm.instanceName.$valid,
		  							addMssqlServerForm.DBStoragePolicy.$valid,
		  							addMssqlServerForm.LogStoragePolicy.$valid,
		  							addMssqlServerForm.username.$valid,
		  							addMssqlServerForm.password.$valid,
		  							!((sqlserverInfo.useLocalSystemAccount == 1) || (sqlserverInfo.overrideHigherLevelsSettings === false))
		  							 ); ">
		  							 <cv:msg key="OK" bundle="messages"/>
		  		</button>
			</div>
		</form>
		</div>
	</div>
</div>
