<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.EditContent" bundle="fs"/></h1>
</div>
<div class="setup-content">
	<section>
		<form name="rdsSubclientContentForm" class="add-collection-form" data-cv-submit="modifySubclientContent()" autocomplete="off" novalidate>
		<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
			<div class="page-details-group">
				<span class= "name"  > <label><b><cv:msg key="label.databaseList" bundle="sqlserver"/></b></label> </span>
				<div data-ng-if="contentEntityList.length ==0 && !autoUpdateList">
					<ul class="manageCollectionList list-style__row group">
						<li><cv:msg key="label.noDatabasesConfigured" bundle="sqlserver" /></li>
					</ul>
				</div>
				<div class="limit-modal-height" data-ng-if="contentEntityList.length>0">
					<div data-ng-class="{'overlay':autoUpdateList}">
					<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in contentEntityList">
						<li><span data-ng-bind="contentEntity.dbName"></span></li>
						<li><span class="delete-row"> <a href="" data-ng-click="removeFromSubclientContent(contentEntity)">&times; </a></span></li>
					</ul>
					</div>
				</div>			
				<input name="autoUpdateList" id="autoUpdateList" data-ng-model="autoUpdateList" type="checkbox" checked><label for="autoUpdateList"><cv:msg key="label.autoUpdateList" bundle="sqlserver" /></label>
				<div class="extra-top-padding">
					<button id="manageRdsSubclientContentModal_button_#8666" type="button" class="btn" data-ng-disabled="autoUpdateList" data-ng-click="configure()"><cv:msg key="label.configure" bundle="sqlserver"/></button> 
				</div>
			</div>
		 	<div class="button-container" >
			  		<button id="manageRdsSubclientContentModal_button_#7409" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			  		<button id="manageRdsSubclientContentModal_button_#7613" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="OK" bundle="messages"/>	</button> 
			</div>
		</form>
	</section>	
</div>
