<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><span ng-if="isArchiveClient"><cv:msg key="header.selectArchiveLevel" bundle="servers"/></span><span ng-if="!isArchiveClient"><cv:msg key="header.backupOptions" bundle="servers"/></span></h1>
</div>
<div class="setup-content backup-options">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<div class="bootstrap-wrapper">
	<span data-ng-show="!backupMsg" >
		<label data-ng-if="subclientName"><cv:msg key="info.backupSubclient" bundle="servers"/> : &nbsp;<b>{{subclientName}}</b></label>
		<div data-ng-show="!(isOneTouchSubclient && isIbmiClient)">
			<div class="global-options remove-border-padding">
				<label><span ng-if="isArchiveClient"><cv:msg key="label.archiveLevel" bundle="servers"/></span><span ng-if="!isArchiveClient"><cv:msg key="label.backupLevel" bundle="servers"/></span></label>
			</div>
	
			<div class="global-options remove-border-padding form-panel-holder">
				<label class="element-indent-class" data-ng-hide="hideFullBackupLevel">
					<input type="radio" ng-model="backupType" value="FULL">
					<cv:msg key="option.full" bundle="schedule"/>
				</label>
	
				<label class="element-indent-class" data-ng-show="isIncrementalSupported">
					<input type="radio" ng-model="backupType" value="INCREMENTAL">
					<cv:msg key="option.incremental" bundle="schedule"/>
				</label>
	
				<label class="element-indent-class" data-ng-show="isSyntheticFullSupported">
					<input type="radio" ng-model="backupType" value="SYNTHETIC_FULL">
					<cv:msg key="option.synthfull" bundle="schedule"/>
				</label>
	
				<label class="element-indent-class" data-ng-show="isDifferentialSupported">
					<input type="radio" ng-model="backupType" value="DIFFERENTIAL">
					<cv:msg key="option.differential" bundle="schedule"/>
				</label>
			</div>
		</div>
		<div data-ng-show="isIbmiClient && isOneTouchSubclient">
			<div class="global-options remove-border-padding form-panel-holder">
				<label class="element-indent-class" data-ng-hide="hideFullBackupLevel">
					<input type="radio" ng-model="dummyModel.rebootOption" value="RESUME">
					<cv:msg key="option.resume" bundle="schedule"/>
				</label>
	
				<label class="element-indent-class">
					<input type="radio" ng-model="dummyModel.rebootOption" value="REBOOT">
					<cv:msg key="option.reboot" bundle="schedule"/>
				</label>
			</div>			
		</div>
			<uib-accordion id="advancedBackupOptions" data-ng-if="false && isIbmiClient && !isOneTouchSubclient" close-others="true"  class="text-left" data-scroll-to-when-open data-ng-init="model.accordionStatus.advancedTab=true">
				<div uib-accordion-group data-is-open="model.accordionStatus.advancedTab" id="reset-margin-top">
					<uib-accordion-heading>
						<cv:msg key="label.advanced" bundle="clients"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': model.accordionStatus.advancedTab, 'glyphicon-chevron-right': !model.accordionStatus.advancedTab}"></i>
					</uib-accordion-heading>
		
					<div class="form-group row">
						<label class="margin-top-10-important col-xs-12 col-lg-4" for="outputType"><cv:msg key="label.logOutputDestination" bundle="clients" /></label>
						<div class="col-xs-12 col-lg-8">
							<select data-ng-model="logOutputOption.outputType" id="outputType" name="outputType" data-ng-options="item.value as item.label for item in ibmiAdvancedBackup.logOutputOption.outputType"></select>
						</div>
					</div>
										
					<div class="form-group row" data-ng-if="logOutputOption.outputType=='1'">
						<label class="margin-top-10-important col-xs-12 col-lg-4" for="outputTypeInfoPrint"><cv:msg key="label.typeOfOutputInfo" bundle="clients" /></label>
						<div class="col-xs-12 col-lg-8">
							<select data-ng-model="logOutputOption.outputTypeInfo" id="outputTypeInfoPrint" name="outputTypeInfoPrint" data-ng-options="item.value as item.label for item in ibmiAdvancedBackup.logOutputOption.outputTypeInfoPrint"></select>
						</div>
					</div>
					
					<div data-ng-if="logOutputOption.outputType=='2'">
						<div class="form-group row">
							<label class="margin-top-10-important col-xs-12 col-lg-4" for="outputfilename"><cv:msg key="label.outputFileName" bundle="clients" /></label>
							<div class="col-xs-12 col-lg-8">
								<input type="text" name="outputfilename" data-ng-class="text-right" id="outputfilename" data-ng-model="logOutputOption.outputfilename" data-ng-change="inputAlertFlags.outputfilename = false" required autofocus >
								<span class="help-block" data-ng-show="inputAlertFlags.outputfilename"><cv:msg key="error.outputFileName" bundle="clients" /></span>
							</div>
						</div>					
												
						<div class="form-group row">
							<label class="margin-top-10-important col-xs-12 col-lg-4" for="outputMember"><cv:msg key="label.outputMember" bundle="clients" /></label>
							<div class="col-xs-12 col-lg-8">
								<input type="text" name="outputMember" data-ng-class="text-right" id="outputMember" data-ng-model="logOutputOption.outputMember" data-ng-change="inputAlertFlags.outputMember = false" required autofocus >
								<span class="help-block" data-ng-show="inputAlertFlags.outputMember"><cv:msg key="error.outputMember" bundle="clients" /></span>
							</div>
						</div>					
						
						<div class="form-group row">
							<label class="margin-top-10-important col-xs-12 col-lg-4" for="membertype"><cv:msg key="label.outputMemberOption" bundle="clients" /></label>
							<div class="col-xs-12 col-lg-8">
								<select data-ng-model="logOutputOption.membertype" id="membertype" name="membertype" data-ng-options="item.value as item.label for item in ibmiAdvancedBackup.logOutputOption.membertype"></select>
							</div>
						</div>
						
						<div class="form-group row">
							<label class="margin-top-10-important col-xs-12 col-lg-4" for="outputTypeInfo"><cv:msg key="label.typeOfOutputInfo" bundle="clients" /></label>
							<div class="col-xs-12 col-lg-8">
								<select data-ng-model="logOutputOption.outputTypeInfo" id="outputTypeInfo" name="outputTypeInfo" data-ng-options="item.value as item.label for item in ibmiAdvancedBackup.logOutputOption.outputTypeInfo"></select>
							</div>
						</div>
					</div>					
				</div>
			</uib-accordion>		
			<div class="global-options remove-border-padding padding-top-10"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
		</span>
	</div>
	<div class="button-container">
		<button id="fsBackupOptions_button_#3629" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="fsBackupOptions_button_#8622" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="fsBackupOptions_button_#0180" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>