<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ReportsPlusMessages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 title="{{title}}">{{title}}</h1>
</div>
<div class="setup-content schedule">
    <form name="emailReportForm" novalidate autocomplete="off" id="emailReportForm" data-cv-submit="onEmailReportFormSubmit()" class="schedules-form">
    	<div class="modal-wrapper">
			<label class="label wrap-normal"><cv:msg key="label.format" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<div class="row">
					<div class="col-xs-12">
						<isteven-multi-select
								directive-id="outputFormatSelect"
								input-model="data.outputTypes"
								output-model="model.selectedFormats"
								tick-property="selected"
								button-label="label"
								class="isteven-multi-select"
								item-label="label"
								on-item-click="handleFormatClick(data)"
								helper-elements="filter"
								selection-mode="single">
						</isteven-multi-select>
					</div>
				</div>
			</div>
		</div>
		<!-- // Compress // -->
		<div class="modal-wrapper">
			<label class="label wrap-normal"><cv:msg key="label.compressFile" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<cv-toggle toggle-name="compressToggle" value="model.button.compressFile" is-disabled="emailBodySelected" on-click="model.button.changeState('compressFile',model.button.compressFile)"></cv-toggle>
			</div>
		</div>
		<!-- // Component Selection // -->
		<div class="modal-wrapper" data-ng-if="model.showComponentSelection && model.componentList.length > 1">
			<label class="label wrap-normal"><cv:msg key="label.componentSelection" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<isteven-multi-select 
					input-model="model.componentList"
					output-model="model.selectedComponents"
					button-label="name"
					item-label="name"
					directive-id="componentSelect"
					tick-property="selected" 
					helper-elements="filter" 
					max-labels="2"
					translation="model.componentSelectionTranslation">
				</isteven-multi-select>
			</div>
		</div>

		<!-- // Users to notify // -->
		<div class="modal-wrapper">
			<label for="usersToNotify" class="label wrap-normal"><cv:msg key="label.Email_to_Users" bundle="schedule"/></label>
			<div class="inline-wrapper users-to-notify-container" id="usersToNotifySearchContainer">
				<input type="text" id="field" name="field" placeholder="<cv:msg key="label.Search_Users_Usergroups" bundle="schedule"/>" data-ng-model="model.userSearchText" data-ng-keyup="searchUsersList()">
				<div data-ng-class="{'loading': model.searchInProgress}"></div>
				<div class="clear-search" data-ng-click="clearUsersSearch()" data-ng-if="model.userSearchText && !model.searchInProgress">&times;</div>
				<div class="search-results" data-ng-if="model.usersSearchList">
						<ul class="search-results-list">
							<li class="search-result" data-ng-repeat="userItem in model.usersSearchList track by $index" data-ng-click="addUserToList(userItem)">
								<span class="user-icon " data-ng-class="{'user-type': userItem.type == 1 ,'group-type': userItem.type == 2}"></span><span class="suggestedText vw-text" title="{{userItem.displayName}}"><span class="displayNameContainer">{{userItem.displayName}}</span></span>
							</li>
							<li class="search-result" data-ng-if="model.usersSearchList.length == 0">
								<cv:msg key="label.noResults" bundle="schedule"/>
							</li>
						</ul>
			    </div>
			    <!-- Displaying added users -->
			    <div data-ng-if="model.usersToNotifyList && model.usersToNotifyList.length > 0">
			    	<ul class="users-list">
							<li class="user-item" data-ng-repeat="userItem in model.usersToNotifyList track by $index">
								<span class="user-icon " data-ng-class="{'user-type': userItem.type == 1 ,'group-type': userItem.type == 2}"></span><span class="suggestedText vw-text" title="{{userItem.displayName}}"><span class="displayNameContainer">{{userItem.displayName}}</span></span>
								<div class="remove-user" data-ng-click="removeUserFromList(userItem)">&times;</div>
							</li>
					</ul>
			    </div>
			</div>
		</div>
		<div class="modal-wrapper">
			<label for="emails" class="label wrap-normal"><cv:msg key="label.emailRecipients" bundle="schedule"/></label>
			<div class="inline-wrapper">
				<input type="text" name="emailRecipients" data-ng-model="model.commaSeparatedEmails"
				placeholder='<cv:msg key="placeholder.commaSeparatedEmails" bundle="schedule"/>' data-ng-class="emailListClass()" />
			</div>
		</div>
		<div class="modal-wrapper error">
			{{errorMessage}}
		</div>
		<div class="button-container">
				<button id="emailReport_button_#9133" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
				<button id="emailReport_button_#7520" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Submit" bundle="messages"/></button>
		</div>
    </form>
</div>