<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1>
			<cv:msg key="pageHeader.editAccessNodes" bundle="servers" />
		</h1>
	</div>
	<div class="modal-body">
		<i class="glyphicon glyphicon-info-sign tile-tooltip display-inline no-left-padding"></i>
		<span><cv:msg key="label.selectProxy" bundle="nas" /></span>
	</div>
	<div>
		<span class="error serverMessage" ng-show="showNoProxyError"><cv:msg key="error.proxy" bundle="servers" /></span>
	</div>
	<div class="setup-content">
		<form novalidate cv-submit="save()">
			<div class="form-group" ng-repeat="proxyServer in proxyList" class="margin-bottom-10">
				<input id="{{ proxyServer.clientId }}" type="checkbox" ng-model="proxyServer.selected" name="{{ proxyServer.name }}">
				<label for="{{ proxyServer.clientId }}" ng-bind="proxyServer.clientName"></label>
			</div>
			<div class="button-container">
				<button id="editProxyForClients_button_#9309" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="users" /></button> 
				<button id="editProxyForClients_button_#1992" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="users" /></button> 
			</div>
		</form>
	</div>
</div>