
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<fmt:bundle basename="localization.servers">
	<div class="setup-title">
		<h1>
			{{header}}
		</h1>
	</div>
	<div class="setup-content">
		<%-- <span class="setupInfo"><fmt:message key="label.editInfo" /></span> --%>
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
		<form name="editCloudCredentialsForm" novalidate
			data-cv-submit="editServer()" autocomplete="off">
			<div class="global-options remove-border-padding">
				<!--  For Azure (fields for  RM deployments) -->
				<div data-ng-if="model.vsInstanceType=='AZURE_V2'">
					<label for="subscriptionId">
						<fmt:message key="label.subscriptionId" />
						<input type="text" name="subscriptionId"
							data-ng-model="model.virtualServerInfo.azureResourceManager.subscriptionId"
							required />
						<span class="help-block"
							data-ng-show="cv.editCloudCredentialsForm.needsAttention(editCloudCredentialsForm.subscriptionId)">
							<fmt:message key="error.subscriptionId" />
						</span>
					</label>
					<label for="tenantId">
						<fmt:message key="label.tenantId" />
						<input type="text" name="tenantId"
							data-ng-model="model.virtualServerInfo.azureResourceManager.tenantId"
							required />
						<span class="help-block"
							data-ng-show="cv.editCloudCredentialsForm.needsAttention(editCloudCredentialsForm.tenantId)">
							<fmt:message key="error.tenantId" />
						</span>
					</label>
					<label for="applicationId">
						<fmt:message key="label.applicationId" />
						<input type="text" name="applicationId"
							data-ng-model="model.virtualServerInfo.azureResourceManager.credentials.userName"
							required />
						<span class="help-block"
							data-ng-show="cv.editCloudCredentialsForm.needsAttention(editCloudCredentialsForm.applicationId)">
							<fmt:message key="error.applicationId" />
						</span>
					</label>
					<!--  End Azure Rm -->
				</div>
				<!-- Field for Azure Classic -->
				<label for="subscriptionId"
					data-ng-if="model.vsInstanceType=='AZURE'">
					<fmt:message key="label.subscriptionId" />
					<input type="text" name="subscriptionId"
						data-ng-model="model.virtualServerInfo.azure.credentials.userName"
						required />
					<span class="help-block"
						data-ng-show="cv.editCloudCredentialsForm.needsAttention(editCloudCredentialsForm.subscriptionId)">
						<fmt:message key="error.subscriptionId" />
					</span>
				</label>
				<!-- End Azure Classic -->
				<!-- Field for Amazon -->
				<label for="cloudAccessKey"
					data-ng-if="model.vsInstanceType=='AMAZON'">
					<fmt:message key="label.accessKey" />
					<input type="text" name="cloudAccessKey"
						data-ng-model="model.virtualServerInfo.amazonInstanceInfo.accessKey"
						required />
					<span class="help-block"
						data-ng-show="cv.editCloudCredentialsForm.needsAttention(editCloudCredentialsForm.cloudAccessKey) || showError">
						<fmt:message key="error.accessKey" />
					</span>
				</label>
				<!-- End Amazon -->
				<label for="cloudPassword">
					<span>{{cloudPasswordText}}</span>
					<input type="password" name="cloudPassword"
						data-ng-model="model.cloudPassword" required
						placeholder="<cv:msg key="label.leaveAzureSecretKeyBlank" bundle="exchange"></cv:msg>"
						autoCompleteType="disable" autocomplete="off" />
					<span class="help-block"
						data-ng-show="cv.editCloudCredentialsForm.needsAttention(editServerForm.cloudPassword) || showError">
						<span>{{cloudPasswordTextError}}</span>
					</span>
				</label>
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
						<button id="editCloudCredentials_button_#4741" type="button" class="btn btn-default" 
							data-ng-click="cancel()">
							<fmt:message key="Cancel" />
						</button>
						<button id="editCloudCredentials_button_#6471" type="submit" class="btn btn-primary"> 
							<fmt:message key="Save" />
						</button>
					</fmt:bundle>
				</div>
		</form>
	</div>
</fmt:bundle>