<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editAdvancedSettings" bundle="clients" /></h1>
</div>
<div class="bootstrap-wrapper form-horizontal">
	<form name="editAdvancedClientGroupProperties" data-cv-submit="saveAdvancedProperties()" novalidate autocomplete="off">
		<div class="modal-body">
			<div class="form-group">
				<div class="col-xs-12 serverMessage {{uiModel.serverMessage.type}}">{{uiModel.serverMessage.message}}</div>
			</div>
			<div class="form-group">
				<div class="col-sm-5">
					<label for="copyRedundancy"><cv:msg key="label.sla" bundle="clients"/></label>
				</div>
				
				<div class="col-sm-7">
					<input type="radio" id="commcellLevelSettings" name="commcellLevelSettings" data-ng-value="uiModel.slaOptions.USE_COMMCELL_LEVEL_SETTINGS" data-ng-model="uiModel.slaSelection">
					<label for="commcellLevelSettings"><cv:msg key="label.commcellLevelSettings" bundle="clients" /></label>
				</div>
				
				<div class="col-sm-offset-5 col-sm-7">
					<input type="radio" id="slaForTimeInterval" name="slaForTimeInterval" data-ng-value="uiModel.slaOptions.USE_SLA_FOR_TIME_INTERVAL" 
						data-ng-model="uiModel.slaSelection" data-ng-change="updateTimeInterval()">
					<label for="slaForTimeInterval"><cv:msg key="label.slaForTimeInterval" bundle="clients" params="{{advancedProperties.slaInterval}}"/></label>
					<select id="slaInterval" name="slaInterval"
							data-ng-model="uiModel.slaTimeInterval" 
							data-ng-disabled="uiModel.slaSelection != uiModel.slaOptions.USE_SLA_FOR_TIME_INTERVAL" 
							data-ng-required="uiModel.slaSelection == uiModel.slaOptions.USE_SLA_FOR_TIME_INTERVAL"
							data-ng-options="interval for interval in uiModel.slaTimeIntervalOptions"
							style="width:70px;margin-left:5px;margin-right:5px;"></select><!-- TODO: INLINE STYLE NEED TO BE REMOVED -->
					<label for="slaInterval"><cv:msg key="label.day" bundle="settings"/></label>
				</div>
				
				<div class="col-sm-offset-5 col-sm-7">
					<input type="radio" id="excludeFromSLA" name="excludeFromSLA" data-ng-value="uiModel.slaOptions.EXCLUDE_FROM_SLA" data-ng-model="uiModel.slaSelection">
					<label for="excludeFromSLA"><cv:msg key="label.excludeFromSLA" bundle="clients" /></label>
				</div>
			</div>
		
			<div class="form-group">
				<div class="col-sm-5">
					<label for="copyRedundancy"><cv:msg key="label.copyRedundancy" bundle="clients"/></label>
				</div>
				<div class="col-sm-7">
					<input type="number" id="copyRedundancy" name="copyRedundancy" min="0" max="50" required
							data-ng-model="uiModel.clientGroupInfo.slaCopyRedundancy">
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.copyRedundancy)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,50"/></span>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-5">
					<label for="auxCopyFallenBehind"><cv:msg key="label.auxCopyFallenBehind" bundle="clients"/></label>
				</div>
				<div class="col-sm-7">
					<input type="number" id="auxCopyFallenBehind" name="auxCopyFallenBehind" min="0" max="100" required
							data-ng-model="uiModel.clientGroupInfo.slaCopyFallenBehindDays">
					<label for="auxCopyFallenBehind"><cv:msg key="label.day" bundle="settings"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.auxCopyFallenBehind)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,100"/></span>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-5">
					<label for="recoveryPointObjectiveDays"><cv:msg key="label.recoveryPointObjective" bundle="clients"/></label>
				</div>
				<div class="col-sm-7">
					<input type="number" id="recoveryPointObjectiveDays" name="recoveryPointObjectiveDays" min="0" max="30" value="2" 
							data-ng-model="uiModel.rpo.days" required>
					<label for="recoveryPointObjectiveDays"><cv:msg key="label.day" bundle="settings"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.recoveryPointObjectiveDays)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,30"/></span>
				</div>
				<div class="col-sm-5">&nbsp;</div>
				<div class="col-sm-7">
					<input type="number" id="recoveryPointObjectiveHours" name="recoveryPointObjectiveHours" min="0" max="23" value="4" 
							data-ng-model="uiModel.rpo.hours" required>
					<label for="recoveryPointObjectiveHours"><cv:msg key="label.hours" bundle="exchange"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.recoveryPointObjectiveHours)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,23"/></span>
				</div>
				<div class="col-sm-5">&nbsp;</div>
				<div class="col-sm-7">
					<input type="number" id="recoveryPointObjectiveMinutes" name="recoveryPointObjectiveMinutes" min="0" max="59" value="12"
							data-ng-model="uiModel.rpo.minutes" required>
					<label for="recoveryPointObjectiveMinutes"><cv:msg key="label.minute" bundle="settings"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.recoveryPointObjectiveMinutes)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,59"/></span>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-5">
					<label for="recoveryTimeObjectiveDays"><cv:msg key="label.recoveryTimeObjective" bundle="clients"/></label>
				</div>
				<div class="col-sm-7">
					<input type="number" id="recoveryTimeObjectiveDays" name="recoveryTimeObjectiveDays" min="0" max="30" value="2" 
							data-ng-model="uiModel.rto.days" required>
					<label for="recoveryTimeObjectiveDays"><cv:msg key="label.day" bundle="settings"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.recoveryTimeObjectiveDays)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,30"/></span>					
				</div>
				<div class="col-sm-5">&nbsp;</div>
				<div class="col-sm-7">
					<input type="number" id="recoveryTimeObjectiveHours" name="recoveryTimeObjectiveHours" min="0" max="23" value="4"
							data-ng-model="uiModel.rto.hours" required>
					<label for="recoveryTimeObjectiveHours"><cv:msg key="label.hours" bundle="exchange"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.recoveryTimeObjectiveHours)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,23"/></span>
				</div>
				<div class="col-sm-5">&nbsp;</div>
				<div class="col-sm-7">
					<input type="number" id="recoveryTimeObjectiveMinutes" name="recoveryTimeObjectiveMinutes" min="0" max="59" value="12"
							data-ng-model="uiModel.rto.minutes" required>
					<label for="recoveryTimeObjectiveMinutes"><cv:msg key="label.minute" bundle="settings"/></label>
					<span class="help-block" data-ng-show="cv.editAdvancedClientGroupProperties.needsAttention(editAdvancedClientGroupProperties.recoveryTimeObjectiveMinutes)">
							<cv:msg key="error.pleaseEnterValueBetweenRange" bundle="clients" params="0,59"/></span>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="editAdvancedClientgroupProperties_button_#2279" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="dismiss()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="editAdvancedClientgroupProperties_button_#2406" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
		</div>
	</form>
</div>
