<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
</script>
<div>
	<div class='modal-header'>
        <h5 data-ng-bind="editAddStgCtrl.confirmationTitle"></h5>
	</div>
	<div class="modal-body">
		<form novalidate data-ng-init="editAddStgCtrl.init()" data-cv-submit="editAddStgCtrl.submit()" autocomplete="off" class="generate-package-form">
			<p ng-if="isRestartRequired" class="cv-deactivate-confirm-message restart-warn"> <cv:msg key='label.restartRequiredToApply' bundle='settings'></cv:msg> </p>
			<div class="row">
				<div class="col-sm-3">
					<div style='margin-top:10px'>
						<cv:msg key="label.nav.value" bundle='navJs'></cv:msg>
					</div>
				</div>
				<div class='col-sm-9'>
					<input data-ng-if="settingType == 'STRING'" type="text" ng-model="editAddStgCtrl.value" class="form-control additional-settings-input" uib-tooltip="<cv:msg key='label.enterAdditionalSettingValue' bundle='settings' />" tooltip-placement="top" placeholder="<cv:msg key='label.enterText' bundle='settings' />" ng-change="validateSetting()"/>
					<input data-ng-if="settingType == 'INTEGER'" type="number" ng-model="editAddStgCtrl.value" class="form-control additional-settings-input" uib-tooltip="<cv:msg key='label.enterAdditionalSettingValue' bundle='settings' />" tooltip-placement="top" placeholder="<cv:msg key='label.enterNumber' bundle='settings' />" ng-change="validateSetting()"/>
					
					<div class="uib-dropdown entity-boolean-value-selection" data-uib-dropdown data-ng-if="settingType == 'BOOLEAN'">
						<a class="uib-dropdown-toggle dropdown-toggle no-user-select" data-uib-dropdown-toggle>
							<span ng-bind="editAddStgCtrl.getBoolString()"></span>
							<span class="k-icon k-i-arrow-60-down k-menu-expand-arrow"></span>
						</a>
						<ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 margin-top-0">
							<li class='additionalSettingOption' data-ng-click="selectBoolean(boolValues.trueValue)"><cv:msg key='label.true' bundle='settings' /></li>
							<li class='additionalSettingOption' data-ng-click="selectBoolean(boolValues.falseValue)"><cv:msg key='label.false' bundle='settings' /></li>
						</ul>
					</div>
				</div>
			</div>
			<br><br>
			<div class="modal-footer">
				<button id="deactivateSubscriptionWindow_button_#7775" type='button' class='btn btn-default cvBusyOnAjax' 
					data-ng-click='editAddStgCtrl.cancel()'>
					<cv:msg key="action.cancel" bundle='settings'></cv:msg>
				</button>
				<button id="deactivateSubscriptionWindow_button_#2428" type='submit' data-ng-disabled="!formValid" 
					class='btn btn-primary cvBusyOnAjax'>
					<cv:msg key="action.apply" bundle='settings'></cv:msg>
				</button>
			</div>
		</form>
	</div>
</div>