<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="search-directive-container">
	<script nonce="${sessionScope.cspNonce}" >
	    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	</script>
	<div class="overlay-search" ng-click="ctrl.closeResultPanel()" ng-if="ctrl.isSearchDirty"></div>
	<div class="multi-select-search" ng-if="ctrl.resultArr != null">
		<span class="multi-select-search-selected" ng-repeat="item in ctrl.resultArr"><span class="k-icon primary-icon" ng-class="item.iconClass"></span> {{item.loginName}}<span class="multi-select-search-deselect" ng-click="ctrl.remove(item)">x</span></span>
	</div>
	<div class="search-input-container search-text-animate" ng-class="{'search-input-focus' : ctrl.isSearchDirty}">
		<div class="search-status">
			<i ng-if="ctrl.isSearchIdle()" class="k-icon k-i-search"></i>
			<img ng-if="ctrl.isWaitingForResponse" src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
			<div ng-if="ctrl.outputModel != null && !ctrl.multiSelectionEnabled && !ctrl.searchOptions.enableSVGIcons" class="k-icon primary-icon" ng-class="ctrl.outputModel.iconClass"></div>
			<div ng-if="ctrl.outputModel != null && !ctrl.multiSelectionEnabled && ctrl.searchOptions.enableSVGIcons" class="k-icon primary-icon" ng-bind-html="ctrl.outputModel.iconClass"></div>
		</div>
		<input autocomplete="off" class="search-text" type="text" name="searchComponent" ng-model="ctrl.searchTerm"  ng-change="ctrl.onKeyboardInputChanged()" placeholder="{{ctrl.searchOptions.placeholder | cvLoc}}" ng-focus="ctrl.applyFocus()" ng-click="ctrl.onKeyboardInputChanged()"/>
		<div class="k-icon clear-search-text" ng-click="ctrl.clearSearchText()" ng-class="{ 'icon-invisible' : ctrl.isSearchboxEmpty() }"><span class="k-i-x"></span></div>
	</div>
	<ul class="results-container search-text-animate" ng-show="ctrl.isResultPanelVisible">
		<div>
			<div class="result-item-container" ng-repeat="item in ctrl.resultsList track by $index">
				<div class="result-item" ng-click="ctrl.onResultSelected(item)">
					<span ng-if="!ctrl.searchOptions.enableSVGIcons" class="k-icon primary-icon" ng-class="item.iconClass"></span>
					<span ng-if="ctrl.searchOptions.enableSVGIcons" class="k-icon primary-icon" ng-bind-html="item.iconClass"></span>
					<h5 class="margin-0 margin-left-5" ng-bind="item.loginName"></h5>
				</div>
			</div>
			<div class="show-more-container">
				<a data-ng-if="ctrl.showLoadMore" data-ng-click="ctrl.loadMoreItems()" ><cv:msg key="label.More" bundle="messagesJs" /></a>
			</div>
		</div>
		<div ng-if="ctrl.showEmptyResultMessage" class="no-result">
			<span><cv:msg key="label.noResultsFound" bundle="messagesJs" /></span>
		</div>
	</ul>
</div>