<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1 data-ng-if = "passkeyCtrl.mode === 'validate'"> <cv:msg key="label.validate" bundle="profiles"/></h1>
	<h1 data-ng-if = "passkeyCtrl.mode === 'createPasskey'"> <cv:msg key="label.createPasskeyTitle" bundle="profiles"/></h1>
</div>
<div class="setup-content remove-top-padding smaller-inputs">
	<div class="alert alert-sign-detail text-center">
	    <div class="row">
	        <div class="col-xs-12">
	            <span class="alert-detail-icon k-icon k-i-warning"></span> <span data-ng-bind="passkeyCtrl.passkeyWarningMessage"></span>
	        </div>
	    </div>	
	</div>
	<p class="serverMessage {{passkeyCtrl.serverMessage.type}}" data-ng-bind="passkeyCtrl.serverMessage.message"></p>
	<form name="editPasskeyForm" data-ng-init="passkeyCtrl.init()" data-cv-submit="passkeyCtrl.updatePrivacy()" autocomplete="off">
		<div class="global-options remove-border-padding">
			<label for="loginPassword" data-ng-if="passkeyCtrl.mode === 'validate'">
				<cv:msg key="label.currentLoggedInUserPassword" bundle="users"/>
				<input placeholder="<cv:msg key="placeholder.currentLoggedInUser" bundle="users"/> (${loginContext.userEntity.userName})" class="margin-right-20" type="password" name="loginPassword" id="loginPassword" data-ng-model="passkeyCtrl.userInfo.password" required>
			</label>
			<div data-ng-if="passkeyCtrl.mode === 'validate'" class="text-left margin-left-20">
				<cv-toggle-accordion click-header = "passkeyCtrl.togglePasskeyOption(data)" accordion-label="label.usePasskeyToggle" help-text="passkeyCtrl.togglePasskeyHelpText" collapsed="passkeyCtrl.togglePasskey">
					 <label for="passkey" >
	 	 				<cv:msg key="label.passkey" bundle="profiles" />
						<input class="margin-right-20" type="password" name="passkey" id="passkey" data-ng-model="passkeyCtrl.userInfo.currentPasskeyString">
					</label>
					 <label for="confirmPasskey"><cv:msg key="label.confirmPasskey" bundle="profiles"/>
						<input class="margin-right-20" type="password" name="confirmPasskey" id="confirmPasskey" data-ng-model="passkeyCtrl.confirmPasskeyString">
						<span class="help-block" data-ng-if="passkeyCtrl.confirmPasskeyString !== passkeyCtrl.userInfo.currentPasskeyString"><cv:msg key='error.passwordsDoNotMatch' bundle='profiles' /></span>				
					</label>
				</cv-toggle-accordion>
			</div>
			<div data-ng-if="passkeyCtrl.mode === 'createPasskey'">
				 <label for="passkey" >
	 				<cv:msg key="label.passkey" bundle="profiles" />
					<input class="margin-right-20" type="password" name="passkey" id="passkey" data-ng-model="passkeyCtrl.userInfo.currentPasskeyString">
				</label>
				 <label for="confirmPasskey"><cv:msg key="label.confirmPasskey" bundle="profiles"/>
					<input class="margin-right-20" type="password" name="confirmPasskey" id="confirmPasskey" data-ng-model="passkeyCtrl.confirmPasskeyString">
					<span class="help-block" data-ng-if="passkeyCtrl.confirmPasskeyString !== passkeyCtrl.userInfo.currentPasskeyString"><cv:msg key='error.passwordsDoNotMatch' bundle='profiles' /></span>				
				</label>
			</div>
		</div>
		<div class="button-container">
	  		<button id="cvCreatePasskey_button_#6703" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="passkeyCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
	  		<button id="cvCreatePasskey_button_#3868" type="submit" data-ng-disabled="!passkeyCtrl.userInfo.currentPasskeyString || !passkeyCtrl.confirmPasskeyString || passkeyCtrl.confirmPasskeyString !== passkeyCtrl.userInfo.currentPasskeyString" data-ng-if="passkeyCtrl.mode === 'createPasskey' || (passkeyCtrl.mode === 'validate' && passkeyCtrl.togglePasskey)" class="btn btn-primary cvBusyOnAjax" data-ng-click="passkeyCtrl.submit()"><cv:msg key="action.submit" bundle="users"/></button> 
	  		<button id="cvCreatePasskey_button_#9866" type="submit" data-ng-disabled="!passkeyCtrl.userInfo.password" data-ng-if="passkeyCtrl.mode === 'validate' && !passkeyCtrl.togglePasskey" class="btn btn-primary cvBusyOnAjax" data-ng-click="passkeyCtrl.submit()"><cv:msg key="action.validate" bundle="profiles"/></button> 
		</div>
	</form>
</div>