<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<div class="setup-title"><h1><cv:msg key="action.subclientCreation" bundle="clients" /></h1></div>
<div class="setup-content" >
	<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<section>
		<form name="createSubclientForm" novalidate autocomplete="off" data-cv-submit="createSubclient()" >
	
		<ul class="nav nav-tabs">
			<li data-ng-class="{active:isSelected(0)}"><a href="" data-ng-click="tab = 0"><cv:msg key="heading.clientGeneral" bundle="clients" /></a></li>
			<li data-ng-class="{active:isSelected(1)}"><a href="" data-ng-click="tab = 1"><cv:msg key="header.content" bundle="collections" /></a></li>
			<li data-ng-class="{active:isSelected(2)}"><a href="" data-ng-click="tab = 2"><cv:msg key="heading.clientActivityControl" bundle="clients" /></a></li>
		</ul>
		
		<div data-ng-if="tab==0" id="subclient-general-tab">
			<%-- <label><cv:msg key="label.clientName" bundle="clients" /><span class="clientName" data-ng-bind="subclientInfo.clientName"></span></label>
			<label><cv:msg key="label.iDataAgent" bundle="clients" /><span class="ida" data-ng-bind="subclientInfo.iDataAgent"></span></label>
			<label data-ng-show="subclientInfo.agentInfo.agentType.backupsetSupported"><cv:msg key="Backup Set" bundle="job" /><span class="backupsetName" data-ng-bind="subclientInfo.backupsetName"></span></label> --%>
			
			<label for="subclientName" ><cv:msg key="label.SubclientName" bundle="clients" />
				<input type="text" name="subclientName" data-ng-class="text-right" id="subclientName" data-ng-model="subclientInfo.subclientName" data-ng-keyup="validateSubclientName()" required autofocus >
				<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.subclientName) || showSubclientNameAlert">
					<cv:msg key="error.subclientName" bundle="clients" />
				</span>
				<span class="help-block" data-ng-show="checkForDuplicateNames()">
					<cv:msg key="error.duplicateSubclientName" bundle="clients"/>
				</span>
			</label>
			
			<div data-ng-switch on="subclientInfo.agentInfo.applicationId">
				<div data-ng-switch-when = "33"> 
					<label for="storagePolicy" class="select-label"><cv:msg key="header.storagePolicy" bundle="clients" />
						<select id="storagePolicy" name="storagePolicy"  data-ng-required="true" data-ng-model="subclientInfo.storagePolicy" data-ng-options="sp as sp.storagePolicyName for sp in subclientInfo.storagePoliciesList">
							<option value=""><cv:msg key="label.selectStoragePolicy" bundle="clients"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.storagePolicy)">
							<cv:msg key="error.selectStoragePolicy" bundle="clients" />
						</span>
					</label>
				</div>
				<div data-ng-switch-when = "81"> 
					<label for="dataStoragePolicy" class="select-label"><cv:msg key="header.dataStoragePolicy" bundle="clients" />
						<select id="dataStoragePolicy" name="dataStoragePolicy"  data-ng-required="true" data-ng-model="subclientInfo.storagePolicy" data-ng-options="sp as sp.storagePolicyName for sp in subclientInfo.storagePoliciesList">
							<option value=""><cv:msg key="label.selectDataStoragePolicy" bundle="clients"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.dataStoragePolicy)">
							<cv:msg key="error.selectDataStoragePolicy" bundle="clients" />
						</span>
					</label>
					<label for="logStoragePolicy" class="select-label"><cv:msg key="header.logStoragePolicy" bundle="clients" />
						<select id="logStoragePolicy" name="logStoragePolicy"  data-ng-required="true" data-ng-model="subclientInfo.logStoragePolicy" data-ng-options="sp as sp.storagePolicyName for sp in subclientInfo.storagePoliciesList">
							<option value=""><cv:msg key="label.selectLogStoragePolicy" bundle="clients"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.createSubclientForm.needsAttention(createSubclientForm.logStoragePolicy)">
							<cv:msg key="error.selectLogStoragePolicy" bundle="clients" />
						</span>
					</label>
				</div>
			</div>
			
			
			<label for="subclientDescription"><cv:msg key="Description" bundle="events" />
				<textarea  id="subclientDescription" class="resize-none" rows="4" cols="40" data-ng-model="subclientInfo.description"></textarea>
			</label>
			<br>
		</div>
	
		<div data-ng-if="tab ==1" id="subclient-content-tab">
			<div data-ng-switch on="subclientInfo.agentInfo.applicationId">
				<div data-ng-switch-when="33"> <!--FS: This div shows only the content of path type.includePath and excludePath type content wont be showed here. -->
					<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in subclientInfo.content.contentEntities" data-ng-if="contentEntity.type==0" >
						<li data-ng-bind="contentEntity.path"></li>
					</ul>
					<br>
					<ul class="manageCollectionList list-style__row group" data-ng-if="subclientInfo.content.typeWiseCounterArray[0].counter==0">
						<li><cv:msg key="label.NoContentAdded" bundle="clients" /></li>
					</ul>
				</div>
				<div data-ng-switch-when="81">
					<ul class="manageCollectionList list-style__row group" data-ng-repeat="contentEntity in subclientInfo.content">
						<li data-ng-bind="contentEntity.databaseName"></li>
					</ul>
					<br>
					<ul class="manageCollectionList list-style__row group" data-ng-if="subclientInfo.content.length ==0">
						<li><cv:msg key="label.NoContentAdded" bundle="clients" /></li>
					</ul>
				</div>				
			</div>
			<br>
			<div>
				<button id="createSubclient_button_#3966" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="addContent()"><cv:msg key="label.AddOrEditContent" bundle="fs" /></button> 
			</div>
		</div>
		<div data-ng-if="tab==2" id="subclient-activity-tab">
			<br>
			<input type="checkbox" id="activityControl" name="activityControl" data-ng-model="subclientInfo.enableBackup"/>	
			<label for="activityControl"><cv:msg key="label.enableBackup" bundle="clients" /></label> 
		</div>	
		<br>
		
		<div class="button-container" >
			<button id="createSubclient_button_#0593" type="button" class="btn btn-default setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="createSubclient_button_#8213" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Add" bundle="messages" /></button> 
		</div>
		
		</form>
	</section>
</div>