<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-hide="editDialog"><cv:msg key="pageHeader.createServer" bundle="oracle"/> </h1>
	<h1 data-ng-show="editDialog"><cv:msg key="pageHeader.editServer" bundle="oracle"/> </h1>
</div>
<div class="setup-content">
	
	<form name="Oracleinstance" novalidate data-cv-submit="createInstance()" autocomplete="off" class="add-collection-form">
	 	<div class="form-panel-holder">
			<label> 
				<span class="page-detail-column"> 
					<label for="instanceName">
						<span>
							<cv:msg key="label.instanceName" bundle="clients"/>
						</span>	
					</label>	
				</span> 
				<span class="page-detail-column float-right"> 
					<input type="text" id="instanceName" name="instanceName"  
						data-ng-model="instanceEntity.instanceName" required/>
				</span> 
				<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.instanceName);" >
					<cv:msg key="error.instanceName" bundle="sqlserver"/>
				</span>
				<span class="help-block" data-ng-show="checkDuplicateName(instInfo.instanceName)"> 
					<cv:msg key="error.duplicateInstanceName" bundle="sqlserver"/> 
				</span>
			</label>
			
			<!--Oracle Home. -->
			<label> 
				<span class="page-detail-column"> 
					<label for="oracleHome">
						<cv:msg key="label.oracleHome" bundle="oracle"/>
					</label>	
				</span> 
				<span class="page-detail-column browse-input-holder float-right"> 
					<input type="text" id="oracleHome" name="oracleHome" 
										data-ng-model="instInfo.oracleHome" required /><button id="createOracleInstance_button_#1232" type="button"  
										class="btn btn-default setup-btn--hidden float-right" 
										data-ng-click="browse()"><cv:msg key="label.browse" bundle="restore"/></button>
				</span> 
				<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.oracleHome);" >
					<cv:msg key="error.oracleHome" bundle="oracle"/>
				</span>
			</label>
			
			<!--Oracle OS User. -->
			<label> 
				<span class="page-detail-column"> 
					<label for="osUserName">
						<cv:msg key="label.osUserName" bundle="oracle"/>
					</label>
				</span> 
				<span class="page-detail-column float-right"> 
					<input type="text" id="osUserName" name="osUserName" 
						data-ng-model="instInfo.osUserName" required/>
				</span> 
				<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.osUserName);" >
					<cv:msg key="error.osUserName" bundle="oracle"/>
				</span>
			</label>
			
			<label data-ng-hide="isUnixClient"> 
				<span class="page-detail-column"> 
					<label for="osUserPassword">
						<cv:msg key="label.osPassword" bundle="oracle"/>
					</label>	
				</span> 
				<span class="page-detail-column float-right"> 
					<input type="password" id="osUserPassword" name="osUserPassword" 
						data-ng-model="instInfo.osUserPassword"/>
				</span> 
				<%-- <span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.osUserPassword);" >
					<cv:msg key="error.osUserPassword" bundle="oracle"/>
				</span> --%>
			</label>
			<!--Connection String. -->
			<label>
				<cv:msg key="label.ConnectionString" bundle="oracle" /> 
			</label>	
			<label> 
				<div class="connection-string"> 
					<input id="dbUserName" name="dbUserName" type="text" placeholder="User Name" data-ng-model="instInfo.sqlConnect.userName" >
					<label for="dbUserName"> / </label>
					<input id="dbPassword" name="dbPassword" type="password" placeholder='<cv:msg key="label.osPassword" bundle="oracle"/>' data-ng-model="instInfo.password" >
					<label for="dbPassword"> @ </label>
					<input id="dbInstanceName" name="dbInstanceName" type="text" placeholder="SID" data-ng-model="instInfo.sqlConnect.domainName" >
				</div>
				<%-- <span class="help-block ng-hide" data-ng-show="validateConnectString(Oracleinstance.dbUserName,Oracleinstance.dbPassword,Oracleinstance.dbInstanceName)">
					<cv:msg key="error.connectString" bundle="oracle"/>
				</span> --%> 
			</label>
			
			<label>
				<span class=page-detail-column>
					<label for="DBStoragePolicy">
						<cv:msg key="header.dataStoragePolicy" bundle="oracle"/>
					</label>		
				</span>	
				<span class="page-detail-column select-label float-right">
					<select name="DBStoragePolicy" id="DBStoragePolicy" 
						data-ng-options="sp.storagePolicyId as sp.storagePolicyName for sp in instInfo.availableStoragePolicies | orderBy:'storagePolicyName'" 
						data-ng-model="storageDev.commandLineStoragePolicy.storagePolicyId" required class="input">
						<option value=""><cv:msg key="label.selectDataStoragePolicy" bundle="oracle"/></option>
					</select>
				</span>	
				<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.DBStoragePolicy)">
					<cv:msg key="error.selectDataStoragePolicy" bundle="oracle"/>
				</span>
			</label>
			
			<label>
				<span class=page-detail-column>
					<label for="LogStoragePolicy">
						<cv:msg key="header.logStoragePolicy" bundle="clients"/>	
					</label>	
				</span>	
				<span class="page-detail-column select-label float-right">
						<select name="LogStoragePolicy" id="LogStoragePolicy" 
							data-ng-options="sp.storagePolicyId as sp.storagePolicyName for sp in instInfo.availableStoragePolicies | orderBy:'storagePolicyName'" 
							data-ng-model="storageDev.logBackupStoragePolicy.storagePolicyId" required class="input">							
								<option value=""><cv:msg key="label.selectLogStoragePolicy" bundle="clients"/></option>
						</select>
				</span>	
				<span class="help-block" data-ng-show="cv.Oracleinstance.needsAttention(Oracleinstance.LogStoragePolicy)">
					<cv:msg key="error.selectLogStoragePolicy" bundle="clients"/>
				</span>
			</label>
		</div>
	
		<div class="button-container">
	  		<button id="createOracleInstance_button_#1245" type="button" class="btn btn-default setup-btn--hidden"  
	  			data-ng-click="closeDialogBox()"><cv:msg key="Cancel" bundle="messages"/></button>
	  		<button id="createOracleInstance_button_#6557" type="submit" class="btn btn-primary" > <cv:msg key="Save" bundle="messages"/> 
	  		</button>
		</div>
	</form>
</div>
				