<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="heading.CreateBackupset" bundle="clients" /></h1>
</div>
<div class="bootstrap-wrapper form-horizontal modal-margin margin-top-20">
	<form id="editPlanForm" name="NewBackupSetForm" data-cv-submit="submitNewBackupSetModal()" novalidate>
		<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="backupSetName"><cv:msg key="label.backupSetName" bundle="clients" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="text" id="backupSetName" name="backupSetName" data-ng-model="backupsetInfo.backupSetName" data-ng-change="serverMessage.message=''" required />
				<span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.backupSetName);" ><cv:msg key="error.BackupsetName" bundle="clients" /></span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="plan"><cv:msg key="label.profile" bundle="profiles" /><span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<cv-plan-summary-dropdown
					input-model="planList"
					output-model="selectedPlanList"
					item-label="'planName'"
					button-label="'planName'"
					tick-property="'selected'"
					max-labels="1"
					translation="localLang"
					group-property="'msGroup'"
					selection-mode="'single'"
					directive-id="'plans'"
					on-item-clicked="selectPlan(selectedPlanList[0])">
				</cv-plan-summary-dropdown>
			</div>
			<span class="help-block" data-ng-show="inputAlertFlags.plan"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
		</div>
		<div class="form-group">
					<div class="col-xs-12"><input type="checkbox"
													id="makeDefault"
													name="makeDefault"
													data-ng-model="backupsetInfo.isDefaultBackupSet" /><label for="makeDefault"> <cv:msg key="label.makeDefaultBackupset" bundle="clients" /></label></div>
		</div>
	 	<div class="button-container">
	  		<button id="createFsBackupset_button_#6967" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancelNewBackupSetModal()"><cv:msg key="Cancel" bundle="messages" /></button> 
    		<button id="createFsBackupset_button_#5184" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages" /></button> 
		</div>
	</form>
</div>