<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.network"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sqlServerInstance"></cv:cvMessages>
		<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
		<cv:cvEnum name="ExchangeVirtualAgent.CheckName"></cv:cvEnum>
	</script>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left"><cv:msg key="label.readinessCheck" bundle="messagesJs"/></h1>
		<span data-ng-disabled="isDataLoading"><a class="page-action-item" href="" data-ng-click="checkReadiness()"><cv:msg key="label.readinessCheck" bundle="messagesJs" /></a></span>
		<span data-ng-if="!showDetailsScreen" data-ng-disabled="isDataLoading || serverMessage.message!=''"><a class="page-action-item" href="" data-ng-click="showDetails()"><cv:msg key="label.showDetails" bundle="messagesJs" /></a></span>
		<span data-ng-if="showDetailsScreen" data-ng-disabled="isDataLoading || serverMessage.message!=''"><a class="page-action-item" href="" data-ng-click="hideDetails()"><cv:msg key="label.hideDetails" bundle="messagesJs" /></a></span>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	</div>
</div>
<div class="row">
	<div class="col-md-12 col-sm-12">
		<h5 class="title-header-underline"><cv:msg key="label.checkReadinessOn" bundle="messagesJs"/>:</h5>
	</div>
	<div class="col-md-12 col-sm-12">
			<input data-ng-disabled="isDataLoading" class="multiple-checkbox-group auto-width-checkbox padding-left" id="network" type="checkbox" data-ng-model="readinessCheckReq.networkOption" >
			<label for="network" style="clear:both">
					<cv:msg key="label.readinessNetwork" bundle="messagesJs"/>
			</label>
	</div>
	<div class="col-md-12 col-sm-12">
			<input data-ng-disabled="isDataLoading" class="multiple-checkbox-group auto-width-checkbox padding-left" id="resourceCapacity" type="checkbox" data-ng-model="readinessCheckReq.resourceCapacityOption" >
			<label for="resourceCapacity" style="clear:both">
					<cv:msg key="label.readinessResourceCapacity" bundle="messagesJs"/>
			</label>
	</div>
	<div class="col-md-12 col-sm-12">
			<input data-ng-disabled="isDataLoading" class="multiple-checkbox-group auto-width-checkbox padding-left" id="includeDisabledEntities" type="checkbox" data-ng-model="readinessCheckReq.IncludeDisabledClients" >
			<label for="includeDisabledEntities" style="clear:both">
					<cv:msg key="label.readinessIncludeDisabledEntities" bundle="messagesJs"/>
			</label>
	</div>
	<div class="col-md-12 col-sm-12">
			<input data-ng-disabled="isDataLoading" class="multiple-checkbox-group auto-width-checkbox padding-left" id="applicationCheck" type="checkbox" data-ng-model="readinessCheckReq.applicationCheck" >
			<label for="applicationCheck" style="clear:both">
					<cv:msg key="label.applicationCheck" bundle="messagesJs"/>
			</label>
	</div>
	<div class="col-md-12 col-sm-12">
			<input data-ng-disabled="isDataLoading" class="multiple-checkbox-group auto-width-checkbox padding-left" id="additionalResources" type="checkbox" data-ng-model="readinessCheckReq.additionalResources" >
			<label for="additionalResources" style="clear:both">
					<cv:msg key="label.additionalResources" bundle="messagesJs"/>
			</label>
	</div>
</div>
	<div data-ng-if="!isDataLoading && serverMessage.message==''" >
		<div class="summary" data-ng-if="!showDetailsScreen">
			<div>
				<h3 class="text-left"><cv:msg key="label.clientConnectivityFor" bundle="messagesJs" params="{{clientName}}"/></h3>
			</div>
			<div class="resultCheckReadiness">
				<table class="summaryTable checkReadinessTable">
					<thead>
						<tr class="heading">
							<th data-ng-bind-html="'<cv:msg key="label.column.role" bundle="job"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="Status" bundle="job"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job"/>'"></th>
						</tr>
					</thead>
					<tbody>
						<tr data-ng-repeat="item in serverReply.summary" ng-class="{negative : item.entityStatus!=0, positive : item.entityStatus==0}">
							<td data-ng-bind-html="item.entity.entityName"></td>
							<td data-ng-bind-html="item.status"></td>
							<td class="negativeColoring" data-ng-bind-html="item.reason"></td>
						</tr>
					</tbody>
				</table>
				<div data-ng-if="serverReply.webReadiness && (serverReply.webReadiness.webConsole || serverReply.webReadiness.webServer)">
					<h3 class="text-left"><cv:msg key="label.webConnectivityFor" bundle="messagesJs" params="{{clientName}}"/></h3>
					<table class="webReadinessTable checkReadinessTable">
						<thead>
							<tr class="heading">
								<th data-ng-bind-html="'<cv:msg key="label.entity" bundle="clients"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="Status" bundle="job"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr data-ng-if="serverReply.webReadiness.webConsole" ng-class="{negative : !serverReply.webReadiness.webConsole.ready, positive : serverReply.webReadiness.webConsole.ready}">
								<td data-ng-bind-html="'<cv:msg key="label.nav.webconsole" bundle="navJs"/>'"></td>
								<td data-ng-if="serverReply.webReadiness.webConsole.ready" data-ng-bind-html="'<cv:msg key="label.ready" bundle="sqlServerInstance"/>'"></td>
								<td data-ng-if="!serverReply.webReadiness.webConsole.ready" data-ng-bind-html="'<cv:msg key="label.notReady" bundle="sqlServerInstance"/>'"></td>
								<td ng-class="{negativeColoring : !serverReply.webReadiness.webConsole.ready}" data-ng-bind-html="serverReply.webReadiness.webConsole.reason"></td>
							</tr>
							<tr data-ng-if="serverReply.webReadiness.webConsole" ng-class="{negative : !serverReply.webReadiness.webServer.ready, positive : serverReply.webReadiness.webServer.ready}">
								<td data-ng-bind-html="'<cv:msg key="label.webServer" bundle="clients"/>'"></td>
								<td data-ng-if="serverReply.webReadiness.webServer.ready" data-ng-bind-html="'<cv:msg key="label.ready" bundle="sqlServerInstance"/>'"></td>
								<td data-ng-if="!serverReply.webReadiness.webServer.ready" data-ng-bind-html="'<cv:msg key="label.notReady" bundle="sqlServerInstance"/>'"></td>
								<td ng-class="{negativeColoring : !serverReply.webReadiness.webServer.ready}" data-ng-bind-html="serverReply.webReadiness.webServer.reason"></td>
							</tr>
						</tbody>
					</table>
				</div>
				<div data-ng-if="serverReply.nfsReadiness && serverReply.nfsReadiness.errorCode != 0">
					<h3 class="text-left"><cv:msg key="label.nfsConnectivityFor" bundle="messagesJs" params="{{clientName}}"/></h3>
					<table class="nfsReadinessTable checkReadinessTable">
						<thead>
							<tr class="heading">
								<th data-ng-bind-html="'<cv:msg key="label.entity" bundle="clients"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="Status" bundle="job"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr class='negative'>
								<td><cv:msg key="label.nfsObjectStore" bundle="messagesJs"/></td>
								<td data-ng-if="serverReply.nfsReadiness.errorCode != 0" data-ng-bind-html="'<cv:msg key="label.notReady" bundle="sqlServerInstance"/>'"></td>
								<td class="negativeColoring" data-ng-bind-html="serverReply.nfsReadiness.errorMessage"></td>
							</tr>
						</tbody>
					</table>
				</div>
				<div data-ng-if="serverReply.indexServerReadiness">
					<h3 class="text-left"><cv:msg key="label.indexServerConnectivityFor" bundle="messagesJs" params="{{clientName}}"/></h3>
					<table class="indexServerReadinessTable checkReadinessTable">
						<thead>
							<tr class="heading">
								<th data-ng-bind-html="'<cv:msg key="label.entity" bundle="clients"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="Status" bundle="job"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr class='negative'>
								<td><cv:msg key="label.indexServer" bundle="messagesJs"/></td>
								<td data-ng-if="serverReply.indexServerReadiness.errorCode == 0" data-ng-bind-html="'<cv:msg key="label.ready" bundle="sqlServerInstance"/>'"></td>
								<td data-ng-if="serverReply.indexServerReadiness.errorCode != 0" data-ng-bind-html="'<cv:msg key="label.notReady" bundle="sqlServerInstance"/>'"></td>
								<td class="negativeColoring" data-ng-bind-html="serverReply.indexServerReadiness.errorMessage"></td>
							</tr>
						</tbody>
					</table>
				</div>

				<div data-ng-if="serverReply.convertedSqlProxyReadiness">
					<h3 class="text-left"><cv:msg key="label.sqlProxyConnectivityFor" bundle="messagesJs" params="{{clientName}}"/></h3>
					<table class="indexServerReadinessTable checkReadinessTable">
						<thead>
							<tr class="heading">
								<th data-ng-bind-html="'<cv:msg key="label.entity" bundle="clients"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="Status" bundle="job"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr class='negative' data-ng-repeat="sqlReadinessObj in serverReply.convertedSqlProxyReadiness">
								<td><cv:msg key="tableHeading.instance" bundle="messagesJs"/></td>
								<td data-ng-if="sqlReadinessObj.errorMessage == 0" data-ng-bind-html="'<cv:msg key="label.ready" bundle="sqlServerInstance"/>'"></td>
								<td data-ng-if="sqlReadinessObj.errorMessage != 0" data-ng-bind-html="'<cv:msg key="label.notReady" bundle="sqlServerInstance"/>'"></td>
								<td class="negativeColoring" data-ng-bind-html="sqlReadinessObj.errorMessage"></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="details" data-ng-if="showDetailsScreen">
			<div>
				<h3 class="text-left"><cv:msg key="label.informationFor" bundle="messagesJs" params="{{clientName}}"/></h3>
			</div>
			<div class="resultCheckReadiness">
					<table class="detailTable checkReadinessTable" data-ng-if="serverReply.detail && serverReply.detail.length>0">
					<thead>
						<tr class="heading">
							<th data-ng-bind-html="'<cv:msg key="SubClient" bundle="job"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="tableHeading.deduplication" bundle="messagesJs"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="tableHeading.compression" bundle="messagesJs"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="header.storagePolicy" bundle="clients"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="Media Agent" bundle="job"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
						</tr>
					</thead>
					<tbody>
						<tr data-ng-repeat="item in serverReply.detail" ng-class="{negative : item.ReadinessStatus!='Ready.\n', positive : item.ReadinessStatus=='Ready.\n'}">
							<td data-ng-bind-html="item.Subclient.entityName"></td>
							<td data-ng-bind-html="item.Deduplication"></td>
							<td data-ng-bind-html="item.Compression"></td>
							<td data-ng-bind-html="item.StoragePolicy"></td>
							<td data-ng-bind-html="item.MediaAgent"></td>
							<td class="negativeColoring" data-ng-bind-html="item.ReadinessStatus"></td>
						</tr>
					</tbody>
					</table>
					<table class="indexCacheTable checkReadinessTable" data-ng-if="serverReply.IndexCache && serverReply.IndexCache.length>0">
						<thead>
							<tr class="heading">
								<th data-ng-bind-html="'<cv:msg key="tableHeading.indexCachePath" bundle="messagesJs"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr data-ng-repeat="item in serverReply.IndexCache" ng-class="{negative : item.reason, positive : !item.reason}">
								<td data-ng-bind-html="item.IndexCachePath"></td>
								<td data-ng-bind-html="item.ReadinessStatus"></td>
								<td class="negativeColoring" data-ng-bind-html="item.reason"></td>
							</tr>
						</tbody>
					</table>
					<table class="sharepointAgentReadinessTable checkReadinessTable" data-ng-if="serverReply.sharepointAgentReadiness && serverReply.sharepointAgentReadiness.length>0">
						<thead>
						<tr class="checkReadinessHeading heading">
							<th data-ng-bind-html="'<cv:msg key="tableHeading.account" bundle="messagesJs"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="tableHeading.actionRequired" bundle="messagesJs"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
						</tr>
						</thead>
						<tbody data-ng-repeat="item in serverReply.sharepointAgentReadiness">
							<tr data-ng-repeat="subItem in item.permissionsResults.compatibilityItemResults" ng-class="{negative : subItem.assignResult=='Failed', positive : subItem.assignResult=='Success'}">
								<td data-ng-bind-html="subItem.sItem"></td>
								<td data-ng-bind-html="subItem.sUserActionRequired"></td>
								<td class="negativeColoring" data-ng-bind-html="subItem.assignResult"></td>
							</tr>
						</tbody>
					</table>
					<table class="dbOracleAgentReadinessTable checkReadinessTable" data-ng-if="serverReply.dbAgentReadiness && serverReply.dbAgentReadiness.length>0">
						<thead>
						<tr class="checkReadinessHeading heading">
							<th data-ng-bind="'<cv:msg key="tableHeading.agent" bundle="messagesJs"/>'"></th>
							<th data-ng-bind="'<cv:msg key="tableHeading.instance" bundle="messagesJs"/>'"></th>
							<th data-ng-bind="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
						</tr>
						</thead>
						 <tbody data-ng-repeat="item in serverReply.dbAgentReadiness" data-ng-init="dbAgent=(item.oracleAgent!=undefined)?item.oracleAgent:(item.sapOracleAgent!=undefined)?item.sapOracleAgent:item.db2Agent">
							<tr data-ng-if="dbAgent" data-ng-repeat="subItem in dbAgent.InstList" data-ng-class="{negative : subItem.statusCode!=0, positive : subItem.statusCode===0}">
								<td>
									<span data-ng-bind="item | getAgentName"></span>
								</td>
								<td>
									<span><cv:msg key="instanceName" bundle="messagesJs"/><span data-ng-bind="subItem.sid"></span></span>
								 	<span><cv:msg key="userAccount" bundle="messagesJs"/><span data-ng-bind="subItem.dbUser"></span></span>
								 	<span data-ng-bind="subItem.version"></span>
								</td>
								<td class="negativeColoring">
									<span data-ng-bind="subItem.statusCode | checkReadyStatus"></span>
									<span class="col-xs-12" data-ng-if="subItem.serviceOwner" data-ng-bind="subItem.serviceOwner"></span>
									<span class="col-xs-12" data-ng-if="subItem.groupCheck.installGroup"><cv:msg key="installGroup" bundle="messagesJs"/><span data-ng-bind="subItem.groupCheck.installGroup"></span> <span data-ng-bind="subItem.groupCheck.statusCode | checkOKStatus"></span></span>
								 	<span class="col-xs-12"><cv:msg key="readWritePermissions" bundle="messagesJs"/> <span data-ng-bind="subItem.permsCheck.statusCode | checkOKStatus"></span></span>
								 	<span data-ng-repeat="paths in subItem.permsCheck.pathsList">
										<span  class="check-readiness-subdetail" data-ng-bind="paths.path"> </span> <span data-ng-bind="paths.statusCode | checkOKStatus"></span>
									</span>
									<span data-ng-repeat="errorArg in subItem.permsCheck.errorArgs">
										<span class="col-xs-12" data-ng-bind="errorArg"> </span>
									</span>
									<span class="col-xs-12" data-ng-if="subItem.archiveLogEnabled"><cv:msg key="archiveLogMode" bundle="messagesJs"/><span data-ng-bind="subItem.archiveLogEnabled | checkArchiveEnabled"></span></span>
									<span class="col-xs-12" data-ng-if="subItem.dbModeCheck"><cv:msg key="databaseStatus" bundle="messagesJs"/><span data-ng-bind="subItem.dbModeCheck.statusCode | checkOKStatus"></span></span>
									<span class="check-readiness-subdetail" data-ng-if="subItem.dbModeCheck.connectStr" data-ng-bind="subItem.dbModeCheck.connectStr"></span>
									<span class="check-readiness-subdetail" data-ng-if="subItem.dbModeCheck.dbMode" data-ng-bind="subItem.dbModeCheck.dbMode"></span>
									<span data-ng-repeat="errorArg in subItem.dbModeCheck.errorArgs">
										<span class="check-readiness-subdetail" data-ng-if="errorArg" data-ng-bind="errorArg"></span>
									</span>
									<span class="col-xs-12" data-ng-if="subItem.sbtLibLoadCheck"><cv:msg key="sbtChannelAlloc" bundle="messagesJs"/><span  data-ng-bind="subItem.sbtLibLoadCheck.statusCode | checkOKStatus"></span></span>
									<span class="check-readiness-subdetail" data-ng-if="subItem.sbtLibLoadCheck.connectStr" data-ng-bind="subItem.sbtLibLoadCheck.connectStr"></span>
									<span class="check-readiness-subdetail" data-ng-if="subItem.sbtLibLoadCheck.sbtLibLoad" data-ng-bind="subItem.sbtLibLoadCheck.sbtLibLoad"></span>
									<span data-ng-repeat="errorArg in subItem.sbtLibLoadCheck.errorArgs">
										<span class="check-readiness-subdetail" data-ng-if="errorArg" data-ng-bind="errorArg"></span>
									</span>
									<span class="col-xs-12" data-ng-if="subItem.symLinksCheck && subItem.symLinksCheck.linksList.length>0"><cv:msg key="sapBackintSymbolicLinks" bundle="messagesJs"/>
									 	<span data-ng-repeat="symlinks in subItem.symLinksCheck.linksList">
											<span  class="check-readiness-subdetail" data-ng-if="symlinks.errorArgs[0]" data-ng-bind="symlinks.errorArgs[0]"></span> -> <span  class="check-readiness-subdetail" data-ng-if="symlinks.errorArgs[1]" data-ng-bind="symlinks.errorArgs[1]"></span> <span data-ng-bind="symlinks.statusCode | checkOKStatus"></span>
										</span>
									</span>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="vsaAgentReadiness checkReadinessTable" data-ng-if="serverReply.vsaAgentReadiness && serverReply.vsaAgentReadiness.listproxyReadiness.length > 0">
						<thead>
							<tr class="checkReadinessHeading heading">
								<th data-ng-bind-html="'<cv:msg key="tableHeading.proxyInstance" bundle="messagesJs"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr data-ng-repeat="item in serverReply.vsaAgentReadiness.listproxyReadiness" ng-class="{negative: item.vsaAgentReadiness.errorCode!=0, positive: item.vsaAgentReadiness.errorCode==0}">
								<td data-ng-bind-html="item.proxyclient.clientName"></td>
								<td class="negativeColoring" data-ng-if="item.vsaAgentReadiness.errorCode!=0" data-ng-bind-html="item.vsaAgentReadiness.errorMessage"></td>
								<td data-ng-if="item.vsaAgentReadiness.errorCode==0" data-ng-bind-html="'<cv:msg key="label.credentialVerified" bundle="messagesJs"/>'"></td>
							</tr>
						</tbody>
					</table>
					<table class="workFlowSvcReadiness checkReadinessTable" data-ng-if="serverReply.workFlowSvcReadiness && (serverReply.workFlowSvcReadiness.errorMessage || serverReply.workFlowSvcReadiness.errorCode==0)">
						<thead>
							<tr class="checkReadinessHeading heading">
							<th data-ng-bind-html="'<cv:msg key="label.column.role" bundle="job" />'"></th>
							<th data-ng-bind-html="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
							<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job" />'"></th>
							</tr>
						</thead>
						<tbody>
							<tr ng-class="{negative: serverReply.workFlowSvcReadiness.errorCode!=0, positive: serverReply.workFlowSvcReadiness.errorCode==0}">
								<td data-ng-bind-html="'<cv:msg key="tableHeading.workflow" bundle="messagesJs" />'"></td>
								<td data-ng-if="serverReply.workFlowSvcReadiness.errorCode==0" data-ng-bind-html="'<cv:msg key="readyState" bundle="messagesJs"/>'"></td>
								<td data-ng-if="serverReply.workFlowSvcReadiness.errorCode==0"></td>
								<td data-ng-if="serverReply.workFlowSvcReadiness.errorCode!=0" data-ng-bind-html="'<cv:msg key="notReadyState" bundle="messagesJs"/>'"></td>
								<td class="negativeColoring" data-ng-if="serverReply.workFlowSvcReadiness.errorCode!=0" data-ng-bind-html="serverReply.workFlowSvcReadiness.errorMessage"></td>
							</tr>
						</tbody>
					</table>
					<table class="vsaAgentReadiness checkReadinessTable" data-ng-if="serverReply.openVMSIBMiAgentReadiness && serverReply.openVMSIBMiAgentReadiness.listproxyReadiness.length > 0">
						<thead>
							<tr class="checkReadinessHeading heading">
								<th data-ng-bind-html="'<cv:msg key="tableHeading.proxyInstance" bundle="messagesJs"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="tableHeading.readinessStatus" bundle="messagesJs"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr data-ng-repeat="item in serverReply.openVMSIBMiAgentReadiness.listproxyReadiness" ng-class="{negative: item.vsaAgentReadiness.errorCode!=0, positive: item.vsaAgentReadiness.errorCode==0}">
								<td data-ng-bind-html="item.proxyclient.clientName"></td>
								<td class="negativeColoring" data-ng-if="item.vsaAgentReadiness.errorCode!=0" data-ng-bind-html="item.vsaAgentReadiness.errorMessage"></td>
								<td data-ng-if="item.vsaAgentReadiness.errorCode==0" data-ng-bind-html="'<cv:msg key="label.credentialVerified" bundle="messagesJs"/>'"></td>
							</tr>
						</tbody>
					</table>
					<table class="sharepointAgentReadinessTable checkReadinessTable" data-ng-if="serverReply.ExchAgentReadiness && serverReply.ExchAgentReadiness.listproxyReadiness.length>0 && serverReply.ExchAgentReadiness.errorCode === 0">
						<thead>
							<tr class="checkReadinessHeading heading">
								<th data-ng-bind-html="'
									<cv:msg key="label.exchangeAccessNode" bundle="clients"/>'">
								</th>
								<th data-ng-bind-html="'
									<cv:msg key="label.checkName" bundle="clients"/>'">
								</th>
								<th data-ng-bind-html="'
									<cv:msg key="Status" bundle="job"/>'">
								</th>
								<th data-ng-bind-html="'<cv:msg key="label.column.Reason" bundle="job" />'"></th>
							</tr>
						</thead>
						<tbody data-ng-repeat="item in serverReply.ExchAgentReadiness.listproxyReadiness" ng-class="{'negative': item.checkReadiness.errorCode!=0, 'positive': item.checkReadiness.errorCode==0}">
							<tr data-ng-repeat="subItem in item.checkReadiness.listCheckProcess">
								<td data-ng-bind-html="item.proxyclient.clientName"></td>
								<td data-ng-bind-html="subItem.checkName"></td>
								<td class="negativeColoring" data-ng-bind-html="subItem.resultName"></td>
								<td class="negativeColoring" data-ng-bind-html="subItem.failReason" ng-class="{'negative': subItem.result == 1, 'orange-font': subItem.result == 2}"></td>
							</tr>
						</tbody>
					</table>
					<table class="sharepointAgentReadinessTable checkReadinessTable" data-ng-if="serverReply.ExchAgentReadiness && serverReply.ExchAgentReadiness.errorCode && serverReply.ExchAgentReadiness.errorCode !== 0">
						<thead>
							<tr class="checkReadinessHeading heading">
								<th data-ng-bind-html="'<cv:msg key="heading.Agent" bundle="clients"/>'"></th>
								<th data-ng-bind-html="'<cv:msg key="label.errorMessage" bundle="clients"/>'"></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><cv:msg key="label.exchange" bundle="clients"/></td>
								<td data-ng-bind-html="serverReply.ExchAgentReadiness.errorStr"></td>
							</tr>
						</tbody>
					</table>
			</div>
		</div>
	</div>
</div>
