<div>
   <%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
   <script nonce="${sessionScope.cspNonce}" >
      <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
      <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
      <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
      <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
      <cv:cvMessages bundle="localization.search"></cv:cvMessages>
   </script>
   <cv-tile-component ac-id="apps-backup-history-calendar-view"  ng-show="showRecoveryTile || showNoDataMessage" id="apps-backup-history-calendar-view" data-title="{{::title}}" data-loader="backedUpDays" data-help-text="{{::params.helpInfo}}">
      <!-- model.restoreView  && !model.filterView removed from ng-if -->
      <div ng-show="showRecoveryTile">
         <div class="backup-filter margin-left-10" ng-if="!hideFilter && filteredDropdownData.length">
            <span uib-dropdown class="uib-dropdown dropdown header-menu">
               <a href="" data-uib-dropdown-toggle>
               <span class="dropdownArrow right"></span><span ng-bind="selectedFilter.label"></span>
               </a>
               <ul data-uib-dropdown-menu class="dropdown-menu-left dropdown-menu cv-dropdown-style-2 margin-top-0">
                  <li ng-click="updateFilter(filter)" ng-class="{'hidden': (params.filter.level !== filter.parent)}" ng-repeat="filter in filteredDropdownData">
                     <a class="no-padding" href="" ng-class="{'selected': (selectedFilter.label === filter.label)}">
                     <span ng-bind="filter.label" ></span>
                     </a>
                  </li>
               </ul>
            </span>
         </div>
         <div ng-class="{'ac-overlay': datesLoading}" >
            <div>
               <div id="backup-date" class="row date-time-picker" ng-if="backedUpDays">
                  <div uib-datepicker datepicker-options="datepicker.options" ng-model="dateModal.date"  class="date-picker backup-history" ></div>
               </div>
            </div>
            <div>
               <div id="restoreTimes" class="col-xs-12">
                  <div class="restore-time-controller">
                  </div>
                  <div  class="ps-container ps-theme-default" data-ng-if="model.jobs && model.jobs.length>0 && !params.createRecoveryPoint" ng-class="{'slider-height':params.useSlider}" id="perfect-scrollbar-backup-history">
                     <div  class="cv-main-bar-actions cv-main-bar-flex">
                        <a class="cv-main-bar-action" ng-click="showRestoreDialog()">
                           <cv:msg key="header.restore" bundle="serversJs" />
                        </a>
                        <a class="cv-main-bar-action" data-ng-if="showMigrate" ng-click="showRestoreDialog(showMigrate)">
                           <cv:msg key="label.migrate" bundle="migrate" />
                        </a>
                        <a class="cv-main-bar-action" data-ng-if="(showClone|| isLiveMountSupported) && !entity.isCloudDBInstance" data-ng-click="instantClone()">
                           <cv:msg key="label.instantClone" bundle="databaseClone" />
                        </a>
                        <a data-ng-if="isBackupValidationEligible" class="cv-main-bar-action" ng-click="validateBackup()">
                           <cv:msg key="label.validateBackup" bundle="collections" />
                        </a>
                     </div>
                  </div>
                  <div  class="ps-container ps-theme-default" id="perfect-scrollbar-backup-history"  data-ng-if="model.jobs && model.jobs.length>0 && params.createRecoveryPoint">
                        <div  class="cv-main-bar-actions cv-main-bar-flex">
                        <span ng-disabled="!isLastJobSelected" class="cv-main-bar-action" id="createRecoveryPoint">
                           <a class="color-white" ng-click="showRecoveryPointDialog()" >
                              <cv:msg key="label.createRecoveryPoint" bundle="serversJs" />
                           </a>
                        </span>
                        <span ng-disabled="isLastJobSelected" class="cv-main-bar-action" id="restoreData">
                           <a class="color-white" ng-click="showRecoveryPointDialog()">
                              <cv:msg key="header.restore" bundle="serversJs" />
                           </a>
                        </span>
                     </div>
                  </div>
                    <div class="job-history-legend" ng-if="hasFileIndexedJobs">
                  <div class="job-legend">
                     <span class="one-dot"></span>&nbsp;&nbsp;
                     <span>
                        <cv:msg key="legend.backupJob" bundle="clients" />
                     </span>
                  </div>
                  <div class="ci-job-legend">
                     <span class="square-dot"></span>&nbsp;&nbsp;
                     <span>
                        <cv:msg key="legend.fileIndexedJob" bundle="clients" />
                     </span>
                  </div>
               </div>
                  <cv-time-slot-picker   data-ng-if="timeSlotPickerOptions && !params.useSlider" slot-data-change="slotDataChange(callback)" cv-picker-options="timeSlotPickerOptions"></cv-time-slot-picker>
                  <div data-ng-show="model.slider.options && params.useSlider && !model.loadingJobs && model.jobs.length ">
                     <rzslider  class="backup-history-slider" rz-slider-model="model.slider.value" rz-slider-options="model.slider.options"></rzslider>
                     <div class="time-picker">
                        <span class="k-icon k-i-clock" ></span>
                        <table uib-timepicker id="backup-time-picker" ng-model="model.customTime"  hour-step="1" minute-step="5" show-spinners="false" show-seconds="params.useSlider"></table>
                     </div>
                  </div>
                  <div class="pl-15" data-ng-if="model.showCustomTime && !params.useSlider && !model.loadingJobs">
                     <div class="row margin-bottom-10">
                        <label class="margin-0 row element-indent-class">
                           <input type="radio" ng-model="model.selectedJob" ng-value="model.customTimePicked">
                           <span>
                              <span>&nbsp;&nbsp;</span>
                              <span ng-bind-html="'
                              <cv:msg key="label.customTime" bundle="browse"/>
                              '">
                           </span>
                           </span>
                        </label>
                     </div>
                     <table uib-timepicker id="backup-time-picker" data-ng-if="model.selectedJob == model.customTimePicked" ng-model="model.customTime" hour-step="1" minute-step="5" class="time-picker" show-spinners="false" show-seconds="params.useSlider"></table>
                  </div>
               </div>
            </div>
         </div>
         <div class="page-details-box-links">
         </div>
      </div>
      <div ng-show="showNoDataMessage && !showRecoveryTile && backedUpDays" id="backup-date">
         <span class="server-message" ng-bind-html="'<cv:msg key="No_backups_available" bundle="browse"/>'"></span>
      </div>
   </cv-tile-component>
</div>
