<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.selectJobToRestore" bundle="clients"/></h1>
</div>
<div class="setup-content backup-options">
	<div class="bootstrap-wrapper">
        <span ng-if="ctrl.hasFileIndexedJobs" class="restore-legend pull-right">
            <span class="square-dot"></span>&nbsp;&nbsp;<cv:msg key="legend.fileIndexedJob" bundle="clients" />
        </span>
        <span>
            <div class="global-options remove-border-padding form-panel-holder">
                <label class="element-indent-class" ng-repeat="job in ctrl.jobs | orderBy : '-time'">
                    <input type="radio" ng-model="ctrl.selectedJob" ng-value="job.data">
                    <span><span ng-bind-html="ctrl.getDateString(job.data.jobSummary)"></span><span class="restore-dots" ng-if="ctrl.hasFileIndexedJobs && job.data.jobSummary.contentIndexed"><span class="square-dot"></span></span></span>
                </label>
            </div>
        </span>
	</div>
	<div class="button-container">
		<button id="backupHistoryModal_button_#2917" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="ctrl.browse()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="backupHistoryModal_button_#7182" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="ctrl.dismiss()"><cv:msg key="Cancel" bundle="messages"/></button> 
	</div>
</div>