<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!editMode"><cv:msg key="label.addRule" bundle="collectionsJs" /></h1>
	<h1 data-ng-if="editMode"><cv:msg key="label.editContent" bundle="collectionsJs" /></h1>
</div>
<div class="modal-body">
	<span class="{{serverMessage.type}} serverMessage" data-ng-bind="serverMessage.message"></span>
	<form name="addEditSCGRuleForm" cv-hide-api novalidate autocomplete="off" data-cv-submit="addSCGRule()" class="add-collection-form">
		
		<div class="form-group row flex-center">
			<div class="col-sm-5"><label><cv:msg key="label.selectRule" bundle="collectionsJs"/></label></div>
			<div class="col-sm-7">
				<!-- <select
					name="selectRule"
					data-ng-options="ruleType as ruleType.label for ruleType in propertyTypeList track by ruleType.id"
					data-ng-model="ruleInfo.scgProperty" data-ng-change="updateRuleEditor()" required>
				</select> -->
				<isteven-multi-select
					input-model="propertyTypeList"
					button-label="label"
					output-model="ruleInfo.scgProperty"
					id="ruleType"
					item-label="label"
					search-limit="10"
					search-property="label"
					selection-mode="single"
					tick-property="selected"
					class="isteven-multi-select user-group-select"
					helper-elements="filter"
					on-item-click="updateRuleEditor()">
				</isteven-multi-select>

				<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.selectRule)">
					<cv:msg key="error.selectToken" bundle="clients"/>
				</span>			
			</div>
		</div>
		
		<div class="form-group row flex-center">
			<div class="col-sm-5"><label><cv:msg key="label.matchesRule" bundle="collectionsJs"/></label></div>
			<div class="col-sm-7">
				<select
					name="matchesRule"
					data-ng-options="filter as (filter.label| getLocalizedLabel) for filter in filtersMap[ruleInfo.scgProperty[0].propType] | orderBy: 'filterID' track by filter.filterID"
					data-ng-model="ruleInfo.filter" required>
				</select>
				<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.matchesRule)">
					<cv:msg key="error.selectCondition" bundle="clients"/>
				</span>
			</div>
		</div>
		<!-- INPUT FIELD IS SPECIFIC TO TOKEN SELECTED -->
		<div data-ng-if="isIntegerType(ruleInfo.scgProperty[0].propType)">
			<div data-ng-if="ruleInfo.filter.label === 'BETWEEN' || ruleInfo.filter.label === 'NOT_BETWEEN'">
				<div class="form-group row flex-center">
					<div class="col-sm-5"><label><cv:msg key="label.from" bundle="clients" /></label></div>
					<div class="col-sm-7">
						<input type="number" min="0" max="2147483647" value="0" name="fromValue" data-ng-model="ruleInfo.value" />
						<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.fromValue)">
							<cv:msg key="error.enterValue" bundle="clients"/>
						</span>
					</div>
				</div>
				
				<div class="form-group row flex-center">
					<div class="col-sm-5"><label><cv:msg key="label.to" bundle="clients" /></label></div>
					<div class="col-sm-7">
						<input type="number" min="0" max="2147483647" value="0" name="toValue" data-ng-model="ruleInfo.secValue" />
						<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.toValue)">
							<cv:msg key="error.enterValue" bundle="clients"/>
						</span>
					</div>
				</div>
			</div>
			
			<div data-ng-if="!(ruleInfo.filter.label === 'BETWEEN' || ruleInfo.filter.label === 'NOT_BETWEEN')">
				<div class="form-group row flex-center">
					<div class="col-sm-5"><label><cv:msg key="label.value" bundle="clients" /></label></div>
					<div class="col-sm-7">
						<input type="number" min="0" max="2147483647" value="0" name="intValue" data-ng-model="ruleInfo.value" required/>
						<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.intValue)">
							<cv:msg key="error.enterValue" bundle="clients"/>
						</span>
					</div>
				</div>
			</div>
		</div>		
		
		<div data-ng-if="isStringType(ruleInfo.scgProperty[0].propType)">
			<div class="form-group row flex-center">
				<div class="col-sm-5"><label><cv:msg key="label.value" bundle="clients" /></label></div>
				<div class="col-sm-7">
					<input type="text" name="stringValue" data-ng-model="ruleInfo.value" required>
					<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.stringValue)">
						<cv:msg key="error.enterValue" bundle="clients"/>
					</span>
				</div>
			</div>
		</div>
				
				
		<div data-ng-if="ruleInfo.scgProperty[0].propType === filterTypes.ENUM">
			<div class="form-group row flex-center">
				<div class="col-sm-5"><label><cv:msg key="label.value" bundle="clients" /></label></div>
				<div class="col-sm-7">
					<select 
						name="enumValue"
						data-ng-if="!searchableDropdown"
						data-ng-model="model.selectedRuleValue" required
						data-ng-change="printSelectedRule()"
						data-ng-options="enumValue as enumValue.label for enumValue in enumValuesList">
							<option value="" disabled><cv:msg key="label.selectAnOption" bundle="clients" /></option>
					</select>
					<isteven-multi-select
						data-ng-if="searchableDropdown"
						input-model="enumValuesList"
						button-label="label"
						output-model="searchableDropdownOutput"
						item-label="label"
						search-limit="10"
						search-property="label"
						selection-mode="single"
						tick-property="selected"
						class="isteven-multi-select"
						on-item-click="setModelOutput()">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="cv.addEditSCGRuleForm.needsAttention(addEditSCGRuleForm.enumValue)">
						<cv:msg key="error.enterValue" bundle="clients"/>
					</span>
				</div>
			</div>
		</div>
		
		<div data-ng-if="ruleInfo.scgProperty[0].propType === filterTypes.SELECTION">
			<div data-ng-if="ruleInfo.scgProperty[0].name === 'APP_TYPE'">
				<cv-agent-selection-component 
					tree-container ='model.agentSelectionTree' 
					initial-selection="model.selectedAgentsAsReceived">
				</cv-agent-selection-component>
			</div>
			<div data-ng-if="ruleInfo.scgProperty[0].name === 'VSA_DISCOVER_CLIENT'">
				<cv-entity-selection-tree-component tree-options="model.entitySelectionTreeOptions"></cv-entity-selection-tree-component>
			</div>
		</div>
		<div data-ng-if="ruleInfo.scgProperty[0].propType == filterTypes.SELECTION_V2 || ruleInfo.scgProperty[0].name === 'PACKAGE_INSTALLED'">
			<div class="form-group row flex-center">
				<div class="col-sm-5">
					<label for="userGroupType"><cv:msg key="label.values" bundle="clients" /></label>
				</div>
				<div class="col-sm-7">
					<isteven-multi-select
		   				  input-model="model.multiSelectionList"
		  				  button-label="label"
		  				  item-label="label"
		   				  tick-property="selected"
		   				  class="isteven-multi-select user-group-select"
		   				  id="userGroupType"
		   				  name="userGroupType"
		   				  helper-elements="all none reset filter"
		   				  max-labels="2"
		   				  translation="model.localLang">
					</isteven-multi-select>
				</div>
			</div>
		</div>		
		
		
		<div class="button-container">
			<button id="addSCGRuleModal_button_#1094" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="addSCGRuleModal_button_#2654" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
		</div>
	</form>
</div>