<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1 data-ng-if='!isEdit'><cv:msg key="title.addLibrary" bundle="storage" /></h1>
		<h1 data-ng-if='isEdit'><cv:msg key="label.editStorage" bundle="storage" /></h1>
	</div>
	<div class="setup-content" >
		<p class="{{rpServerMessage.type}} serverMessage">{{rpServerMessage.message}}</p>
		<form name="storageForm" class="" novalidate data-cv-submit="addOrEditRPStore()" autocomplete="off">
			<label>
				<cv:msg key="Name" bundle="storage"/>
				<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}"  type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" required maxlength="128"/>
				<span class="help-block"  data-ng-show="storageForm.libraryName.$error.required && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.rpStoreName.required" bundle="storage"/></span>
				<span class="help-block"  data-ng-show="storageForm.libraryName.$error.maxlength && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.rpStoreName.length" bundle="storage"/></span>
			</label>
			<label data-ng-if='!isEdit && (agentList.length > 0)' for="mediaAgent" class="select-label"><cv:msg key="label.mediaAgent" bundle="storage"/>
					<select id="mediaAgent" name="mediaAgent" data-ng-model="libraryInfo.controller"
							data-ng-options="agent.displayName for agent in agentList track by agent.mediaAgentId" required
							data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mediaAgent)}" ng-change="setRPStoreClientType()">
						<option value=""><cv:msg key="placeholder.mediaAgent" bundle="storage"/></option>
					</select>
					<span class="help-block" data-ng-show="cv.storageForm.needsAttention(storageForm.mediaAgent)"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
			</label>
			<label data-ng-if='isEdit'><cv:msg key="label.mediaAgent" bundle="storage"/> <input disabled type="text" value="{{libraryInfo.associatedMedia}}"/></label>
			<!--<label for="minThreshold"><cv:msg key="label.minimumThreshold" bundle="storage"/>
				<input type="number" min="10" data-ng-maxlength="3" name="minThreshold" data-ng-model="libraryInfo.minThreshold" required/>
				<span class="help-block" ng-show="storageForm.minThreshold.$invalid && cv.storageForm.needsAttention(storageForm.minThreshold)">
								<cv:msg key="error.minThreshold.invalid"  bundle="storage"/>
				</span>
			</label>-->
			<label for="maxThreshold"><cv:msg key="label.maximumThreshold" bundle="storage"/>
				<input type="number" min="50" data-ng-maxlength="4" name="maxThreshold" data-ng-model="libraryInfo.maxThreshold" required/>
				<span class="help-block" ng-show="storageForm.maxThreshold.$invalid && cv.storageForm.needsAttention(storageForm.maxThreshold)">
								<cv:msg key="error.maxThreshold.invalid"  bundle="storage"/>
				</span>
			</label>
			<div class="inline-two-radio-content" data-ng-if='!isEdit'>
				<label class="lable-for-radio float-left"><cv:msg key="label.rpStorePathType" bundle="storage"/></label>
				<span class="radio-content">
					<label for="localPath"><input id="localPath" name="localPath" type="radio" data-ng-model="typeOfStorage.type" value="localStorage" name="typeOfStorage.type" data-ng-change="changeStorageType()"><cv:msg key="Local_Path" bundle="storage"/></label>
					<label for="networkPath"><input id="networkPath" name="networkPath" type="radio" data-ng-model="typeOfStorage.type" value="networkStorage" name="typeOfStorage.type" data-ng-change="changeStorageType()"><cv:msg key="Network_Path" bundle="storage"/></label>
				</span>
			</div>
			<div class="overflow-auto">
				<label for="mountPath" data-ng-if="!isEdit" data-ng-class="{'storage-path-label': typeOfStorage.type==='localStorage'}">
					<cv:msg key="Path" bundle="storage"/>
					<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.mountPath)}" type="text" name="mountPath" id="mountPath" data-ng-model="libraryInfo.mountPath.name" required data-ng-pattern='pathPattern.pattern'/>
					<span class="help-block" data-ng-value="form-error" data-ng-show="storageForm.mountPath.$error.required && cv.storageForm.needsAttention(storageForm.mountPath)"><cv:msg key="error.mountpath.required" bundle="storage"/></span>
					<span class="help-block" data-ng-show="storageForm.mountPath.$error.pattern && cv.storageForm.needsAttention(storageForm.mountPath)">
									<cv:msg key="error.mountpath.invalid" bundle="storage"/>
					</span>
				</label>
				<button id="addRPStore_button_#9556" type="button" data-ng-if="(typeOfStorage.type==='localStorage') && !isEdit"  data-ng-click="browse()" class="btn btn-default browse-btn">
					<cv:msg key="Browse" bundle="storage"/>
				</button>
			</div>
			<div data-ng-if="!isEdit && (typeOfStorage.type==='networkStorage')" class="credentials">
				<label>
					<cv:msg key="User Name" bundle="storage"/>
					<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.loginName)}" type="text" name=loginName data-ng-model="libraryInfo.loginName" required/>
					<span class="help-block" data-ng-show="storageForm.loginName.$error.required && cv.storageForm.needsAttention(storageForm.loginName)"><cv:msg key="error.loginName.required" bundle="storage"/></span>
				</label>
				<label>
					<cv:msg key="Password" bundle="storage"/>
					<input type="password" data-ng-model="libraryInfo.password"/>
				</label>
			</div>
			<!-- peak interval window -->
			<div class="global-options remove-border-padding collections-global-options add-server-plan">
				<label for="intervalWindowDiv">
					<span class="backup-window-label"><cv:msg key="label.peakTitle" bundle="storage" /></span>
					<span class="snap-backup-window-list-wrapper" id="intervalWindowDiv" name="intervalWindowDiv">
						<cv-backup-window-list data-cv-model="libraryInfo.intervalWindow"></cv-backup-window-list>
					</span>
				</label>
			</div>
			<div class="button-container">
				<button id="addRPStore_button_#4555" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
					<cv:msg key="Cancel" bundle="messages"/>
				</button>
				<button id="addRPStore_button_#9443" class="btn btn-primary cvBusyOnAjax" type="submit">
					<div data-ng-if="isEdit">
						<cv:msg key="action.save" bundle="storage"/>
					</div>
					<div data-ng-if="!isEdit" data-ng-disabled ="!libraryInfo.controller.mediaAgentId" >
						<cv:msg key="action.createLibrary" bundle="storage"/>
					</div>
				</button>
			</div>
		</form>
	</div>
</div>