<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1>
		    <label ng-if="isEditMode">
				<cv:msg key="label.editOpenVMSServer" bundle="serversJs"/>
				<cv-help-component help-text="<cv:msg key="label.editOpenVMSHelpText" bundle="serversJs"/>"></cv-help-component>
			</label>
		    <label ng-if="!isEditMode">
				<cv:msg key="label.addOpenVMSServer" bundle="serversJs"/>
				<cv-help-component help-text="<cv:msg key="label.addOpenVMSHelpText" bundle="serversJs"/>"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-content">
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
				<form name="addOpenVMSServerForm" id="addOpenVMSServerForm" novalidate autocomplete="off" class="add-OpenVMS-form">
					<div class="cv-modal-wrapper" ng-if="!isEditMode">
						<label class="cv-label word-wrap" for="clientName">
							<cv:msg key="label.clientName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="clientName" id="clientName" data-ng-model="openVMSServerRequest.entity.clientName" data-ng-change="helpText.clientName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.clientName"><cv:msg key="error.clientName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-if="!isEditMode">
						<label class="cv-label word-wrap" for="hostName">
							<cv:msg key="label.hostName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="hostName" id="hostName" data-ng-model="openVMSServerRequest.entity.hostName" data-ng-change="helpText.hostName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.hostName"><cv:msg key="error.hostName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="baseInstallFolder">
							<cv:msg key="label.baseInstallFolder" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="baseInstallFolder" id="baseInstallFolder" data-ng-model="openVMSServerRequest.clientInfo.openVMSProperties.baseInstallFolder" data-ng-change="helpText.baseInstallFolder = false" required />
							<span class="cv-help-block" data-ng-show="helpText.baseInstallFolder"><cv:msg key="error.baseInstallFolder" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="cvdPort">
							<cv:msg key="label.cvdPort" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="number" name="cvdPort" id="cvdPort" data-ng-model="openVMSServerRequest.clientInfo.openVMSProperties.cvdPort" data-ng-change="helpText.cvdPort = false" required />
							<span class="cv-help-block" data-ng-show="helpText.cvdPort"><cv:msg key="error.cvdPort" bundle="serversJs" /></span>
						</div>
					</div>
					<h4 class="text-left padding-left-20"><cv:msg key="label.openVMSUserCredentials" bundle="serversJs" /></h4>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="userName">
							<cv:msg key="label.userName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="userName" id="userName" ng-model="openVMSServerRequest.clientInfo.openVMSProperties.userAccount.userName" data-ng-change="helpText.userName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.userName"><cv:msg key="error.userName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="password">
							<cv:msg key="label.password" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="password" name="password" placeholder="{{ keepSamePlaceholder }}" id="password" ng-model="dummy.password" data-ng-change="helpText.password = false" data-ng-required="!isEditMode" />
							<span class="cv-help-block" data-ng-show="addOpenVMSServerForm.password.$error.required && addOpenVMSServerForm.password.$dirty"><cv:msg key="error.password" bundle="serversJs" /></span>
						</div>
					</div>
					
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="confirmPassword">
							<cv:msg key="label.confirmPassword" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="password" name="confirmPassword" data-ng-required="!isEditMode" data-cv-equals="{{ dummy.password }}"  id="confirmPassword" ng-model="dummy.confirmPassword" data-ng-change="helpText.confirmPassword = false" />
							<span class="cv-help-block" data-ng-show="addOpenVMSServerForm.confirmPassword.$error.cvEquals && addOpenVMSServerForm.password.$dirty"><cv:msg key="error.confirmPassword" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
							<label class="cv-label word-wrap" for="proxyClient">
								<cv:msg key="label.proxyClient" bundle="serversJs" />
							</label>
						<div class="cv-inline-wrapper">							
							<div class="cv-app-page-config">
								<isteven-multi-select id="addOpenVMSServer_isteven-multi-select_#9216" input-model="proxyClientList" output-model="selectedProxyClient" helper-elements="filter reset" button-label="clientName" item-label="clientName" tick-property="selected" class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter" on-reset="reset()" on-close="helpText.proxyClient = false; addProxyClientSelected()" selection-mode= {{selectionMode}} required></isteven-multi-select> 
							</div>
							<span class="cv-help-block" data-ng-show="helpText.proxyClient"><cv:msg key="error.proxyClient" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="button-container">
						<button id="addOpenVMSServer_button_#3080" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
						<button id="addOpenVMSServer_button_#2471" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="serverMessage.message!=''" data-ng-click="addOpenVMSServer()"><cv:msg key="Save"/></button> 
					</div>
				</form>
			</div>
	</div>
