<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1>
		    <label ng-if="!isEditMode">
				<cv:msg key="label.addClusterServer" bundle="servers"/>
				<cv-help-component help-text="<cv:msg key="label.addClusterServerHelpText" bundle="servers"/>"></cv-help-component>
			</label>
			<label ng-if="isEditMode">
				<cv:msg key="label.editClusterServer" bundle="servers"/>
				<cv-help-component help-text="<cv:msg key="label.editClusterServerHelpText" bundle="servers"/>"></cv-help-component>
			</label>
		</h1>
	</div>
	<div class="setup-content">
		<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
				<form name="addClusterServerForm" id="addClusterServerForm" cv-submit="addClusterServer()" novalidate autocomplete="off">
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						<label class="cv-label word-wrap" for="clusterName">
							<cv:msg key="label.clusterName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="clusterName" id="clusterName" data-ng-model="ClusterServerRequest.entity.clientName" data-ng-change="helpText.clusterName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.clusterName"><cv:msg key="error.clusterName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						<label class="cv-label word-wrap" for="hostName">
							<cv:msg key="label.hostName" bundle="serversJs" />
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="hostName" id="hostName" data-ng-model="ClusterServerRequest.entity.hostName" data-ng-change="helpText.hostName = false" required />
							<span class="cv-help-block" data-ng-show="helpText.hostName"><cv:msg key="error.hostName" bundle="serversJs" /></span>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						<label class="cv-label" for="osTypeWINDOWS"><cv:msg key="label.osType" bundle="serversJs"/></label>
						<div class="cv-inline-wrapper">
							<label class="inline-label no-margin">
								<input type="radio" id="osTypeWINDOWS" class="no-float-auto" data-ng-model="osType" value="WINDOWS" name="osType" data-ng-change="loadAgents()"/>
								<cv:msg key="label.osType.windows" bundle="serversJs" />
							</label>
							<label class="inline-label">
									<input type="radio" id="osTypeUNIX" class="no-float-auto" data-ng-model="osType" value="UNIX" name="osType" data-ng-change="loadAgents()"/>
									<cv:msg key="label.osType.unixLinux" bundle="serversJs" />
							</label>
						</div>
					</div>
					<div class="cv-modal-wrapper" ng-hide="isEditMode">
						    <label class="cv-label" for="planId"> <cv:msg key="tableHeader.plan" bundle="users" /></label>
							<div class="cv-inline-wrapper">
								<div class="cv-app-page-config">
									<isteven-multi-select
											id="plan" 
											input-model="clusterPlansInputModal"
											button-label="planName"
											item-label="planName"
											selection-mode="single"
											search-property="planName planId"
											tick-property="ticked"
											class="isteven-multi-select user-group-select"
											helper-elements="filter none showSelected"
											on-item-click="helpText.selectAPlan = false; selectPlan(data)"
											translation="localLang"
											required >
									</isteven-multi-select>
								</div>
								<span class="cv-help-block" data-ng-show="helpText.selectAPlan"><cv:msg key="error.noPlan" bundle="serversJs" /></span>
							</div>
					</div>
					
					<div class="cv-modal-wrapper">
						<label class="cv-label word-wrap" for="jobResultsDirectory">
							<cv:msg key="label.jobstoragecache" bundle="serversJs" />
							<cv-help-component help-text="<cv:msg key="info.jobResultsDirectory" bundle="serversJs"/>"></cv-help-component>
						</label>
						<div class="cv-inline-wrapper">
							<input type="text" name="jobResultsDirectory" id="jobResultsDirectory" data-ng-model="ClusterServerRequest.clusterClientsInfo.jobResultsDir.path" data-ng-change="helpText.jobResultsDirectory = false" required />
							<span class="input-group-btn" ng-hide="!isEditMode">
								<button id="jobResultsDirectory_button_" type="button" class="btn btn-default browse-btn" data-ng-click="browse()"><cv:msg key="action.browse" bundle="collections"/></button> 
							</span>
							<span class="cv-help-block" data-ng-show="helpText.jobResultsDirectory"><cv:msg key="error.noJobStorageCache" bundle="serversJs" /></span>
						</div>
					</div>
					
					<h4 class="text-left padding-left-20"><cv:msg key="label.clusterGroup" bundle="serversJs" /></h4>
					
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="nodesList"> <cv:msg key="label.nodes" bundle="serversJs" /></label>
							<div class="cv-inline-wrapper">
								<div class="cv-app-page-config">
									<isteven-multi-select
										id="nodes" 
										input-model="nodesList"
	                                 	output-model="selectedNodesList"
	                                 	button-label="clientName"
	                                 	item-label="clientName"
	                                 	tick-property="selected"
	                                 	selection-mode="mutiple"
	                                 	search-property="clientName clientId"
	                                 	class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
	                                 	helper-elements="filter all none showSelected"
	                                 	translation="localLang"
	                                 	on-item-click="nodesSelected = true;"
	                                 	on-reset="reset()"
	                                 	on-close="helpText.nodesList = false; addNodesSelected()"
	                                 	required >
									</isteven-multi-select>
								</div>
								<span class="cv-help-block" data-ng-show="helpText.nodesList"><cv:msg key="error.nodes" bundle="serversJs" /></span>
							</div>
					</div>
					
					<div class="cv-modal-wrapper">
						<label class="cv-label" for="agents"> <cv:msg key="heading.Agents" bundle="clients" />
						<cv-help-component help-placement="right" help-text="<cv:msg key="info.agents" bundle="serversJs"/>"></cv-help-component>
						</label>
							<div class="cv-inline-wrapper">
								<div class="cv-app-page-config">
									<isteven-multi-select
										id="agents" 
										input-model="agentsList"
	                                 	output-model="selectedAgentsList"
	                                 	button-label="ComponentName"
	                                 	item-label="ComponentName"
	                                 	tick-property="selected"
	                                 	selection-mode="mutiple"
	                                 	search-property="ComponentName ComponentId"
	                                 	class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
	                                 	helper-elements="filter all none showSelected"
	                                 	translation="localLang"
	                                 	on-reset="reset()"
	                                 	group-property="msGroup"
	                                 	on-close="helpText.agents = false; addAgentsSelected()"
	                                 	required >
									</isteven-multi-select>
								</div>
							</div>
					</div>
					
					<div class="cv-modal-wrapper">
						<label>
							<cv-toggle toggle-name="foreceSync" toggle-label="label.foreceSync" value="ClusterServerRequest.clusterClientsInfo.clusterClientProperties.forceSyncConfigOnRemoteNodes"></cv-toggle>
						</label>
					</div>
					
					<div class="button-container">
						<button id="addClusterServer_button_" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
						<button id="addClusterServer_button_" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="" data-ng-click="addClusterServer()"><cv:msg key="Save"/></button> 
					</div>
				</form>
			</div>
	</div>
