<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div class="form-group" data-ng-if="isSetup || !isModalFromMultipleDDBGrid">
    <label class="col-xs-5 col-sm-5" for="libraryName"><cv:msg key="Name" bundle="storage"/></label>
    <div class="col-xs-7 col-sm-7 text-align-left">
        <span data-ng-if="action=='addCloudMP'|| action=='editMP'" class="toggle-control padding-bottom-10">{{libraryInfo.libraryEntity.libraryName}}</span>
        <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" data-ng-if="action!='addCloudMP'&&action!='editMP'" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" required maxlength="128"/>
        <span data-ng-if="!isSetup" class="help-block" data-ng-show="storageForm.libraryName.$error.required && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.libraryName.required" bundle="storage"/></span>
        <span data-ng-if="!isSetup" class="help-block" data-ng-show="storageForm.libraryName.$error.maxlength && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.libraryName.length" bundle="storage"/></span>
        <span data-ng-if="isSetup" class="help-block" data-ng-show="storageForm.libraryName.$error.required && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.storagePoolName.required" bundle="storage"/></span>
        <span data-ng-if="isSetup" class="help-block" data-ng-show="storageForm.libraryName.$error.maxlength && cv.storageForm.needsAttention(storageForm.libraryName)"><cv:msg key="error.storagePoolName.length" bundle="storage"/></span>
    </div>
</div>
<div data-ng-if="isSetup || (isModalFromMultipleDDBGrid && action === 'addCloudLib') || !isModalFromMultipleDDBGrid">
    <div class="form-group" data-ng-if="isSetup || (isModalFromMultipleDDBGrid && showInputs) || (!isCloudStorageForMultipleDDBs && !isModalFromMultipleDDBGrid)">
        <label for="cloudType" class="col-xs-5 col-sm-5"><cv:msg key="label.cloudType" bundle="storage"/></label>
        <div class="col-xs-7 col-sm-7 text-align-left">
            <div data-ng-if="action === 'editMP' || action === 'addCloudMP'" class="toggle-control padding-bottom-10">
                {{libraryInfo.serverType.name}}
            </div>
            <div data-ng-show="action !== 'editMP' && action !== 'addCloudMP'">
                <isteven-multi-select
                    input-model="cloudTypeList"
                    output-model="cloud.cloudType"
                    button-label="name"
                    item-label="name"
                    helper-elements="filter"
                    hide-search-button="false"
                    directive-id="cloudServerType"
                    id="cloudType"
                    name="cloudType"
                    tick-property="selected"
                    class="isteven-multi-select user-group-select "
                    selection-mode="single"
                    on-item-click="refreshCloudInputs()"
                >
                <span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.cloudType)"><cv:msg key="error.cloudType" bundle="storage"/></span>
            </div>
        </div>
    </div>
    <div class="form-group" data-ng-if="isSetup || isModalFromMultipleDDBGrid || (!isCloudStorageForMultipleDDBs && !isModalFromMultipleDDBGrid)">
        <label for="mediaAgent" class="col-xs-5 col-sm-5"><cv:msg key="label.mediaAgent" bundle="storage"/></label>
        <div class="col-xs-7 col-sm-7 text-align-left">
            <div class="toggle-control padding-bottom-10" data-ng-if="action === 'editMP'">
                {{libraryInfo.controller.mediaAgentName}}
            </div>
            <div data-ng-if="action !== 'editMP'">
                <select-with-create-button
                    select-id="mediaAgent"
                    select-name="mediaAgent"
                    key-label="displayName"
                    key-id="mediaAgentId"
                    option-list="agentList"
                    selected-option="selectedMediaAgent"
                    select-only-option="true"
                    on-change-option="setClientType"
                    on-click-create-button="openCreateMediaAgentModal"
                    is-required="true"
                    has-error="mediaAgentError || cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)"
                    select-disabled="action=='editMP'"
                    placeholder='<cv:msg key="placeholder.mediaAgent" bundle="storage"/>'
                    is-credential="false">
                </select-with-create-button>
                <span class="help-block" data-ng-show="mediaAgentError || cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
            </div>
        </div>
    </div>
    <div class="hpe-catalyst-storage-container"
        data-ng-if="libraryInfo.serverType.id === HPE_CATALYST_STORAGE
        && (isSetup || (isModalFromMultipleDDBGrid && showInputs) || (!isCloudStorageForMultipleDDBs && !isModalFromMultipleDDBGrid))">
    <div class="form-group">
            <label for="serviceHost" class="col-xs-5 col-sm-5">
             <cv:msg key="label.StoreOnceHost" bundle="storage"/>
        </label>
        <div class="col-xs-7 col-sm-7">
            <input id="serviceHost" type="text" name="ServiceHost" data-ng-model="libraryInfo.serviceHost" required maxlength="128"/>
            <span class="help-block" data-ng-show="storageForm.ServiceHost.$error.required && cv.storageForm.needsAttention(storageForm.ServiceHost)"><cv:msg key="error.ServiceHost.required" bundle="storage"/></span>
        </div>
    </div>
        <div class="form-group">
            <label for="bucket" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Bucket | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input id="bucket" type="text" name="Bucket" data-ng-model="libraryInfo.mountPath.name" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.Bucket.$error.required && cv.storageForm.needsAttention(storageForm.Bucket)">{{cloudTypeLables[libraryInfo.serverType.id].error_Bucket | cvLoc}}</span>
            </div>
        </div>
        <div class="form-group" >
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_UserName | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input type="text" name="HPEUserName" data-ng-model="libraryInfo.loginName" maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.HPEUserName.$error.required && cv.storageForm.needsAttention(storageForm.HPEUserName)"><cv:msg key="error.UserName.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
                <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Password | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input type="password" name="HPEPassword" data-ng-model="libraryInfo.password" maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.HPEPassword.$error.required && cv.storageForm.needsAttention(storageForm.HPEPassword)"><cv:msg key="error.Password.required" bundle="storage"/></span>
            </div>
        </div>
    </div>
    <div class="full-width flex-column" data-ng-if="libraryInfo.serverType.id !== HPE_CATALYST_STORAGE
        && libraryInfo.serverType.id != ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE
        && libraryInfo.serverType.id != ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE
        && libraryInfo.serverType.id != METALLIC_STORAGE
        && (isSetup || (isModalFromMultipleDDBGrid && showInputs) || (!isCloudStorageForMultipleDDBs && !isModalFromMultipleDDBGrid))">
        <div class="form-group">
            <label for="serviceHost" class="col-xs-5 col-sm-5">
                <cv:msg key="label.serviceHost" bundle="storage"/>
            </label>
            <div class="col-xs-7 col-sm-7">
                <input id="serviceHost" type="text" name="ServiceHost" data-ng-model="libraryInfo.serviceHost" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.ServiceHost.$error.required && cv.storageForm.needsAttention(storageForm.ServiceHost)"><cv:msg key="error.ServiceHost.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group" data-ng-if="showAuthenticationType">
            <label for="authenticationType" class="col-xs-5 col-sm-5"><cv:msg key="label.authentication" bundle="storage" /></label>
            <div class="col-xs-7 col-sm-7">
                <select id="authenticationType" name="authenticationType" data-ng-model="configureAuthCloud.storageAuthenticationType"
                        data-ng-change="authenticationChanged()"
                        data-ng-options="cloudAuthType as cloudAuthType.displayName | cvLoc for cloudAuthType in storageAuthenticationTypeList | orderBy:'id' track by cloudAuthType.id" required
                        data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.authenticationType)}">
                    <option value=""><cv:msg key="placeholder.storageClass" bundle="storage" /></option>
                </select>
                <span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.cloudAuthType)"><cv:msg key="error.cloudType" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group" ng-if="showAuthenticationType && configureAuthCloud.storageAuthenticationType.showARNRole">
            <label for="arnRole" class="col-xs-5 col-sm-5">
                <cv:msg key="label.arnRole" bundle="storage"/>
            </label>
            <div class="col-xs-7 col-sm-7">
                <input id="arnRole" type="text" name="arnRole" data-ng-model="configureAuthCloud.arnRole" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.arnRole.$error.required && cv.storageForm.needsAttention(storageForm.arnRole)"><cv:msg key="error.arnRole.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group" data-ng-if="configureAuthCloud.showIAMVMLabels || configureAuthCloud.showIAMADCMLabels ">
            <label for="accountName" class="col-xs-5 col-sm-5">
                <cv:msg key="label.accountName" bundle="storage"/>
            </label>
            <div class="col-xs-7 col-sm-7">
                <input id="accountName" type="text" name="accountName" data-ng-model="configureAuthCloud.accountName" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.accountName.$error.required && cv.storageForm.needsAttention(storageForm.accountName)"><cv:msg key="error.AccountName.required" bundle="storage"/></span>
            </div>
        </div>
        <div data-ng-class="{'panel-body no-padding' : showSwitchToCM}" data-ng-if="showSwitchToCM">
            <div data-ng-if="!showCredentialDropDown">
                <div class="form-group">
                    <label for="userName" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_UserName | cvLoc}}</label>
                    <div class="col-xs-7 col-sm-7">
                        <input id="userName" type="text" name="UserName" data-ng-model="libraryInfo.loginName" maxlength="128"	data-ng-required="!showCredentialDropDown">
                        <span class="help-block" data-ng-show="storageForm.UserName.$error.required && cv.storageForm.needsAttention(storageForm.UserName)"><cv:msg key="error.UserName.required" bundle="storage"/></span>
                    </div>
                </div>
                <div class="form-group">
                    <label for="password" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Password | cvLoc}}</label>
                    <div class="col-xs-7 col-sm-7">
                        <input id="password" type="password" name="Password" data-ng-model="libraryInfo.password" maxlength="128" data-ng-required="!showCredentialDropDown"/>
                        <span class="help-block" data-ng-show="storageForm.Password.$error.required && cv.storageForm.needsAttention(storageForm.Password)"><cv:msg key="error.Password.required" bundle="storage"/></span>
                    </div>
                </div>
            </div>
            <div data-ng-if="showCredentialDropDown">
                <div class="form-group margin-bottom-10">
                   <label for="credential" class="col-xs-5 col-sm-5"> <cv:msg key="label.credentialName" bundle="storage"/></label>
                    <div class="col-xs-7 col-sm-7">
                        <select-with-create-button
                            select-id="credential"
                            select-name="credential"
                            key-label="credentialName"
                            key-id="credentialId"
                            option-list="savedCredentials"
                            on-change-option="onChangeCredential"
                            selected-option="libraryInfo.credentialToSave"
                            on-click-create-button="openCreateCredentialModal"
                            has-error="cv.storageForm.needsAttention(storageForm.credential)"
                            class="no-float-auto tile-large-width"
                            placeholder='<cv:msg key="placeholder.credential" bundle="storage"/>'
                            edit-disabled="libraryInfo.credentialToSave.length === 0"
                            on-click-edit-button="openEditCredentialModal"
                            is-credential="true">
                        </select-with-create-button>
                        <span class="help-block" data-ng-show="credentialNotSelectedError">
                            <cv:msg key="error.credential.required" bundle="storage"/>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for="bucket" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Bucket | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input id="bucket" type="text" name="Bucket" data-ng-model="libraryInfo.mountPath.name" maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.Bucket.$error.required && cv.storageForm.needsAttention(storageForm.Bucket)">{{cloudTypeLables[libraryInfo.serverType.id].error_Bucket | cvLoc}}</span>
            </div>
        </div>
        <div class="form-group" data-ng-if="showStorageClass">
            <label for="storageClass" class="col-xs-5 col-sm-5"><cv:msg key="label.storageClass" bundle="storage" /></label>
            <div class="col-xs-7 col-sm-7">
                <select id="storageClass" name="storageClass" data-ng-model="libraryInfo.storageClass"
                        data-ng-options="storageClass as storageClass.displayName | cvLoc for storageClass in storageClassList | orderBy:'id' track by storageClass.id" required
                        data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.cloudType)}">
                    <option value=""><cv:msg key="placeholder.storageClass" bundle="storage" /></option>
                </select>
                <span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.cloudType)"><cv:msg key="error.cloudType" bundle="storage"/></span>
            </div>
        </div>
    </div>
    <div class="full-width flex-column" data-ng-if="libraryInfo.serverType.id == ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE
    || libraryInfo.serverType.id == ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE">
        <div class="form-group">
            <label for="serviceHost" class="col-xs-5 col-sm-5">
                <cv:msg key="label.serviceHost" bundle="storage"/>
            </label>
            <div class="col-xs-7 col-sm-7">
                <input id="serviceHost" type="text" name="ServiceHost" data-ng-model="libraryInfo.serviceHost" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.ServiceHost.$error.required && cv.storageForm.needsAttention(storageForm.ServiceHost)"><cv:msg key="error.ServiceHost.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label6 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.TenancyOCID)}" type="text" name="TenancyOCID" data-ng-model="configureCloudLibrary.TenancyOCID" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.TenancyOCID.$error.required && cv.storageForm.needsAttention(storageForm.TenancyOCID)"><cv:msg key="error.TenancyOCID.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label7 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.UserOCID)}" type="text" name="UserOCID" data-ng-model="configureCloudLibrary.UserOCID" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.UserOCID.$error.required && cv.storageForm.needsAttention(storageForm.UserOCID)"><cv:msg key="error.UserOCID.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label8 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.KeysFingerprint)}" type="text" name="KeysFingerprint" data-ng-model="configureCloudLibrary.KeysFingerprint" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.KeysFingerprint.$error.required && cv.storageForm.needsAttention(storageForm.KeysFingerprint)"><cv:msg key="error.KeysFingerprint.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label9 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input type="text" name="CompartmentName" data-ng-model="configureCloudLibrary.CompartmentName" maxlength="128"/>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label10 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.PemKeyFilename)}" type="text" name="PemKeyFilename" data-ng-model="configureCloudLibrary.PemKeyFilename" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.PemKeyFilename.$error.required && cv.storageForm.needsAttention(storageForm.PemKeyFilename)"><cv:msg key="error.PemKeyFilename.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label11 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.Password)}" type="password" name="Password" data-ng-model="libraryInfo.password" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.Password.$error.required && cv.storageForm.needsAttention(storageForm.Password)"><cv:msg key="error.PrivateKeysPassword.required" bundle="storage"/></span>
            </div>
        </div>
        <div class="form-group">
            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label12 | cvLoc}}</label>
            <div class="col-xs-7 col-sm-7">
                <input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.Bucket)}" type="text" name="Bucket" data-ng-model="libraryInfo.mountPath.name" required maxlength="128"/>
                <span class="help-block" data-ng-show="storageForm.Bucket.$error.required && cv.storageForm.needsAttention(storageForm.Bucket)"><cv:msg key="error.bucket.required" bundle="storage"/></span>
            </div>
        </div>
    </div>
    <div class="full-width flex-column" data-ng-if="libraryInfo.serverType.id == METALLIC_STORAGE">
		<div class="form-group" data-ng-if="action=='editMP' || (action=='addCloudMP' && licenseTypeList.length > 1)">
			<label class="col-xs-5 col-sm-5" for="licenseType"><cv:msg key="label.license" bundle="storage"/></label>
			<div data-ng-class ="{'col-xs-7 col-sm-7 text-align-left' : action=='editMP'}">
				<div data-ng-if="action=='editMP'" class="toggle-control padding-bottom-10">{{metallicStorageInfo.licenseType}}</div>
		        <div class="col-xs-7 col-sm-7 text-align-left" data-ng-if="action=='addCloudMP' && licenseTypeList.length > 1">
					<isteven-multi-select
						directive-id="licenseTypeList"
						input-model="licenseTypeList"
						output-model="metallicStorageInfo.licenseType"
						button-label="label"
						item-label="label"
						id="licenseType"
						tick-property="selected"
						class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
						helper-elements="none"
						selection-mode="single"
						on-item-click="setMetallicLicenseType(data)">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="inputRequired.license"><cv:msg key="error.license" bundle="storage"/></span>
		       	</div>
			</div>
		</div>
		<div class="form-group">
			<label for="region" class="col-xs-5 col-sm-5"><cv:msg key="label.location" bundle="storage"/></label>
			<div data-ng-class ="{'col-xs-7 col-sm-7 text-align-left' : action=='editMP'}">
				<div data-ng-if="action=='editMP'" class="toggle-control padding-bottom-10">{{metallicStorageInfo.region}}</div>
		        <div class="col-xs-7 col-sm-7 text-align-left" data-ng-if="action=='addCloudMP'">
					<isteven-multi-select
						directive-id="regionList"
						input-model="regionList"
						output-model="metallicStorageInfo.region"
						button-label="label"
						item-label="label"
						id="region"
						tick-property="selected"
						class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
						helper-elements="none"
						selection-mode="single"
						on-item-click="setMetallicRegion(data)">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="inputRequired.region"><cv:msg key="error.region" bundle="storage"/></span>
		       	</div>
			</div>
		</div>
		<div class="form-group" data-ng-if="action=='editMP' || (action=='addCloudMP' && showMetallicInputs.storageClass)">
			<label for="storageClass" class="col-xs-5 col-sm-5"><cv:msg key="label.storageClass" bundle="storage"/></label>
			<div data-ng-class ="{'col-xs-7 col-sm-7 text-align-left' : action=='editMP'}">
				<div data-ng-if="action=='editMP'" class="toggle-control padding-bottom-10">{{metallicStorageInfo.storageClass}}</div>
		        <div class="col-xs-7 col-sm-7 text-align-left" data-ng-if="(action=='addCloudMP' && showMetallicInputs.storageClass)">
					<isteven-multi-select
						directive-id="storageClassList"
						input-model="storageClassList"
						output-model="metallicStorageInfo.storageClass"
						button-label="label"
						item-label="label"
						id="storageClass"
						tick-property="selected"
						class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
						helper-elements="none"
						selection-mode="single"
						on-item-click="setMetallicStorageClass(data)">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="inputRequired.storageClass"><cv:msg key="error.storageClass" bundle="storage"/></span>
		       	</div>
			</div>
		</div>
		<div class="form-group" data-ng-if="action=='editMP' || (action=='addCloudMP' && showMetallicInputs.replication)">
			<label for="replication" class="col-xs-5 col-sm-5"><cv:msg key="label.replication" bundle="storage"/></label>
			<div data-ng-class ="{'col-xs-7 col-sm-7 text-align-left' : action=='editMP'}">
				<div data-ng-if="action=='editMP'" class="toggle-control padding-bottom-10">{{metallicStorageInfo.replication}}</div>
		        <div class="col-xs-7 col-sm-7 text-align-left" data-ng-if="(action=='addCloudMP' && showMetallicInputs.replication)">
					<isteven-multi-select
						directive-id="replicationList"
						input-model="replicationList"
						output-model="metallicStorageInfo.replication"
						button-label="label"
						item-label="label"
						id="replication"
						tick-property="selected"
						class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
						helper-elements="none"
						selection-mode="single"
						on-item-click="setMetallicReplication(data)">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="inputRequired.replication"><cv:msg key="error.replication" bundle="storage"/></span>
		       	</div>
			</div>
		</div>
    </div>
    <!-- // DDB location start// -->
    <div data-ng-if="((!isCloudStorageForMultipleDDBs && action=='addCloudLib') || isSetup || (isModalFromMultipleDDBGrid && shouldShowDDBLocationSection)) && (libraryInfo.serverType.id !== HPE_CATALYST_STORAGE && libraryInfo.serverType.id !== METALLIC_STORAGE)">
        <div class="form-group text-align-left margin-top-30" data-ng-if="(showSwitchToCM && (!isCloudStorageForMultipleDDBs && !isModalFromMultipleDDBGrid)) || showInputs">
            <toggle-control
            class="margin-right-5 margin-left-15"
                status="showDDBLocation ? 'enabled-activity' : 'disabled-activity'"
                data-ng-click="onToggleUseDDB()"> </toggle-control>
            <span for="partitionPath"><cv:msg key="label.useDeduplication"  bundle="storage" /></span>
        </div>
        <div class="form-group" for="ddbPartitionPath" data-ng-if="showDDBLocationHandler()">
            <div class="col-sm-5 col-xs-5 padding-top-10 text-align-left" data-ng-class="{'padding-left-40': showInputs}">
                <cv-help-text help-label="<cv:msg key="label.deduplicationDBLocation"  bundle="storage" />" help-text="'<cv:msg key='label.ddbPartitionPathHelpText' bundle='storage' />'"/>
            </div>
            <div class="col-xs-7 col-sm-7">
                <div class="input-group">
                    <input type="text" class="indexServerPath"
                    name="ddbPartitionPath" id="partitionPath" data-ng-model="libraryInfo.ddbPartitionPath"
                    data-ng-required="showDDBLocationHandler()" data-ng-pattern='pathPattern.pattern' />
                    <span class="input-group-btn">
                        <button id="addCloudTemplate_button_#8694" class="icon-style cv-material-button browse" type="button" data-ng-click="browseForPartitionPath({isDDBLocation: showDDBLocation})">
                            <div class="cv-material-button-icon cursor-pointer">
                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                            </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
                        </button>
                    </span>
                </div>
                <span class="help-block" data-ng-show="cv.storageForm.needsAttention(storageForm.ddbPartitionPath)"><cv:msg key="error.partitionPathAdd" bundle="storage"/></span>
            </div>
        </div>
    </div>
    <!-- // DDB location end// -->
</div>
