<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>

<span data-ng-if="entityType == 'PLAN_ENTITY'">
	<span class="rpo-tile-labels pageDetailColumn">
		<label class="left-padding"><cv-help-text help-label="<cv:msg key="label.SLA" bundle="profiles" />" help-text="'<cv:msg key="label.sla.helptext" bundle="profiles" />'"></cv-help-text></label>
	</span>
	<span class="pageDetailColumn sla-val-column">
		<span data-ng-if="!slaData.excludeSLA && slaData.level=='SYSTEM_DEFAULT_SLA'">
			<span data-ng-if="!slaData.inheritedSLAString"><cv:msg key="label.usingPlanSLA" bundle="profiles" params="{{slaData.defaultPlanSLA}}" /></span>
			<span data-ng-if="slaData.inheritedSLAString" class="inherited-sla-val" data-ng-bind="slaData.inheritedSLAString"></span>
		</span>
		<span data-ng-if="!slaData.excludeSLA && slaData.level=='SLA_FOR_LAST_N_DAYS'"><cv:msg key="label.customSLAPeriod" bundle="profiles" params="{{slaDaysList['days'+slaData.slaDays]}}" /></span>
		<span data-ng-if="slaData.excludeSLA && slaData.delayInterval <= 0"><cv:msg key="label.excludedFromSLA" bundle="profiles" /></span>
		<span data-ng-if="slaData.excludeSLA && slaData.delayInterval > 0"><cv:msg key="label.includeSLA" bundle="profiles" /> {{slaData.delayInterval*1000 | date : 'MMM dd, yyyy'}}</span>

		<cv-call-out data-ng-if="slaData.excludeSLA && slaData.slaDescription != ''" html-template="excludeRasonTemplate"></cv-call-out>

		<span class="inline-editor-buttons plan-sla-edit-btn">
			<a href="" data-ng-click="editSLA()">
				<span class="inline-editor-button text"><cv:msg key="label.edit" bundle="profiles"/></span>
			</a>
		</span>
	</span>
</span>

<cv-tile-component data-ng-if="entityType == 'CLIENT_GROUP_ENTITY'" data-title="<cv:msg key="label.SLA" bundle="profiles" />" help-text="<cv:msg key="label.sla.helptext" bundle="profiles" />">
	<ul class="list-style-secondary">
		<li class="group">
			<span class="pageDetailColumn">
				<span data-ng-if="!slaData.excludeSLA && slaData.level=='SYSTEM_DEFAULT_SLA'">
					<span data-ng-if="!slaData.inheritedSLAString"><cv:msg key="label.usingPlanSLA" bundle="profiles" params="{{slaData.defaultPlanSLA}}" /></span>
					<span data-ng-if="slaData.inheritedSLAString" class="inherited-sla-val" data-ng-bind="slaData.inheritedSLAString"></span>
				</span>
				<span data-ng-if="!slaData.excludeSLA && slaData.level=='SLA_FOR_LAST_N_DAYS'"><cv:msg key="label.customSLAPeriod" bundle="profiles" params="{{slaDaysList['days'+slaData.slaDays]}}" /></span>
				<span data-ng-if="slaData.excludeSLA && slaData.delayInterval <= 0"><cv:msg key="label.excludedFromSLA" bundle="profiles" /></span>
				<span data-ng-if="slaData.excludeSLA && slaData.delayInterval > 0"><cv:msg key="label.includeSLA" bundle="profiles" /> {{slaData.delayInterval*1000 | date : 'MMM dd, yyyy'}}</span>

				<cv-call-out data-ng-if="slaData.excludeSLA && slaData.slaDescription != ''" html-template="excludeRasonTemplate"></cv-call-out>

				<span class="inline-editor-buttons plan-sla-edit-btn hide">
					<a href="" data-ng-click="editSLA()">
						<span class="inline-editor-button text"><cv:msg key="label.edit" bundle="profiles"/></span>
					</a>
				</span>
			</span>
		</li>
	</ul>
	<div class="page-details-box-links multiLinks">
		<a data-ng-click="editSLA()"><cv:msg key="label.edit" bundle="profiles"/></a>
	</div>
</cv-tile-component>
