<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div>
	<div class="form-horizontal bootstrap-wrapper plan-level-sla">
		<form data-cv-submit="saveSLA()" autocomplete="off">
			<div class="setup-title">
				<h1><cv:msg key="label.editSLA" bundle="profiles"/></h1>
			</div>
			<div class="panel-body">
	 			<div class="form-group col-xs-12 col-lg-12" data-ng-disabled="slaData.excludeSLA">
					<label for="useDefaultSLA">
						<input type="radio" id="useDefaultSLA" name="useDefaultSLA" data-ng-model="slaData.level" value="SYSTEM_DEFAULT_SLA"></input>
						<span><cv:msg key="label.usePlanSLA" bundle="profiles"/></span>
						<span data-ng-if="slaData.inheritedSLAString" class="inherited-sla-val" >&nbsp;({{slaData.inheritedSLAString}})</span>
					</label>
				</div>
				<div class="form-group col-xs-12 col-lg-12" data-ng-disabled="slaData.excludeSLA">
					<label for="slaPeriod">
						<input type="radio" id="slaPeriod" name="slaPeriod" data-ng-model="slaData.level" value="SLA_FOR_LAST_N_DAYS"></input><cv:msg key="label.slaPeriod" bundle="profiles"/>
					</label>
					<%-- <cv-sla-days data-entity-data="slaData.slaDays" data-entity-type="entityType" data-entity-id="entityId"></cv-sla-days> --%>
					<select data-ng-model="slaData.slaDays" id ="slaDays" data-ng-disabled="slaData.level != 'SLA_FOR_LAST_N_DAYS'" class="sla-period">
						<option data-ng-value="1">{{slaDaysList.days1}}</option>
						<option data-ng-value="2">{{slaDaysList.days2}}</option>
						<option data-ng-value="3">{{slaDaysList.days3}}</option>
						<option data-ng-value="5">{{slaDaysList.days5}}</option>
						<option data-ng-value="7">{{slaDaysList.days7}}</option>
						<option data-ng-value="14">{{slaDaysList.days14}}</option>
						<option data-ng-value="30" selected>{{slaDaysList.days30}}</option>
						<option data-ng-value="90">{{slaDaysList.days90}}</option>
					</select>
				</div>
				<div class="form-group col-xs-12 col-lg-12 multi-options">
					<label class="" for="excludeFromSLA"><cv:msg key="label.excludeFromSLA" bundle="profiles"/></label>
					<toggle-control class="excludeFromSLA" status="slaData.excludeSLA" data-ng-click="toggleExcludeSLA()" title="Enable/Disable <cv:msg key="label.excludeFromSLA" bundle="profiles"/>"></toggle-control>

					<div data-ng-if="slaData.excludeSLA">
						<div class="btn-group include-delay" uib-dropdown >
							<a href class="uib-dropdown-toggle optional-text link delay-text" uib-dropdown-toggle >
								{{slaData.delayInterval > 0? uiActivateDelayString : uiEnabledDelayString }}
								<span data-ng-if="slaData.delayInterval > 0" data-ng-bind="(slaData.delayInterval*1000 | date : 'MMM dd, yyyy')"></span>
							</a>
							<ul id="delayInterval" uib-dropdown-menu class="dropdown-menu activity-control-dropdown cv-dropdown-style-2" role="menu">
								<div class="part-scroll">
									<li data-ng-repeat="data in includeEnableList" class="mo-padding">
										<a href="" ng-click="updateDelayIntervel(data)" data-ng-bind="data.label"></a>
									</li>
								</div>
							</ul>
							<div class="input-group calendar-wrapper date-picker">
								<input type ="text" id="customDateId" name="customDateName"
									class="date-box hide" data-datetime-picker="MM-dd-yyyy"
									data-ng-model="custom.cdate"
									data-datepicker-options="custom.dateOptions"
									data-enable-time="false"
									data-show-weeks="false"
									data-when-closed="closingDatePicker(arg)"
									data-is-open="custom.isDatePickerOpen" />
							</div>
						</div>
					</div>
				</div>
				<div class="form-group col-xs-12 col-lg-12" data-ng-if="slaData.excludeSLA">
					<span><cv:msg key="label.excludeReason" bundle="profiles"/></span>
			    	<span class="reason-sec"><textarea id="slaDescription" name="slaDescription" class="full-width" data-ng-model="slaData.slaDescription" ></textarea></span>
				</div>
			</div>
			<div class="modal-footer">
				<button id="planSLA_button_#5374" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="settings" /></button>
				<button id="planSLA_button_#6105" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="settings" /></button>
			</div>
		</form>
	</div>
</div>