<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>

<div class="setup-title"><h1><cv:msg key='header.EditDRConfiguration' bundle='clients' /></h1></div>
<div class="setup-content bootstrap-wrapper padding-15">
    <span class="{{IBMiDRCtrl.serverMessage.type}}" data-ng-bind="IBMiDRCtrl.serverMessage.message"></span>
    <form name="IBMiDRConfigurationForm" cvnovalidate autocomplete="off" data-cv-submit="IBMiDRCtrl.validateIBMIDRSubclient() && IBMiDRCtrl.saveConfiguration()">
        <div class="form-group row">
            <label class="col-xs-12 col-lg-4" for="backupMaxTime"><cv:msg key="label.backupMaxTime" bundle="clients"/></label>
            <div class="col-xs-12 col-lg-8 text-left">
                <input type="number" id="backupMaxTime" name="backupMaxTime" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.backupMaxTime"/>
            </div>
        </div>
        <div class="text-left margin-top-15">
            <cv-toggle toggle-name="notifyuser" toggle-label="label.notifyuser" value="IBMiDRCtrl.ibmiSubclientprop.notifyuser"></cv-toggle>
        </div>
        <div data-ng-show="IBMiDRCtrl.ibmiSubclientprop.notifyuser" class="margin-left-20 margin-bottom-15">
            <div class="form-group row">
                <label class="col-xs-12 col-lg-4" for="notifyDelay"><cv:msg key="label.notifyDelay" bundle="clients"/></label>
                <div class="col-xs-12 col-lg-8 text-left">
                    <input type="number" id="notifyDelay" name="notifyDelay" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.notifyDelay"/>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-xs-12 col-lg-4" for="notifyMessage"><cv:msg key="label.notifyMessage" bundle="clients"/></label>
                <div class="col-xs-12 col-lg-8">
                    <textarea type="text" id="notifyMessage" name="notifyMessage" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.notifyMessage" data-ng-change="IBMiDRCtrl.inputAlertFlags.notifyMessage = false;"></textarea>
                    <span class="help-block" data-ng-show="IBMiDRCtrl.inputAlertFlags.notifyMessage"><cv:msg key="error.notifyMessage" bundle="clients" /></span>
                </div>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-xs-12 col-lg-4" for="SRBootServerDir"><cv:msg key="label.DVDFileFormat" bundle="clients"/> <cv-help-text help-text="IBMiDRCtrl.helpTextDVDFileFormat" use-icon="true" /></label>
            <div class="col-xs-8 col-lg-6">
                <input type="text" id="DVDImageFileFormat" name="DVDImageFileFormat" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.DVDImageFileFormat" />
            </div>
        </div>
        <div class="form-group row">
            <label class="col-xs-12 col-lg-4" for="SRBootServerDir"><cv:msg key="label.SRBootServerDir" bundle="clients"/></label>
            <div class="col-xs-8 col-lg-6">
                <input type="text" id="SRBootServerDir" name="SRBootServerDir" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.SRBootServerDir" data-ng-change="IBMiDRCtrl.inputAlertFlags.SRBootServerDirEmpty = false; IBMiDRCtrl.inputAlertFlags.SRBootServerDirLib=false;IBMiDRCtrl.inputAlertFlags.SRBootServerDirIFS=false;IBMiDRCtrl.inputAlertFlags.SRBootServerDirPath = false;"/>
                <span class="help-block" data-ng-show="IBMiDRCtrl.inputAlertFlags.SRBootServerDirEmpty"><cv:msg key="error.SRBootServerDirEmpty" bundle="clients" /></span>
                <span class="help-block" data-ng-show="IBMiDRCtrl.inputAlertFlags.SRBootServerDirLib"><cv:msg key="error.SRBootServerDirLib" bundle="clients" /></span>
                <span class="help-block" data-ng-show="IBMiDRCtrl.inputAlertFlags.SRBootServerDirIFS"><cv:msg key="error.SRBootServerDirIFS" bundle="clients" /></span>
                <span class="help-block" data-ng-show="IBMiDRCtrl.inputAlertFlags.SRBootServerDirPath"><cv:msg key="error.invalidPath" bundle="clients" /></span>
            </div>
            <div class="col-xs-4 col-lg-2">
                <button id="SRBootServerDirBrowseButton" type="button" class="btn btn-default cvBusyOnAjax float-right margin-top-5" data-ng-click="IBMiDRCtrl.browseCommand('SRBootServerDir')"><cv:msg key="action.browse" bundle="collections" /></button>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-xs-12 col-lg-4" for="userCommand"><cv:msg key="label.commandRestrictedState" bundle="clients"/></label>
            <div class="col-xs-8 col-lg-6">
                <input type="text" id="userCommand" name="userCommand" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.userCommand"/>
            </div>
            <div class="col-xs-4 col-lg-2">
                <button id="userCommandBrowse" type="button" class="btn btn-default cvBusyOnAjax float-right margin-top-5" data-ng-click="IBMiDRCtrl.browseCommand('userCommand')"><cv:msg key="action.browse" bundle="collections" /></button>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-xs-12 col-lg-4" for="userProgram"><cv:msg key="label.userProgram" bundle="clients"/></label>
            <div class="col-xs-8 col-lg-6">
                <input type="text" id="userProgram" name="userProgram" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.userProgram"/>
            </div>
            <div class="col-xs-4 col-lg-2">
                <button id="userProgramBrowseButton" type="button" class="btn btn-default cvBusyOnAjax float-right margin-top-5" data-ng-click="IBMiDRCtrl.browseCommand('userProgram')"><cv:msg key="action.browse" bundle="collections" /></button>
            </div>
        </div>
        <div class="form-group row">
            <label class="col-xs-12 col-lg-4" for="userIPLProgram"><cv:msg key="label.userIPLProgram" bundle="clients"/></label>
            <div class="col-xs-8 col-lg-6">
                <input type="text" id="userIPLProgram" name="userIPLProgram" data-ng-model="IBMiDRCtrl.ibmiSubclientprop.userIPLProgram"/>
            </div>
            <div class="col-xs-4 col-lg-2">
                <button id="userIPLProgramBrowseButton" type="button" class="btn btn-default cvBusyOnAjax float-right margin-top-5" data-ng-click="IBMiDRCtrl.browseCommand('userIPLProgram')"><cv:msg key="action.browse" bundle="collections" /></button>
            </div>
        </div>
        <div class="button-container">
            <button class="btn btn-default cvBusyOnAjax" type="button" ng-click="IBMiDRCtrl.dismissModal()"><cv:msg key="Cancel" bundle="messages" /></button>
            <button class="btn btn-primary cvBusyOnAjax" type="submit"><cv:msg key="Save" bundle="messages" /></button>
        </div>
    </form>
</div>