<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.servers" var="servers"/>
<fmt:bundle basename="localization.schedule">
	<div>
		<div class="setup-title">
			<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
		</div>
		<div class="setup-content backup-options">
			<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<label data-ng-if="subclientName">{{backupSubclientLabel}} : &nbsp;<b>{{subclientName}}</b></label>
			<span data-ng-show="!backupMsg">
				<div class="global-options remove-border-padding">
					<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
				</div>
				
				<div class="global-options remove-border-padding">
					<label data-ng-show="bEnableFullForCloudapps">
						<input type="radio" ng-model="backupType" value="FULL" >
						<fmt:message key="option.full" />
					</label>
					<label data-ng-show="bEnableIncrForCloudApps">
						<input type="radio" ng-model="backupType" value="INCREMENTAL">
						<fmt:message key="option.incremental" />
					</label>
					<!-- 	For OneDrive, Gmail and Gdrive, only, show synth full option when bEnableSynthFullForCloud is set to true -->
					<label class="element-indent-class" data-ng-show="bEnableSynthFullForCloudapps">
						<input type="radio" data-ng-model="backupType" value="SYNTHETIC_FULL">
						<cv:msg key="option.synthfull" bundle="schedule"/>
					</label>
				</div>
				<div class="global-options remove-border-padding padding-top-10">
					<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
				</div>
			</span>
			
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="AmazonRDSBackupOptionsModal_button_#7272" type="button" class="btn btn-primary" data-ng-show="backupMsg" data-ng-click="cancel()"><fmt:message key="OK" /></button> 
			  		<button id="AmazonRDSBackupOptionsModal_button_#0475" type="button" class="btn btn-default setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><fmt:message key="Cancel" /></button> 
			  		<button id="AmazonRDSBackupOptionsModal_button_#5969" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup(collectionId)"><fmt:message key="OK" /></button> 
			  	</fmt:bundle>
			</div>
		</div>
	</div>
</fmt:bundle>