(function() {
	'use strict';

	var acMod = angular.module(
		'acApp',
		appUtil.getAllDeps([
			'vsaApp.server',
			'vsaApp.schedule',
			'acApp.browseForAgents',
			'acApp.users',
			'acApp.userGroup',
			'acApp.jobs',
			'acApp.events',
			'acApp.browse',
			'vsaApp.setup',
			'acApp.storage',
			'acApp.security',
			'acApp.activityControl',
			'acApp.backup',
			'acApp.directives',
			'acApp.logViewer',
			'acApp.commonForAllAgents',
			'acApp.clientGroup',
			'acApp.client',
			'acApp.agent',
			'acApp.backupSet',
			'acApp.instance',
			'acApp.sendLogFileApp',
			'acApp.subclient',
			'acApp.restore',
			'acApp.components',
			'acApp.logViewer',
			'dloApp.profile',
			'acApp.reports',
			'dloApp.server',
			'dloApp.nameServers',
			'dloApp.settings',
			'dloApp.devices',
			'common.plan',
			'dloApp.dashboard',
			'common.allAgents',
			'common.pushInstall',
			'common.addProxy',
			'common.appMigration',
			'common.globalParams',
			'colorpicker.module',
			'mspApp.setup',
			'dloApp.customization',
			'acApp.subscriptions',
			'dbsApp.server',
			'ebsApp.server',
			'common.releaseLicense',
			'common.generatePackage',
			'common.updateSoftware',
			'common.upgradeSoftware',
			'common.repairSoftware',
			'common.uninstallSoftware',
			'common.reconfigureClient',
			'vsaApp.storage',
			'webScaleApp.storagePool',
			'dloApp.setup',
			'vsaApp.setup',
			'acApp.setup',
			'acApp.additionalSettings',
			'dbsApp.setup',
			'ebsApp.setup',
			'compliance.setup',
			'common.setup',
			'as.sortable',
			'cappsApp.cappsClient',
			'cappsApp.cappsClientGAPI',
			'cappsApp.cappsSubClient',
			'cappsApp.directives',
			'cappsApp.restore',
			'cappsApp.backupSet',
			'cappsApp.instance',
			'cappsApp.cappsUtil',
			'cappsApp.cappsClientDetails',
			'vnaApp.config',
			'vnaApp.modalities',
			'cappsApp.setup',
			'cappsGDriveApp.setup',
			'cappsGMailApp.setup',
			'cappsOneDriveApp.setup',
			'acApp.exchange',
			'acApp.nas',
			'exchangeApp.exchClient',
			'exchangeApp.exDbSubClient',
			'exchangeApp.setup',
			'ediscoveryApp',
			'exchangeDagApp.setup',
			'genApp.server',
			'drApp.failover',
			'acApp.archiving',
			'acApp.sharepoint',
			'sharepointApp.setup',
			'acApp.activeDirectory',
			'activeDirectoryApp.setup',
			'acApp.office365ClientSetup',
			'acApp.office365Exchange',
			'acApp.office365Sharepoint',
			'acApp.office365OneDrive',
			'office365ODApp.ODClient',
			'office365ODApp.ODSubclient',
			'acApp.notesDatabase',
			'acApp.mediaAgents',
			'acApp.networkStoreApp',
			'acApp.all.schedule',
			'acApp.sql',
			'vmApp',
			'sharepointApp.setup',
			'policyModule',
			'acApp.navCustomization',
			'acApp.appDesigner',
			'acApp.sqlCloudConfigModule',
			'cappsSqlCloudApp.setup',
			'acApp.fsa',
			'acApp.distributedSystem',
			'acApp.bigData',
			'vsa.virtualMachineBrowse',
			'vsaApp.machineBrowse',
			'acApp.emailTemplates',
			'notesDatabaseApp.setup',
			'acApp.credentialManager',
			'archivingApp.directives',
			'acApp.dashboard',
			'acAppNetworkTopologyModule',
			'acApp.regions',
			'acApp.office365App',
			'office365App.setup',
			'acApp.globalFileSearch',
			'acApp.resourcePool',
			'cloudSubscriptionsSetupModule',
			'cloudStorageApp.server',
			'acApp.restAPIOverview',
			'acApp.gsuiteApp',
			'acApp.disasterRecovery',
			'acApp.formsModule',
			'gitApp.server',
			'acApp.cloudServicesModule',
			'acApp.indexServers',
			'acApp.anomaly',
			'acApp.distributedStorage'
		])
	);

	appUtil.setupApp(acMod);
	acMod.config([
		'$stateProvider',
		'$urlRouterProvider',
		'$qProvider',
		'$locationProvider',
		'DASHBOARD_LINKS',
		function($stateProvider, $urlRouterProvider, $qProvider, $locationProvider, DASHBOARD_LINKS) {
			$qProvider.errorOnUnhandledRejections(false);
			$locationProvider.hashPrefix('');
			var removeParam = function(key, sourceURL) {
				var rtn = sourceURL.split('?')[0],
					param,
					params_arr = [],
					queryString = sourceURL.indexOf('?') !== -1 ? sourceURL.split('?')[1] : '';
				if (queryString !== '') {
					params_arr = queryString.split('&');
					for (var i = params_arr.length - 1; i >= 0; i -= 1) {
						param = params_arr[i].split('=')[0];
						if (param === key) {
							params_arr.splice(i, 1);
						}
					}
					if (params_arr.length >= 1) {
						rtn = rtn + '?' + params_arr.join('&');
					}
				}
				return rtn;
			};
			var defaultPath = cv.nav.defaultPath;
			if (angular.isDefined(defaultPath)) {
				defaultPath = removeParam('_cid', defaultPath);
				defaultPath = removeParam('_cn', defaultPath);
			}

			// Once we have defaultLAndingPage string updated we have to make sure if it has any required parameters or optional parameters.If it has required parameters we need to update the url from the stateToURLMap since we cannot have url with required parameters.It will give hanging UI
			if (!defaultPath.includes('subscriptions') && !defaultPath.includes('/reportDetails')) {
				if (defaultPath.includes(':')) {
					defaultPath = defaultPath.substring(0, defaultPath.indexOf(':'));
				}
				//If url has optional parameters, we remove the optional parameters
				if (defaultPath.includes('?')) {
					defaultPath = defaultPath.substring(0, defaultPath.indexOf('?'));
				}
			}

			// Function to check if at least one solution is completed or not
			var atleastOneSolutionIsCompleted = function() {
				if (angular.isDefined(cv.sessionContext.completedSetups)) {
					var completedSetups = ['CORE_SETUP', 'CORE_SETUP_TENANT_OS'];
					var isAtleastOneNonCoreSetupComplete = false;
					var sessionCompletedSetupsArray = Object.keys(cv.sessionContext.completedSetups);
					for (var setupindex = 0; setupindex < sessionCompletedSetupsArray.length; setupindex++) {
						if (!completedSetups.includes(sessionCompletedSetupsArray[setupindex])) {
							isAtleastOneNonCoreSetupComplete = true;
							break;
						}
					}
					return isAtleastOneNonCoreSetupComplete;
				}
				return false;
			};

			// Handles directing the user to the appropriate default page based upon the following conditions performed in order.
			// 1. If the current user is an tenant user, then he/she will be redirected to the "uservms" page.
			// 2. If the current user is an admin on the commcell level, AND the user did not finish the core setup yet (and the user didn't set in the config to skip the core setup), take the user to the Getting Started page.
			// 3. If the current user has defined a default landing page in his/her user preferences, use that.
			// 4. If the system configuration has defined a default landing page, use that.
			// 5. If the Nav JSON file has defined a default path, use that.
			// 6. Based on the app's OEM ID, use the corresponding dashboard page as the default path.
			// Redirect to getting started page based on following conditions

			var redirectToGettingStarted = function() {
				if (
					(cv.isMspAdmin || cv.isTenantOperator || cv.isTenantAdmin) &&
					(angular.isUndefined(cvApp.globalParams.skipInitialSetup) ||
						cvApp.globalParams.skipInitialSetup !== 'true') &&
					!atleastOneSolutionIsCompleted() &&
					!cv.isCometApp
				) {
					return true;
				}
				return false;
			};

			var bGettingStartedIsPresent = false;

			$urlRouterProvider.otherwise(function() {
				if (!cv.isAdmin && !cv.isMspUser) {
					if (cvConfig.isSaaSSubscriptionsEnabled) {
						return '/managesubscriptions';
					} else if (angular.isDefined(defaultPath)) {
						return defaultPath;
					} else {
						return '/uservms';
					}
				} else if (cvConfig.isSaaSSubscriptionsEnabled) {
					return '/managesubscriptions';
				} else if (bGettingStartedIsPresent && redirectToGettingStarted()) {
					return '/gettingStarted';
				} else {
					if (angular.isDefined(defaultPath)) {
						return defaultPath;
					} else {
						return DASHBOARD_LINKS.OVERVIEW;
					}
				}
			});

			var injectStates = function(route) {
				if (route.state === 'coreSetup') console.log(route);
				if (angular.isArray(route.children)) {
					for (var j = 0; j < route.children.length; j++) {
						injectStates(route.children[j]);
					}
				}
				if (route.ng2 === true) {
					$stateProvider.state(route.state, {
						url: route.url,
						template: ''
					});
				} else {
					var title,
						navRoute = route;
					// Use route state if no cvTitle
					if (!navRoute.pageTitle && !navRoute.cvTitle) {
						if (cv.isCometApp) title = 'Global';
						else title = 'Command Center';
					}

					if (navRoute.state === 'gettingStarted') {
						bGettingStartedIsPresent = true;
					}
					var stateConfig = {
						url: navRoute.url,
						templateUrl: appUtil.appRoot + navRoute.templateUrl,
						controller: navRoute.controller,
						cvBreadcrumbs: navRoute.cvBreadcrumbs,
						pageTitle: navRoute.cvTitle || navRoute.pageTitle || title,
						abstract: navRoute.isAbstract,
						isMultiCommCellAware: navRoute.isMultiCommCellAware,
						reloadOnSearch: angular.isDefined(navRoute.reloadOnSearch) ? navRoute.reloadOnSearch : true,
						showNavItem: navRoute.showNavItem,
						requireCollapsableChildren: navRoute.requireCollapsableChildren,
						isRootNode: navRoute.isRootNode,
						preloadScripts: navRoute.preloadScripts,
						params: navRoute.params
					};

					var kebabCase = function(str) {
						return str
							.replace(/([a-z])([A-Z])/g, '$1-$2')
							.replace(/[\s_]+/g, '-')
							.toLowerCase();
					};

					var spreadOptionsToDirectiveString = function(opts) {
						var attributeStr = '';
						Object.keys(opts).forEach(function(key) {
							attributeStr = attributeStr + ' ' + kebabCase(key) + '="' + opts[key] + '"';
						});
						return attributeStr;
					};

					var mergeObjects = function(obj1, obj2) {
						var objs = [obj1, obj2];
						return objs.reduce(function(r, o) {
							Object.keys(o).forEach(function(k) {
								r[k] = o[k];
							});
							return r;
						}, {});
					};

					if (navRoute.params && navRoute.params.react) {
						var params = navRoute.params;
						var url = navRoute.url;
						var nextParams = mergeObjects(params, { url: url });

						stateConfig.template = '<cv-react-page ' + spreadOptionsToDirectiveString(nextParams) + '></cv-react-page>';
						if (stateConfig.controller) {
							stateConfig.template =
								'<ng-controller ng-controller="' +
								stateConfig.controller +
								'">' +
								stateConfig.template +
								'</ng-controller>';
							delete stateConfig.controller;
						}

						delete nextParams.react;
						delete nextParams.pagePath;
						delete nextParams.url;
						stateConfig.params = nextParams;
					}

					stateConfig.resolve = {};

					//								if (navRoute.bundles) {
					//									stateConfig.resolve = {
					//										ctrl : [ '$ocLazyLoad', function(lazyLoad) {
					//											return lazyLoad.load({
					//												files : navRoute.bundles,
					//												serie : true
					//											});
					//										} ]
					//									}
					//								}
					/**
					 * This updates the session context information for a specific app. TODO: make this more
					 * generic.
					 */
					stateConfig.resolve.data = [
						'$http',
						function($http) {
							if (navRoute.url.toLowerCase().indexOf('setup') !== -1) {
								return $http
									.get('refreshSession.do', {
										params: {
											url: navRoute.url
										}
									})
									.then(function(output) {
										cv.sessionContext = output.data;
									});
							}
						}
					];
					$stateProvider.state(navRoute.state, stateConfig);
				}
			};

			for (var i = 0; i < cv.nav.routes.length; i++) {
				injectStates(cv.nav.routes[i]);
			}

			var isSetupState = function() {
				return (
					window.location.hash.includes('setup') ||
					window.location.hash.includes('Setup') ||
					window.location.hash.includes('processAzureAuthToken') ||
					window.location.hash.includes('oauthCallback')
				);
			};

			//If Company context changes in Tenant Operator and Company doesnot have solutions completed, it will switch to Getting Started page.

			if (!cvConfig.invalidateNavCache && cv.isTenantAdmin && !atleastOneSolutionIsCompleted() && !isSetupState()) {
				if (bGettingStartedIsPresent) {
					window.location.hash = '#/gettingStarted';
				} else {
					window.location.hash = '#' + defaultPath;
				}
			}

			if (cvConfig.debugMode) {
				/*
				 * Only in DEBUG mode will this page be available to better visualize and interact with user
				 * preferences.
				 */
				$stateProvider.state('userPreferences', {
					url: '/userPreferences',
					templateUrl: appUtil.appRoot + 'modules/userPrefs/partials/preferences.jsp',
					controller: 'userPreferencesController'
				});

				/*
				 * Only in DEBUG mode will this page be available to better visualize and interact with
				 * completed setups.
				 */
				$stateProvider.state('completedSetups', {
					url: '/completedSetups',
					templateUrl: appUtil.appRoot + 'modules/setup/partials/completedSetups.jsp',
					controller: 'completedSetupsController'
				});

				/*
				 * Only in DEBUG mode will this page be available to better visualize and interact with global
				 * parameters.
				 */
				$stateProvider.state('globalParams', {
					url: '/globalParams',
					templateUrl: appUtil.appRoot + 'modules/globalParams/partials/globalParams.jsp',
					controller: 'globalParamsController as globalParamsController'
				});

				$stateProvider.state('components', {
					url: '/components',
					templateUrl: appUtil.appRoot + 'component-ref/partials/componentLib.jsp',
					controller: 'componentLibController'
				});
			}
		}
	]);
})();
