"use strict";

window.uploadAjaxRequests = new Array();

var FormUploadOps = (function(){
	
function addNewFile(currentInput, curFile, index) {
	Forms.addFieldVal("file" + index + "_" + currentInput.inputName + "_destPath",encodeURIComponent(Forms.getDestPathOfCurrInput(currentInput.inputName) + curFile.name));
	Forms.addFieldVal("file" + index + "_" + currentInput.inputName + "_size", curFile.size);
	Forms.addFieldVal("file" + index + "_" + currentInput.inputName + "_fileName",encodeURIComponent(curFile.name));
	Forms.addFieldVal(currentInput.inputName, "file" + index);
	Forms.addFileToList(curFile);
}

function getFilePreventionStatus(e) {

	var containers = [ "fileType", "wfupload-draggable-area", "upload-selected-files", "upload-list" ];
	var $tagNames = [ "span", "h3" ];

	var enableOp = false;
	if ($tagNames.indexOf(e.target.tagName.toLowerCase()) != -1) {
		var $parent = $(e.target);
		jQuery.each(containers, function() {
			if ($parent.parents("." + this.trim()).length > 0) {
				enableOp = true;
				return false;
			}
		});
	} else {
		var $classList = e.target.classList;
		var $desiredClass = undefined;
		jQuery.each($classList, function() {
			$desiredClass = this.trim();
			if (containers.indexOf($desiredClass) != -1) {
				enableOp = true;
				return false;
			}
		});
	}
	return enableOp;
}

function addFilePreventListeners() {

	var $document = $(document.body);

	$document.off("dragover");
	$document.on("dragover", function(e) {
		e.stopPropagation();
		e.preventDefault();
		return getFilePreventionStatus(e);
	});

	$document.off("drop");
	$document.on("drop", function(e) {
		e.stopPropagation();
		e.preventDefault();
		return getFilePreventionStatus(e);
	});

}

function addFilesToFormData(_changeCallBackFunc,multipleFilesAllowed,currentInputFiles,inputName){
	
	var filesToUpload = [];
	var wfInputEntryFileUploadMap = Forms.getFileUploadMap();
	
	jQuery.each(wfInputEntryFileUploadMap[inputName],function(key,value){
		filesToUpload.push(value);
	}); 
	
	
	if(multipleFilesAllowed == "true"){
		_changeCallBackFunc(filesToUpload);
	}
	else
	{
		_changeCallBackFunc(filesToUpload[0]);
	}
}


function removeFilesFromFormData(inputName,removeAllFiles,fileToRemove,multipleFilesAllowed,_removeFileCallBack,_changeCallBackFunc){
	if(removeAllFiles){
		_changeCallBackFunc(undefined);
	}
	else if(fileToRemove)
	{	
		var indexOfFile = -1;
		if(multipleFilesAllowed == "true"){
			$(FormOps.getFormData()[inputName]).each(function(index){
				if(this.name == fileToRemove){
					indexOfFile = index;
					return;
				}
			});
			if(indexOfFile > -1){
				_removeFileCallBack(indexOfFile);
			}
				
		}
		else
		{
			_removeFileCallBack(undefined);			
		}
	}
}


function postFileClickMessage(fileInfo){
	window.postMessage(JSON.stringify({event:"onFileClick",payLoad:fileInfo}),"*");
}
function showCurrentInputFiles(_changeCallBackFunc,$container, inputName, currentInputFiles,_removeFileCallBack,defaultFiles,inputProps) {

		var noOfFiles = 0;
		var curRow = "";
		var wfInputEntryFileUploadMap = Forms.getFileUploadMap();
		var fileInfoMap = wfInputEntryFileUploadMap[inputName];
		var fileInfoDefaultFilesMap = wfInputEntryFileUploadMap[inputName + "_defaultFiles"];
		var inputJSON = {};
		inputJSON["inputName"] = inputName;
		inputJSON["isDefaultFile"] = false;
		
		var isDuplicateFile = false;
		
	if(Forms.isAppTableFormReq() && defaultFiles && defaultFiles.length > 0)
	{
			jQuery.each(defaultFiles, function(index) {
				var curFile = defaultFiles[index];
				if(curFile){
				if(curFile.markedForDeletion == undefined || curFile.markedForDeletion != true){
			if (fileInfoMap[curFile.name] == undefined) {
				inputJSON["fileName"] = curFile.name;
					inputJSON["isDefaultFile"] = true;
					fileInfoDefaultFilesMap[curFile.name] = curFile;
					inputJSON["filePath"] = inputProps.uploadMetaInfo.postParams.actualFilePath + "/" + Forms.getCurrentInputForm().destPath;
					inputJSON["shareId"] = inputProps.uploadMetaInfo.postParams.shareFolderId;
					inputJSON["size"] = curFile.size;
				curRow = Forms.getHtml(inputJSON, Forms.templateClass[SELECTED_FILEROW_PREVIEW_TEMPLATE]);
				$container.prepend(curRow);
				noOfFiles++;
			} else {
				isDuplicateFile = true;
			}
			}
			}
		});
		
		$(".wfPreviewFile").off("click").on("click",function(e){
			e.preventDefault();
			var pathFile =  $(this).attr("data-filePath")+"/" + $(this).attr("data-fileName");
			
			if(!Forms.isMobileView()){
				pathFile = pathFile.replace(/\//g,"%5C");
				var fileInfo = {shareId:parseInt($(this).attr("data-shareId")),pathFile:pathFile,name:$(this).attr("data-fileName"),size:$(this).attr("data-size")};
				openAppStudioFile(fileInfo);
			}
			else
			{
				var fileInfo = {shareId:parseInt($(this).attr("data-shareId")),pathFile:pathFile,name:$(this).attr("data-fileName"),size:$(this).attr("data-size")};
				postFileClickMessage(fileInfo);
			}
			return false;
		});
	}
		
	if (currentInputFiles.length > 0) {
		jQuery.each(currentInputFiles, function(index) {
			var curFile = currentInputFiles[index];
				if (fileInfoMap[curFile.name] == undefined) {
				if(fileInfoDefaultFilesMap[curFile.name]){
					delete fileInfoDefaultFilesMap[curFile.name];					
					$("#" + inputName + "selectedFilesArea").find("[data-filename='" + curFile.name + "']").remove();
					noOfFiles--;
				}
					
					inputJSON["fileName"] = curFile.name;
				fileInfoMap[curFile.name] = curFile;
					curRow = Forms.getHtml(inputJSON, Forms.templateClass[SELECTED_FILEROW_TEMPLATE]);
					$container.prepend(curRow);
					noOfFiles++;
				} else {
					isDuplicateFile = true;
				}
			});
		}
		
		
		if (isDuplicateFile) {
			var errorMsg = wf_localMsg.duplicateFileWarningMsg;
			showError(errorMsg);
		}

		wfInputEntryFileUploadMap[inputName] = fileInfoMap;
		Forms.setFileUploadMap(wfInputEntryFileUploadMap);
		
		addFilesToFormData(_changeCallBackFunc,$("#" + inputName + "DragArea").attr("data-multiple"),currentInputFiles,inputName);
		
		var $fileCount = $container.parents(".upload-selected-files").find(".upload-num-files");
		var totalCount = parseInt($fileCount.html()) + noOfFiles;
		$fileCount.html(totalCount);

		$(".upload-list-item").off("click");
		$(".upload-list-item").on("click", function(e) {
			e.preventDefault();
			var isDeletionAllowed = $(e.target).attr("data-cross");
			if (isDeletionAllowed != undefined && isDeletionAllowed == "true") {
				var curInputName = $(this).attr("data-inputName");
				var fileName = $(this).attr("data-fileName");
				var isDefaultFile = $(this).attr("data-defaultFile");
				var curWfFileUploadMap = Forms.getFileUploadMap();
				
				if(isDefaultFile == "true")
					curWfFileUploadMap[curInputName + "_defaultFiles"][fileName]["markedForDeletion"] = true;
				else
					delete curWfFileUploadMap[curInputName][fileName];
				Forms.setFileUploadMap(curWfFileUploadMap);
				var $fileNum = $(this).parents(".upload-selected-files").find(".upload-num-files");
				$(this).remove();
				var curFileCount = parseInt($.trim($fileNum.html())) - 1;

				var isMultiple = $("#" + curInputName + "DragArea").attr("data-multiple");
				if (isMultiple == "false") {
					addFileListeners(curInputName);
				}
	
				if(isDefaultFile == "false")
					removeFilesFromFormData(curInputName,false,fileName,isMultiple,_removeFileCallBack,_changeCallBackFunc);

				if (curFileCount == 0) {
					$("#" + curInputName).val("");
					$("#" + curInputName + "WidgetArea").show();
					$("#" + curInputName + "selectedFilesArea").hide();
				}
				$fileNum.html(curFileCount);
			}
		});
		
	$(".clearFiles").off("click");
	$(".clearFiles").on("click", function(e) {
		e.preventDefault();
		var curInputName = $(this).attr("data-inputName");
		var $selectedFilesArea = $(this).parents(".upload-selected-files");
		var $fileNum = $selectedFilesArea.find(".upload-num-files");
		var curWfFileUploadMap = Forms.getFileUploadMap();
		delete curWfFileUploadMap[curInputName];
		delete curWfFileUploadMap[curInputName + "_defaultFiles"];
		Forms.setFileUploadMap(curWfFileUploadMap);
		removeFilesFromFormData(curInputName,true,undefined,undefined,_removeFileCallBack,_changeCallBackFunc);
		
		var isMultiple = $("#" + curInputName + "DragArea").attr("data-multiple");
		if (isMultiple == "false") {
			addFileListeners(curInputName);
		}

		$("#" + curInputName).val("");
		$selectedFilesArea.find(".upload-list").empty();
		$fileNum.html(0);
		$("#" + curInputName + "WidgetArea").show();
		$("#" + curInputName + "selectedFilesArea").hide();
	});

}

function showError(errorMessage){
	var errorList = [];
	errorList.push(errorMessage);
	FormOps.showErrorMessages(errorList);
}

function showErrorIfAlreadyHavingFile($fileNum, curSelectedFiles, inputName, displaName) {
	if ((parseInt($.trim($fileNum.html())) + curSelectedFiles) > 1) {
		var errorMessage = wf_localMsg.multipleFileUploadError + " " + displaName;
		showError(errorMessage);
		return true;
	}
	return false;
}

function switchOffDragDropListeners(desiredInputId) {
	$(desiredInputId).off('dragenter');
	$(desiredInputId).off('dragover');
	$(desiredInputId).off('dragleave');
	$(desiredInputId).off('drop');

}

function initializeCurInputFileControlState(inputObj, isInitial) {

	var isMultiple = inputObj.isMultiple;
	var fileCount = inputObj.fileCount;
	var inputName = inputObj.inputName;
	var $fileNum = inputObj.fileNum;
	var displayName = inputObj.displayName;
	var selectedFilesArea = inputObj.selectedFilesArea;

	if (isMultiple == "false") {
		if (showErrorIfAlreadyHavingFile($fileNum, fileCount, inputName, displayName)) {
			return false;
		} else {
			$("#" + inputName + "WidgetArea").css("display", "none");
			//switchOffDragDropListeners(desiredInputId);
		}
	}

	$(selectedFilesArea).show();

	return true;
}

function addFileListeners(_changeCallBackFunc,inputName,_removeFileCallBack) {
	var desiredInputId = "#" + inputName + "DragArea";
	var selectedFilesArea = "#" + inputName + "selectedFilesArea";
	var $fileNum = $(selectedFilesArea).find(".upload-num-files");
	var displayName = $(desiredInputId).attr("data-displayName");
	var wfInputEntryFileUploadMap = Forms.getFileUploadMap();

	//var $dragArea = $(desiredInputId).find(".wfupload-draggable-area");

	$("#" + inputName + "FilePicker").off("click." + APP_NAMESPACE);
	$("#" + inputName + "FilePicker").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		$("#" + inputName).click();
	});

	$("#" + inputName).off("change." + APP_NAMESPACE);
	$("#" + inputName).on("change." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		var elementFiles = e.target.files;

		var inputObj = {};
		inputObj.isMultiple = $(desiredInputId).attr("data-multiple");
		inputObj.fileCount = elementFiles.length;
		inputObj.inputName = inputName;
		inputObj.fileNum = $fileNum;
		inputObj.displayName = displayName;
		inputObj.selectedFilesArea = selectedFilesArea;

		if (!initializeCurInputFileControlState(inputObj)) {
			$(this).val("");
			return;
		}

		$(".error").hide();
		//$dragArea.hide();
		$(desiredInputId).removeClass("active");
		if (wfInputEntryFileUploadMap[inputName] == undefined) {
			wfInputEntryFileUploadMap[inputName] = {};
			wfInputEntryFileUploadMap[inputName + "_defaultFiles"] = {};
			Forms.setFileUploadMap(wfInputEntryFileUploadMap);
		}
		showCurrentInputFiles(_changeCallBackFunc,$("#" + inputName + "selectedFilesArea .upload-list"), inputName, elementFiles,_removeFileCallBack);
		return true;
	});

	$(desiredInputId).off('dragenter.' + APP_NAMESPACE);
	$(desiredInputId).on('dragenter.' + APP_NAMESPACE, function(e) {
		e.stopPropagation();
		e.preventDefault();
		$(this).addClass("active");
	});

	$(desiredInputId).off('dragover.' + APP_NAMESPACE);
	$(desiredInputId).on('dragover.' + APP_NAMESPACE, function(e) {
		e.stopPropagation();
		e.preventDefault();
		$(this).addClass("active");
	});

	$(desiredInputId).off('dragleave.' + APP_NAMESPACE);
	$(desiredInputId).on('dragleave.' + APP_NAMESPACE, function(e) {
		e.preventDefault();
		$(this).removeClass("active");
	});

	$(desiredInputId).off('drop.' + APP_NAMESPACE);
	$(desiredInputId).on('drop.' + APP_NAMESPACE, function(e) {
		e.preventDefault();
		var elementFiles = e.originalEvent.dataTransfer.files;

		var inputObj = {};
		inputObj.isMultiple = $(this).attr("data-multiple");
		inputObj.fileCount = elementFiles.length;
		inputObj.inputName = inputName;
		inputObj.fileNum = $fileNum;
		inputObj.displayName = displayName;
		inputObj.selectedFilesArea = selectedFilesArea;

		if (!initializeCurInputFileControlState(inputObj)) {
			$(this).removeClass("active");
			return;
		}
		//$dragArea.hide();
		$(this).removeClass("active");

		$(".error").hide();
		
		
		if (wfInputEntryFileUploadMap[inputName] == undefined) {
			wfInputEntryFileUploadMap[inputName] = {};
			wfInputEntryFileUploadMap[inputName + "_defaultFiles"] = {};
			Forms.setFileUploadMap(wfInputEntryFileUploadMap);
		}
		showCurrentInputFiles(_changeCallBackFunc,$("#" + inputName + "selectedFilesArea .upload-list"), inputName, elementFiles,_removeFileCallBack);
	});
}

function initializeControlWithDefaultValues(inputName,formData,_changeCallBackFunc,_removeFileCallBack,defaultFiles,inputProps) {
	
		var isWizardActivity = false;
		var currentResp = Forms.getCurrentResp();
		
		if(Forms.isAppTableFormReq() && formData){
			defaultFiles = JSON.parse(formData);
			formData = undefined;
		}
				
		if (!$.isEmptyObject(currentResp) && !$.isEmptyObject(currentResp.response)) {
			isWizardActivity = currentResp.response.isWizardActivity;
			isWizardActivity = !($.isEmptyObject(isWizardActivity)) ? isWizardActivity : false;
		}
			
		var wfInputEntryFileUploadMap = Forms.getFileUploadMap();
			
			var showFileControl = false;
			var inputFieldFiles = [];

			if (formData) {
				var selectedFileMap = formData;
				if (!$.isEmptyObject(selectedFileMap)) {

					showFileControl	= true;
					
					if(Array.isArray(formData)){
						jQuery.each(selectedFileMap, function(index) {
							inputFieldFiles.push(value);
						});
					}
					else
					{
						inputFieldFiles.push(selectedFileMap);
					}
				}
			}
				
				if(defaultFiles && defaultFiles.length > 0){
					showFileControl	= true;
				}
				
				if(showFileControl === true){				
					wfInputEntryFileUploadMap[inputName] = {}; //Clearing this as these files will be added in the map in showCurrentInputFiles method
					wfInputEntryFileUploadMap[inputName + "_defaultFiles"] = {};
					Forms.setFileUploadMap(wfInputEntryFileUploadMap);

					var desiredInputId = "#" + inputName + "DragArea";
					var selectedFilesArea = "#" + inputName + "selectedFilesArea";
					var $fileNum = $(selectedFilesArea).find(".upload-num-files");
					var displayName = $(desiredInputId).attr("data-displayName");

					var inputObj = {};
					inputObj.isMultiple = $(desiredInputId).attr("data-multiple");
					inputObj.fileCount = inputFieldFiles.length;
					inputObj.inputName = inputName;
					inputObj.fileNum = $fileNum;
					inputObj.displayName = displayName;
					inputObj.selectedFilesArea = selectedFilesArea;

					if (!initializeCurInputFileControlState(inputObj)) {
						return;
					}
					showCurrentInputFiles(_changeCallBackFunc,$("#" + inputName + "selectedFilesArea .upload-list"),inputName,inputFieldFiles,_removeFileCallBack,defaultFiles,inputProps);				
			}
			else
			{
				wfInputEntryFileUploadMap[inputName] = {};
				wfInputEntryFileUploadMap[inputName + "_defaultFiles"] = {};
				Forms.setFileUploadMap(wfInputEntryFileUploadMap);
			}
			addFileListeners(_changeCallBackFunc,inputName,_removeFileCallBack);
}

return {
	"addFileListeners": addFileListeners,
	"addNewFile": addNewFile,
	"addFilePreventListeners": addFilePreventListeners,
	"initializeControlWithDefaultValues": initializeControlWithDefaultValues
}
	
})();
