<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
<cv:cvEnum name="Ida.ExchangeVersion"></cv:cvEnum>
</script>

<div class="float-right row" id="browseServer">
	<div class="toolbar">
		<div id="toolbar-menu-container" class="toolbar-menu-container">
			<ul id="toolbar-menu"></ul>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-xs-12  flex-detail-header">
		<h1 class="float-left ng-binding"><img src="img/exchange-online.svg" class="office365-header-image"/><span class="margin-left-10" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.displayName"></span></h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12"><span class="server-message {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span></div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="mailboxGeneralTile" data-title='<cv:msg key="header.general" bundle="exchange" />'>
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.mailboxName" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.displayName"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.mailboxSMTPAddress" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.smtpAdrress"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.mailboxPlan" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.plan.planName"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.mailboxType" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.msExchRecipientTypeDetails"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.exchangeVersion" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.formattedExchangeVersion"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.status" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.emailStatus"></span></li>
				<li class="group" ng-if="exchMBDetailsCtrl.mailboxDetails.databaseName"><span class="pageDetailColumn"><cv:msg key="label.databaseName" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.databaseName"></span></li>
				<li class="group" ng-if="exchMBDetailsCtrl.mailboxDetails.createdDate"><span class="pageDetailColumn width-40-percentage"><cv:msg key="label.addedToContentOn" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.createdDate"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="label.lastBackup" bundle="office365" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.formattedlastArchiveJobRanTime"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="header.emailsBackedUp" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.numberOfEmails"></span></li>
				<li class="group"><span class="pageDetailColumn  width-40-percentage"><cv:msg key="header.mailboxSize" bundle="exchange" /></span>
					<span class="pageDetailColumn  width-60-percentage" data-ng-bind="exchMBDetailsCtrl.mailboxDetails.formattedSizeOfMailbox"></span></li>
			</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="exchMBDetailsCtrl.mailboxDetails.isMailboxProcessedYet">
		<cv-backup-history entity="exchMBDetailsCtrl.backupEntity" on-restore="exchMBDetailsCtrl.submitRestoreJob(jobDetails, lastJobTime, createRecoveryPoint)" params="exchMBDetailsCtrl.params" show-no-data-message="true" ng-if="exchMBDetailsCtrl.backupEntity"></cv-backup-history>
	</div>
	<div class="col-md-6" data-ng-if="!exchMBDetailsCtrl.mailboxDetails.isMailboxProcessedYet">
		<cv-tile-component data-title="{{::exchMBDetailsCtrl.calendarTitle}}" data-help-text="{{::exchMBDetailsCtrl.params.helpInfo}}">
			<div>
			   <span class="server-message" ng-bind-html="'<cv:msg key="No_backups_available" bundle="browse"/>'"></span>
			</div>
		 </cv-tile-component>
	</div>
	
</div>