<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
 <div data-ng-if="!exchDbSettingsCtrl.associationsLoaded"	class="ajax-loader-container">
	<span data-cv-loading-spinner data-ng-model="loader"></span>
</div>
<div data-ng-if="exchDbSettingsCtrl.associationsLoaded">
	<div class="row" >
		<div class="col-md-12">
			<h1 class="float-left" data-ng-bind="exchDbSettingsCtrl.heading" data-ng-show="exchDbSettingsCtrl.serverMessage.message==''"></h1>
			<span class="server-message {{exchDbSettingsCtrl.serverMessage.type}}" data-ng-bind="exchDbSettingsCtrl.serverMessage.message"></span>
		</div>
	</div>
	<div>
		<div class="row">
			<div class="col-md-12">
				<ul class="steps group text-center create-profile-steps" data-setup-steps="{{exchDbSettingsCtrl.steps.length}}">
					<li data-ng-repeat="step in exchDbSettingsCtrl.steps"
						class="clickable"
						data-ng-class="{'current': step.step == exchDbSettingsCtrl.currentStep}"
						data-ng-click="exchDbSettingsCtrl.currentStep = $index"><span><a>{{step.name}}</a></span></li>
				</ul>
			</div>
		</div>
		<div data-ng-switch on="exchDbSettingsCtrl.currentStep">
			<div data-ng-switch-when="0">
				<div class="row">
					<div class="col-md-6">
						<cv-tile-component data-ac-id="exchangeDetails-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients"/>' loader="exchDbSettingsCtrl.clientDetails.client">
							<ul class="list-style-secondary">
								<li class="group"><span class="pageDetailColumn"><cv:msg key="label.clientName" bundle="clients" /></span>
									<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.clientDetails.client.displayName"></span></li>
								<li class="group"><span class="pageDetailColumn"><cv:msg key="label.data.serverHostName" bundle="servers" /></span>
									<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.clientDetails.client.clientEntity.hostName"></span></li>
							</ul>
						</cv-tile-component>
						<cv-security-component entity-type='exchDbSettingsCtrl.entityType' generic-entity = 'exchDbSettingsCtrl.genericEntity' associations='exchDbSettingsCtrl.formattedSecurityAssociations' associations-loaded="exchDbSettingsCtrl.associationsLoaded">
						</cv-security-component>
					</div>
					<div class="col-md-6">
						<cv-activity-control-component data-ac-params="exchDbSettingsCtrl.acParams">
						</cv-activity-control-component>
					</div>
				</div>
			</div>
			<div data-ng-switch-when="1">
				<div class="row">
					<div class="col-md-6">
						<!-- Begin General -->
							<cv-tile-component data-ac-id="dagDetails-header_general-exchange" data-title='<cv:msg key="header.general" bundle="exchange"/>' loader="(exchDbSettingsCtrl.clientName && !exchDbSettingsCtrl.showLoaderPseudoClientInfo)">
								<ul class="group list-style-secondary toggle-height">
									<li class="group">
										<span class="pageDetailColumn"><cv:msg key="label.clientName" bundle="exchange" /></span>
										<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.changeNameObj.name"></span>
									</li>
									<li class="group">
										<span class="pageDetailColumn"><cv:msg key="label.adDomainName" bundle="exchange" /></span>
										<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.pseudoClientDetails.nameServer"></span>
									</li>
								</ul>
								<div class="page-details-box-links" data-ng-show="exchDbSettingsCtrl.clientDetails && exchDbSettingsCtrl.pseudoClientDetails">
					                <a href="" data-ng-click="exchDbSettingsCtrl.showEditClientDialog()"><cv:msg key="action.edit" bundle="exchange" />
					                </a>
					            </div>
							</cv-tile-component>
						<!-- End General -->
						<!-- Begin Proxy Details -->
							<cv-tile-component data-ac-id="dagDetails-header_exch_proxy-exchange" data-title='<cv:msg key="header.exch.proxy" bundle="exchange"/>' loader="!exchDbSettingsCtrl.showLoaderPseudoClientInfo">
								<ul class="group list-style-secondary toggle-height">
									<li class="group" data-ng-show="exchDbSettingsCtrl.pseudoClientDetails.proxyDetail.useProxy">
										<span class="pageDetailColumn"><cv:msg key="label.proxyName" bundle="exchange" /></span>
										<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.pseudoClientDetails.proxyDetail.proxyClientForDAGDiscovery.clientName"></span>
									</li>
									<li class="group" data-ng-show="exchDbSettingsCtrl.pseudoClientDetails.proxyDetail.useProxy">
										<span class="pageDetailColumn"><cv:msg key="label.proxy.dag.discovery" bundle="exchange" /></span>
										<span class="pageDetailColumn">
				                            <toggle-control class="{{exchDbSettingsCtrl.useProxyForDagDisc}}" disabled="true" status="exchDbSettingsCtrl.useProxyForDagDisc" data-ng-click=""
				                            	title="<cv:msg key='tooltip.proxy.dag.discovery' bundle='exchange' />" data-ng-show="!exchDbSettingsCtrl.showLoaderPseudoClientInfo">
				                            </toggle-control>
				                        </span>
									</li>
									<li class="group">
										<span class="pageDetailColumn"><cv:msg key="label.dag.servers" bundle="exchange" /></span>
										<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.pseudoClientDetails.dagSetup.dagName"></span>
									</li>
									<li class="group">
										<span class="pageDetailColumn"><cv:msg key="label.member.servers" bundle="exchange" /></span>
										<span class="pageDetailColumn exch-member-servers">
											<ul class="group list-style-secondary">
			 									<li style="padding: 0 0 3px 0;" data-ng-repeat="srv in exchDbSettingsCtrl.formattedMemberServer | limitTo: exchDbSettingsCtrl.memberServerLimit">{{srv.text}}</li>
												<li style="padding: 0 0 3px 0;" data-ng-show="(exchDbSettingsCtrl.formattedMemberServer.length > 3) && (exchDbSettingsCtrl.memberServerLimit !== exchDbSettingsCtrl.formattedMemberServer.length)" class="tile-content-link">
			 										<a href="" data-ng-click="exchDbSettingsCtrl.memberServerLimit = exchDbSettingsCtrl.formattedMemberServer.length"><cv:msg key="label.proxy.servers.more" bundle="exchange" /> (<cv:msg key="label.proxy.servers.count" bundle="exchange" /> {{exchDbSettingsCtrl.formattedMemberServer.length}})</a>
												</li>
											</ul>
										</span>
									</li>
									<li class="group">
										<span class="pageDetailColumn"><cv:msg key="label.exchangeVersion" bundle="exchange" /></span>
										<span class="pageDetailColumn" data-ng-bind="exchDbSettingsCtrl.selectedExchangeVersion"></span>
									</li>
								</ul>
								<div class="page-details-box-links" data-ng-show="exchDbSettingsCtrl.clientDetails && exchDbSettingsCtrl.pseudoClientDetails">
					                <a href="" data-ng-click="exchDbSettingsCtrl.showEditClientDialog()"><cv:msg key="action.edit" bundle="exchange" />
					                </a>
					            </div>
							</cv-tile-component>
						<!-- End Proxy Details -->
					</div>
					<div class="col-md-6">
						<!-- remove plan tile from agent level, since agent level plan is supported in adminconsole yet, have added plan in subclient level -->
						<%-- <cv-client-plan-component data-ng-if="exchDbSettingsCtrl.clientId" client-id="exchDbSettingsCtrl.clientId" plan-id="exchDbSettingsCtrl.planId"
						plan-entity="exchDbSettingsCtrl.planEntity" app-id="exchDbSettingsCtrl.appId"></cv-client-plan-component> --%>
						<!-- Begin Activity Control -->
							<cv-activity-control-component data-ac-params="exchDbSettingsCtrl.acParams"></cv-activity-control-component>
						<!-- End Activity Control -->
						<span data-ng-if="exchDbSettingsCtrl.formattedSecurityAssociations">
							<cv-security-component entity-type='exchDbSettingsCtrl.entityType' generic-entity='exchDbSettingsCtrl.genericEntity' associations='exchDbSettingsCtrl.formattedSecurityAssociations' associations-loaded='exchDbSettingsCtrl.associationsLoaded' data-show-Owners='true'>
							</cv-security-component>
						</span>
					</div>
				</div>
			</div>
			<div data-ng-switch-when="2">
			</div>
		</div>
	</div> 	<!-- end of switch step -->
</div>
