<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvEnum name="App.ExchangeVersion"></cv:cvEnum>
</script>
<div>
	<div class="setup-title">
		<h1>{{ctrl.addEditTitle}}<cv-help-component help-text="{{ctrl.addEditHelpText}}"></cv-help-component></h1>
	</div>
	<div class="setup-content">
	    <span class="serverMessage {{ctrl.addEditMessage.type}}" data-ng-bind="ctrl.addEditMessage.message"></span>
	    <span class="serverMessage {{ctrl.clientsPresentMessage.type}}" data-ng-bind="ctrl.clientsPresentMessage.message"></span>
 		<a data-ng-click="ctrl.showAppForm()" data-ng-show="ctrl.hideForm"><cv:msg key="label.addExchClient" bundle="exchange"/></a>
		<form name="addEditExchClientForm" novalidate data-cv-submit="ctrl.addEditExchClient()" autocomplete="off" data-ng-hide="ctrl.hideForm">
			<div class="cv-modal-wrapper" data-ng-show="!ctrl.isEdit">
				<label for="clientName" class="cv-label"><cv:msg key="label.clientName" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<input type="text" id="clientName" name="clientName" data-ng-model="ctrl.clientDetails.clientName" required  data-ng-disabled="!ctrl.allowToEditServerName"/>
					<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.clientName || cv.addEditExchClientForm.needsAttention(addEditExchClientForm.clientName)"><cv:msg key="error.clientName" bundle="exchange"/></span>
				</div>
			</div>
			<div class="cv-modal-wrapper" data-ng-show="!ctrl.isEdit">
				<label for="planId" class="cv-label"><cv:msg key="label.plan" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<label class="select-label">
						<select name="planId" id="planId" data-ng-options="profile.planSummary.plan.planId as profile.planSummary.plan.planName for profile in ctrl.profileList"
						data-ng-model="ctrl.clientDetails.plan" class="modal-select" required data-ng-init="ctrl.clientDetails.plan = ctrl.profileList[0]">
							<option value=""><cv:msg key="placeholder.plan" bundle="exchange"/></option>
						</select>
					</label>
					<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.plan || cv.addEditExchClientForm.needsAttention(addEditExchClientForm.planId)"><cv:msg key="error.plan" bundle="exchange"/></span>
				</div>
			</div>
			<div class="cv-modal-wrapper">
				<label for="domainName" class="cv-label"><cv:msg key="label.domainName" bundle="exchange"/></label>
				<div class="cv-inline-wrapper exch-typeahead">
					<input type="text" id="domainName" name="domainName"
						data-ng-model="ctrl.clientDetails.domainName"
						data-ng-change="ctrl.restartDiscover()"
						data-uib-typeahead="ns as ns.name for ns in ctrl.nameServerList | filter:{name:$viewValue}"
						data-typeahead-min-length="0"
						data-typeahead-on-select="ctrl.nameServerAutofill($item, $model, $label)"
						required
					/>
					<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.domainName || cv.addEditExchClientForm.needsAttention(addEditExchClientForm.domainName)"><cv:msg key="error.domainName" bundle="exchange"/></span>
				</div>
			</div>
			<div class="cv-modal-wrapper">
				<label for="userName" class="cv-label"><cv:msg key="label.userName" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<input type="text" id="userName" name="userName" data-ng-model="ctrl.clientDetails.userName" required data-ng-change="ctrl.restartDiscover()" />
					<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.userName || cv.addEditExchClientForm.needsAttention(addEditExchClientForm.userName)"><cv:msg key="error.userName" bundle="exchange"/></span>
				</div>
			</div>
			<div class="cv-modal-wrapper">
				<label for="password" class="cv-label"><cv:msg key="label.password" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<input type="password" id="password" name="password" data-ng-model="ctrl.clientDetails.password" autocomplete="new-password" data-ng-change="ctrl.restartDiscover()" />
					<span class="cv-help-block" data-ng-show="!ctrl.isEdit && (ctrl.inputAlerts.password || cv.addEditExchClientForm.needsAttention(addEditExchClientForm.password))"><cv:msg key="error.password" bundle="exchange"/></span>
				</div>
			</div>
			<cv-exchange-proxy client-details="ctrl.clientDetails" proxy-list="ctrl.proxyList" dag-server-list="ctrl.dagServerList" show-dag-servers="ctrl.showDagServers" input-alerts="ctrl.inputAlerts" ></cv-exchange-proxy>
			<div class="cv-modal-wrapper">
				<label for="exchangeVersion" class="cv-label"><cv:msg key="label.exchangeVersion" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<label class="select-label">
						<select name="exchangeVersion" id="exchangeVersion" data-ng-init="ctrl.selectedExchangeVersion = ctrl.exchVersionList[0]" data-ng-options="ev as ev.name for ev in ctrl.exchVersionList  | orderBy: 'name' track by ev.id" data-ng-model="ctrl.selectedExchangeVersion" class="modal-select" required>
							<option value=""><cv:msg key="placeholder.exchangeVersion" bundle="exchange"/></option>
						</select>
					</label>
					<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.exchangeVersion || cv.addEditExchClientForm.needsAttention(addEditExchClientForm.exchangeVersion)"><cv:msg key="error.exchangeVersion" bundle="exchange"/></span>
				</div>
			</div>
			<div class="button-container">
				<button id="exchDbAddEditClient_button_#3667" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="ctrl.addCancel()"> 
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="exchDbAddEditClient_button_#8816" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-show="!ctrl.hideForm && ctrl.clientSetupComplete" data-ng-click="ctrl.skip()"><cv:msg key="Skip" bundle="messages" /></button> 
				<span>
					<button id="exchDbAddEditClient_button_#4361" type="button" class="btn cvBusyOnAjax btn-primary" data-ng-show="!ctrl.showDagServers" data-ng-class="{'busy': ctrl.showDiscoverBusy}" data-ng-click="ctrl.doDAGdiscover()"> 
						<cv:msg key="label.button.discover" bundle="exchange" />
					</button>
				</span>
				<button id="exchDbAddEditClient_button_#8933" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="ctrl.showDagServers"> 
					<cv:msg key="Save" bundle="messages" />
				</button>
			</div>
		</form>
		<div class="button-container centered" data-ng-show="ctrl.hideForm">
			<button id="exchDbAddEditClient_button_#8685" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="ctrl.skip()"><cv:msg key="Continue" bundle="messages" /></button> 
		</div>
	</div>
</div>