<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="setup-title">
		<h1><cv:msg key="heading.editExchangeServers" bundle="exchange" />	</h1>
	</div>
	<form name="editInfrastructureSettingsForm"	data-cv-submit="editExchConnectSettingsCtrl.saveInfo()" novalidate autocomplete="off" class="form-horizontal">
		<div class="modal-body">
			<div class="form-group" ng-if="editExchConnectSettingsCtrl.showExchServer">
				<label for="exchangeServers" class="col-xs-12 col-lg-4"><cv:msg
						key="label.exchangeServers" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<textarea id="exchangeServers" name="exchangeServers"
						class="textarea" spellcheck="false"
						data-ng-model="editExchConnectSettingsCtrl.infraStructureSettings.servers"
						placeholder="<cv:msg key="help.exchangeServers" bundle="exchange"/>"></textarea>
				</div>
			</div>
			<div ng-if="editExchConnectSettingsCtrl.infraStructureSettings.environmentType === editExchConnectSettingsCtrl.exchangeConstants.EnvironmentType.EXCHANGE_ONLINE_ONLY">
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="region"><cv:msg key="label.office365.cloudregion" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<select id="region" name="region" data-ng-model="editExchConnectSettingsCtrl.infraStructureSettings.cloudRegion">
							<option value="DEFAULT" selected="selected"><cv:msg	key="label.defaultRegion" bundle="exchange" /></option>
							<option value="GERMANY"><cv:msg key="label.germany" bundle="exchange" /></option>
							<option value="CHINA"><cv:msg key="label.china" bundle="exchange" /></option>
							<option value="US_GOVERNMENT"><cv:msg key="label.usgovt" bundle="exchange" /></option>
						</select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="applicationId"><cv:msg key="label.applicationId" bundle="exchange"></cv:msg></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" id="applicationId" name="applicationId" data-ng-model="editExchConnectSettingsCtrl.infraStructureSettings.azureDetails.azureAppKeyID" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="secretAccessKey"><cv:msg key="label.secretAccessKey" bundle="exchange"></cv:msg></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" id="secretAccessKey"
							autocomplete="new-password" name="secretAccessKey"
							placeholder="<cv:msg key="label.leaveAzureSecretKeyBlank" bundle="exchange"></cv:msg>"
							data-ng-model="editExchConnectSettingsCtrl.infraStructureSettings.azureDetails.azureAppKeySecret" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="tenantName"><cv:msg key="label.azureDirectoryID" bundle="messages"></cv:msg></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" id="tenantName" name="tenantName" data-ng-model="editExchConnectSettingsCtrl.infraStructureSettings.azureDetails.azureTenantName" />
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="editExchConnectionSettings_button_#6894" type="button" class="btn btn-default cvBusyOnAjax"
				data-ng-click="editExchConnectSettingsCtrl.cancel()">
				<cv:msg key="action.cancel" bundle="exchange" />
			</button>
			<button id="editExchConnectionSettings_button_#4961" type="submit" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="action.save" bundle="exchange" />
			</button>
		</div>
	</form>
</div>