<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
</script>
<div>
	<div class="row bootstrap-wrapper">
		<div
			class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
			<h1 data-ng-if="addMailbox.mailbox.mailboxType === 'user'">
				<span data-ng-if="addMailbox.envType === addMailbox.ENVIRONMENT_TYPE_PARAMS.EXCHANGE_ON_PREMISE">
					<cv:msg key="label.addExchangeMailboxOnPremiseApp" bundle="exchange" />
				</span>
				<span data-ng-if="addMailbox.envType === addMailbox.ENVIRONMENT_TYPE_PARAMS.EXCHANGE_HYBRID">
					<cv:msg key="label.addExchangeMailboxHybridApp" bundle="exchange" />
				</span>
			</h1>
			<h1 data-ng-if="addMailbox.mailbox.mailboxType === 'journal'">
				<cv:msg key="label.addEmailJournalingApp" bundle="exchange" />
				<cv-help-component
					help-text='<cv:msg key="info.createUserMailboxPlan" bundle="exchange" />'></cv-help-component>
			</h1>
			<h1 data-ng-if="addMailbox.mailbox.mailboxType === 'contentStore'">
				<cv:msg key="label.addSmtpJournalingApp" bundle="exchange" />
				<cv-help-component
					help-text='<cv:msg key="info.createUserMailboxPlan" bundle="exchange"/>'></cv-help-component>
			</h1>
			<div data-ng-if="addMailbox.showInfrastructureTab">
				<ul class="steps group text-center create-profile-steps"
					data-setup-steps="3">
					<li
						data-ng-class="{'current': addMailbox.step === 1, 'done': addMailbox.step > 1}"><span><cv:msg
								key="label.generalPane" bundle="exchange" /></span></li>
					<li
						data-ng-class="{'current': addMailbox.step === 2, 'done': addMailbox.step > 2}"><span><cv:msg
								key="label.infrastructurePane" bundle="exchange" /></span></li>
					<li data-ng-if="addMailbox.mailbox.mailboxType !== 'contentStore'"
						data-ng-class="{'current': addMailbox.step === 3}"><span>{{addMailbox.stepLabel}}</span></li>
				</ul>
			</div>
			<div data-ng-if="!addMailbox.showInfrastructureTab">
				<ul class="steps group text-center create-profile-steps"
					data-setup-steps="2">
					<li
						data-ng-class="{'current': addMailbox.step === 1, 'done': addMailbox.step > 2}"><span><cv:msg
								key="label.generalPane" bundle="exchange" /></span></li>
					<li data-ng-if="addMailbox.mailbox.mailboxType !== 'contentStore'"
						data-ng-class="{'current': addMailbox.step === 3}"><span>{{addMailbox.stepLabel}}</span>
				</ul>
			</div>
			<form class="form-horizontal create-mailbox-form" cv-hide-api 
				data-cv-submit="addMailbox.next(addMailboxForm)" novalidate
				name="addMailboxForm" autocomplete="off">
				<div data-ng-switch="addMailbox.step">
					<div data-ng-switch-when="1">
						<!-- Step 1: General -->
						<div class="panel panel-default">
							<div class="panel-body">
								<div class="form-group">
									<label class="col-xs-12 col-lg-4" for="serverName"><cv:msg
											key="label.exchAppName" bundle="exchange" /></label>
									<div class="col-xs-12 col-lg-8">
										<input type="text" name="serverName" id="serverName"
											placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange" />'
											data-ng-disabled="addMailbox.mailbox.disableClientName"
											data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
											data-ng-model="addMailbox.mailbox.attributes.clientName"
											required autofocus />
										<div class="help-block"
											data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.serverName)">
											<cv:msg key="error.noAppName" bundle="exchange" />
										</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-4" for="serverPlan"><cv:msg
											key="label.serverPlan" bundle="exchange" /></label>
									<div class="col-xs-12 col-lg-8">
										<select id="serverPlan" name="serverPlan"
											data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in addMailbox.serverPlanList | orderBy: 'planSummary.plan.planName'"
											required data-ng-model="addMailbox.mailbox.attributes.planId"
											data-ng-change="addMailbox.checkPlanPoolConfiguration()">
											<option value="" disabled selected><cv:msg
													key="label.selectServerPlan" bundle="exchange" /></option>
										</select>
										<div data-ng-if="addMailbox.isInfrastructurePoolConfigured"
											class="text-muted">
											<cv:msg key="label.infrastructureInherited" bundle="exchange" />
										</div>
										<div class="help-block"
											data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.serverPlan)">
											<cv:msg key="error.noServerPlan" bundle="exchange" />
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- End Step 1 -->
					</div>
					<div data-ng-if="addMailbox.showInfrastructureTab">
						<div data-ng-switch-when="2">
							<!-- Step 2: Infrastructure Setting -->
							<div class="panel panel-default">
							<div class="panel-body">
<!-- // radio //-->
<div class="form-group">
	<label class="col-xs-12 col-lg-4" for="newEdgeDrive">
		<cv:msg	key="label.indexServer" bundle="exchange" /> <cv-help-component	help-text='<cv:msg key="info.indexServer" bundle="exchange" />'></cv-help-component>
	</label>
	<div class="col-xs-12 col-lg-8">
		<div class="input-group">
			<isteven-multi-select
				input-model="addMailbox.indexServerList"
				output-model="addMailbox.selectedIndexServerList"
				button-label="mediaAgentName"
				item-label="mediaAgentName"
				selection-mode="single"
				helper-elements="filter"
				max-labels="1"
				on-item-click="addMailbox.processIndexServerSelection()"
				tick-property="selected"
				translation="addMailbox.localLang">
			</isteven-multi-select>
			<div
				class="help-block margin-top-3"
				data-ng-show="addMailboxForm.$submitted"
				data-ng-if="addMailbox.selectedIndexServerList.length === 0"
			>
				<cv:msg key="error.selectIndexServer" bundle="exchange" />
			</div>
			<span class="input-group-btn">
				<button
					class="icon-style cv-material-button browse"
					type="button"
					data-ng-click="addMailbox.createNewIndexServer()"
				>
					<div class="cv-material-button-icon cursor-pointer">
						<svg height="20" id="cv_cc" viewBox="0 0 448 448" width="20" xmlns="http://www.w3.org/2000/svg">
							<path d="m408 184h-136c-4.417969 0-8-3.582031-8-8v-136c0-22.089844-17.910156-40-40-40s-40 17.910156-40 40v136c0 4.417969-3.582031 8-8 8h-136c-22.089844 0-40 17.910156-40 40s17.910156 40 40 40h136c4.417969 0 8 3.582031 8 8v136c0 22.089844 17.910156 40 40 40s40-17.910156 40-40v-136c0-4.417969 3.582031-8 8-8h136c22.089844 0 40-17.910156 40-40s-17.910156-40-40-40zm0 0"/>
						</svg>
					</div>
					<div class="cv-material-button-tooltip">
						<cv:msg key="label.newExchangeIndexServer" bundle="exchange" />
					</div>
				</button>
			</span>
		</div>
	</div>
</div>
							</div><!-- // end panel-body //-->
							</div><!-- // end panel panel-default //-->
							<!--  Index Server -->
							<div class="panel panel-default">
							<div class="panel-body">
<!-- // start new //-->
<!--  Access Nodes -->
<div class="form-group">
	<label class="col-xs-12 col-lg-4" for="accessNodes">
		<cv:msg key="label.accessNodes" bundle="exchange" /> <cv-help-component help-text='<cv:msg key="info.accessNode" bundle="exchange" />'></cv-help-component>
	</label>
	<div class="col-xs-12 col-lg-8">
		<isteven-multi-select input-model="addMailbox.nodeList"
			output-model="addMailbox.mailbox.attributes.memberServers.memberServers"
			button-label="clientName"
			item-label="clientName"
			tick-property="selected"
			class="isteven-multi-select user-group-select"
			id="accessNodes"
			name="accessNodes"
			helper-elements="all none reset filter"
			max-labels="5"
			required translation="addMailbox.localLang"
			group-property="msGroup"></isteven-multi-select>
		<span data-ng-if="addMailboxForm.$submitted" class="help-block" data-ng-show="addMailbox.mailbox.attributes.memberServers.memberServers.length < 1"><cv:msg key="error.selectNodes" bundle="exchange" /></span>
	</div>
</div>
<!--  Job Results Directory -->
<div data-ng-if="addMailbox.mailbox.mailboxType === 'user' || addMailbox.mailbox.mailboxType === 'journal' ">
<div class="form-group">
	<label class="col-xs-12 col-lg-4" for="jobResultDirectory">
		<cv:msg key="label.jobResultsDirectory" bundle="exchange" /> <cv-help-component	help-text='<cv:msg key="info.jobResultsDir" bundle="exchange" />'></cv-help-component>
	</label>
	<div class="col-xs-12 col-lg-8">
	<input type="text" id="jobResultDirectory"
						name="jobResultDirectory"
						required
						placeholder='<cv:msg key="label.help.jobResultsDirectory" bundle="exchange" />'
						data-ng-model="addMailbox.mailbox.attributes.jobResulsDir.path"
						required
						data-ng-pattern="addMailbox.REGEX.WINDOWS_NETWORK_PATH" />
						<div data-ng-if="addMailboxForm.$submitted"
												class="help-block"
												data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.jobResultDirectory)">
												<cv:msg key="error.noJobResultsDirectory" bundle="exchange" />
											</div>
											<div data-ng-if="addMailboxForm.$submitted"
												class="help-block"
												data-ng-show="addMailboxForm.jobResultDirectory.$error.pattern ">
												<cv:msg key="error.invalidNetworkPath" bundle="exchange" />
											</div>
	</div>
</div>
</div>
								</div><!-- // end panel-body //-->
							</div><!-- // end panel panel-default //-->
<div data-ng-if="addMailbox.mailbox.mailboxType === 'user'">
<div class="panel panel-default">
<div class="panel-body">
<div class="form-group">
	<label class="col-xs-12 col-lg-4" for="recallService">
		<cv:msg	key="label.recallService" bundle="exchange" /><span	class="optional-text"><cv:msg key="label.optional" bundle="users" /></span>
															<cv-help-component help-text='<cv:msg key="info.recallService" bundle="exchange" />'></cv-help-component>
	</label>
	<div class="col-xs-12 col-lg-8">
		<input type="text"
				name="recallService"
				id="recallService"
				placeholder='<cv:msg key="label.help.recallService" bundle="exchange" />'
				data-ng-model="addMailbox.mailbox.attributes.recallService" />
		<div class="text-muted"><cv:msg key="label.provideIfYouWantCSEmailView"	bundle="exchange" /></div>
	</div>
</div>
</div><!-- // end panel-body //-->
</div><!-- // end panel panel-default //-->
</div>
						</div> <!-- // end data-ng-switch-when="2" // -->
					</div> <!-- // end  data-ng-if="addMailbox.showInfrastructureTab" // -->
					<!-- End Step 2 -->
					<!-- End of Infrastructure Settings-->
					<!-- Step 3: Connection Settings-->
					<div data-ng-switch-when="3">
						<div data-uib-collapse="true">
							<div class="panel panel-default">
								<div class="panel-body">
									<div class="form-group">
										<label class="col-xs-12 col-lg-4"><cv:msg
												key="label.environmentType" bundle="exchange" /></label>
										<div class="col-xs-12  col-lg-8">
											<div class="radio"
												data-ng-if="addMailbox.showOnPremEnvironment">
												<label><input type="radio" id="onPremises"
													checked="checked"
													data-ng-change="addMailbox.resetServiceAccounts()"
													data-ng-required="addMailbox.mailbox.mailboxType === 'user'"
													data-ng-model="addMailbox.mailbox.attributes.onePassProp.environmentType"
													value="EXCHANGE_ON_PREMISES" name="environmentType" /> <cv:msg
														key="label.onPremises" bundle="exchange" /></label>
												<cv-help-component
													help-text='<cv:msg key="info.onPremises" bundle="exchange"/>'></cv-help-component>
											</div>
											<div class="radio">
												<label><input type="radio"
													id="exchangeOnlineHybrind"
													data-ng-change="addMailbox.resetServiceAccounts()"
													data-ng-required="addMailbox.mailbox.mailboxType === 'user'"
													data-ng-model="addMailbox.mailbox.attributes.onePassProp.environmentType"
													value="EXCHANGE_ONLINE_HYBRID" name="environmentType" /> <cv:msg
														key="label.exchangeOnlineHybrind" bundle="exchange" /></label>
												<cv-help-component
													help-text='<cv:msg key="info.exchangeOnlineHybrind" bundle="exchange"/>'></cv-help-component>
											</div>
											<div class="radio">
												<label><input type="radio"
													data-ng-change="addMailbox.resetServiceAccounts()"
													data-ng-model="addMailbox.mailbox.attributes.onePassProp.environmentType"
													value="EXCHANGE_ONLINE_WITH_ONPREM_AD"
													data-ng-required="addMailbox.mailbox.mailboxType === 'user'"
													id="exchangeOnlineWithOnPremisesAD" name="environmentType" />
													<cv:msg key="label.exchangeOnlineWithOnPremisesAD"
														bundle="exchange" /></label>
												<cv-help-component
													help-text='<cv:msg key="info.exchangeOnlineWithOnPremisesAD" bundle="exchange"/>'></cv-help-component>
											</div>
											<div class="radio" ng-if="addMailbox.showExchangeOnline">
												<label><input type="radio"
													id="exchangeOnlineWithAzureAD" name="environmentType"
													data-ng-change="addMailbox.resetServiceAccounts()"
													data-ng-required="addMailbox.mailbox.mailboxType === 'user'"
													data-ng-model="addMailbox.mailbox.attributes.onePassProp.environmentType"
													value="EXCHANGE_ONLINE_ONLY" /> <cv:msg
														key="label.exchangeOnlineWithAzureAD" bundle="exchange" /></label>
												<cv-help-component
													help-text='<cv:msg key="info.exchangeOnlineWithAzureAD" bundle="exchange" />'></cv-help-component>
											</div>
											<div class="help-block"
												data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.environmentType)">
												<cv:msg key="error.noEnvironmentType" bundle="exchange" />
											</div>
										</div>
									</div>
									<div id="environmentForm"></div>
								</div>
							</div>
						</div>
						<div data-ng-if="addMailbox.mailbox.mailboxType === 'user' && addMailbox.mailbox.attributes.onePassProp.environmentType !== 'EXCHANGE_ON_PREMISES'">
							<div class="panel panel-default">
								<div class="panel-body">
									<div class="form-group">
										<label class="col-xs-12 col-lg-4" for="region"><cv:msg
												key="label.office365.cloudregion" bundle="exchange" /> </label>
										<div class="col-xs-12 col-lg-8">
											<select id="region" name="region" required data-ng-model="addMailbox.mailbox.attributes.onePassProp.cloudRegion">
												<option value="DEFAULT" selected="selected"><cv:msg	key="label.defaultRegion" bundle="exchange" /></option>
												<option value="GERMANY"><cv:msg key="label.germany" bundle="exchange" /></option>
												<option value="CHINA"><cv:msg key="label.china" bundle="exchange" /></option>
												<option value="US_GOVERNMENT"><cv:msg key="label.usgovt" bundle="exchange" /></option>
											</select>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div
							data-ng-if="addMailbox.mailbox.attributes.onePassProp.environmentType !== 'EXCHANGE_ONLINE_ONLY' && addMailbox.mailbox.mailboxType !== 'contentStore'">
							<div class="panel panel-default">
								<div class="panel-body">
									<div class="form-group">
										<label class="col-xs-12 col-lg-4" for="exchangeServers">
											<cv:msg key="label.exchangeServers" bundle="exchange" />
											<br>
											<span
												data-ng-if="addMailbox.envType === addMailbox.ENVIRONMENT_TYPE_PARAMS.EXCHANGE_HYBRID"
												class="optional-text padding-0">
												<cv:msg key="Optional" bundle="messages" />
											</span>
										</label>
										<div class="col-xs-12 col-lg-8">
											<textarea class="exchange-server-textarea" spellcheck="false"
												placeholder="<cv:msg key="placeholder.exchangeServers" bundle="exchange"/>"
												id="exchangeServers" name="exchangeServers" class="textarea"
												data-ng-model="addMailbox.mailbox.attributes.onePassProp.servers"
												data-ng-change="addMailbox.checkHybridExchangeServer()"
												data-ng-list="&#10;" data-ng-trim="false"></textarea>
											<div data-ng-if="addMailboxForm.$submitted"
												class="help-block"
												data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.exchangeServers)">
												<cv:msg key="error.noServerName" bundle="exchange" />
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div
							data-ng-if="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY'">
							<div class="panel panel-default">
								<div class="panel-heading">
									<div class="panel-title">
										<cv:msg key="header.azurAeAppSetting" bundle="exchange" />
									</div>
								</div>
								<div class="panel-body">
									<div class="form-group"
										data-ng-if="!addMailbox.dontUseExchangeOAuth">
										<label class="col-xs-12 col-lg-4" for="commvaultApp"><cv:msg
												key="label.azureAppDetails" bundle="exchange" /></label>
										<div class="col-xs-12 col-lg-8">
											<div class="radio">
												<label><input type="radio" id="commvaultApp"
													name="azureMethod"
													data-ng-required="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY'"
													data-ng-change="addMailbox.selectAzureMethod('commvault')"
													data-ng-model="addMailbox.mailbox.azureMethod"
													value="commvault" /> <cv:msg key="label.useDefaultApp"
														bundle="exchange" /></label>
											</div>
											<div class="radio">
												<label><input type="radio" id="customApp"
													name="azureMethod"
													data-ng-change="addMailbox.selectAzureMethod('custom')"
													data-ng-required="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY'"
													data-ng-model="addMailbox.mailbox.azureMethod"
													value="custom" /> <cv:msg key="label.useCustomApp"
														bundle="exchange" /></label>
											</div>
											<div class="help-block"
												data-ng-show="submitController.needsAttention(formController.azureMethod)">
												<cv:msg key="error.noServerName" bundle="exchange" />
											</div>
										</div>
									</div>
									<div data-uib-collapse="!addMailbox.mailbox.azureMethod">
										<div class="form-group"
											data-ng-if="addMailbox.mailbox.azureMethod !== 'commvault'">
											<label class="col-xs-12 col-lg-4" for="applicationId"><cv:msg
													key="label.applicationId" bundle="exchange"></cv:msg></label>
											<div class="col-xs-12 col-lg-8">
												<input type="text" id="applicationId" name="applicationId"
													placeholder='<cv:msg key="label.help.applicationId" bundle="exchange"/>'
													data-ng-disabled="addMailbox.mailbox.azureMethod !== 'custom'"
													data-ng-required="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY'"
													data-ng-model="addMailbox.mailbox.attributes.onePassProp.azureDetails.azureAppKeyID" />
												<div data-ng-if="addMailboxForm.$submitted"
													class="help-block"
													data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.applicationId)">
													<cv:msg key="label.appIdRequired" bundle="exchange" />
												</div>
											</div>
										</div>
										<div class="form-group"
											data-ng-if="addMailbox.mailbox.azureMethod !== 'commvault'">
											<label class="col-xs-12 col-lg-4" for="secretAccessKey"><cv:msg
													key="label.secretAccessKey" bundle="exchange"></cv:msg></label>
											<div class="col-xs-12 col-lg-8">
												<input type="password" id="secretAccessKey"
													name="secretAccessKey"
													placeholder='<cv:msg key="label.help.secretAccessKey" bundle="exchange"/>'
													data-ng-disabled="addMailbox.mailbox.azureMethod !== 'custom'"
													data-ng-required="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY'"
													data-ng-model="addMailbox.mailbox.attributes.onePassProp.azureDetails.azureAppKeySecret" />
												<div data-ng-if="addMailboxForm.$submitted"
													class="help-block"
													data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.secretAccessKey)">
													<cv:msg key="label.appSecretRequired" bundle="exchange" />
												</div>
											</div>
										</div>
										<div class="form-group">
											<label class="col-xs-12 col-lg-4" for="tenantName"><cv:msg
													key="label.azureDirectoryID" bundle="messages"></cv:msg></label>
											<div class="col-xs-12 col-lg-8">
												<div
													data-ng-class="{'input-group': addMailbox.mailbox.azureMethod === 'commvault'}">
													<input type="text" id="tenantName" name="tenantName"
														placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="messages"/>'
														data-ng-required="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY'"
														data-ng-model="addMailbox.mailbox.attributes.onePassProp.azureDetails.azureTenantName" />
													<span class="input-group-btn"
														data-ng-if="addMailbox.mailbox.azureMethod === 'commvault'">
														<button id="createMailbox_button_#3497" class="btn btn-primary" type="button" 
															data-ng-click="addMailbox.loginToMicrosoftAzure()">
															<cv:msg key="label.signInToAzure" bundle="exchange" />
														</button>
													</span>
												</div>
												<div class="text-muted"
													data-ng-if="addMailbox.mailbox.azureMethod === 'commvault'">
													<cv:msg key="label.canRetrieveThisForYou" bundle="exchange"></cv:msg>
												</div>
												<div data-ng-if="addMailboxForm.$submitted"
													class="help-block"
													data-ng-show="cv.addMailboxForm.needsAttention(addMailboxForm.tenantName)">
													<cv:msg key="label.azureTenantIdRequired" bundle="exchange" />
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!-- Service Accounts -->
						<div class="panel panel-default">
							<div class="panel-body">
								<div class="form-group" ng-if="addMailbox.mailbox.mailboxType === 'user' && addMailbox.mailbox.attributes.onePassProp.environmentType !== addMailbox.ENVIRONMENT_TYPE.EXCHANGE_ON_PREMISES">
									<span class="col-xs-12 col-sm-4"><cv-help-text help-label="label.useModernAuthentication" help-text="help.modernAuth"/></span>
									<span class="col-xs-12 col-sm-6">
										<cv-toggle value="addMailbox.mailbox.attributes.onePassProp.isModernAuthEnabled"
											toggle-model="addMailbox.mailbox.attributes.onePassProp.isModernAuthEnabled"></cv-toggle>
									</span> 
								</div>	
								<div class="form-group" ng-if="addMailbox.mailbox.attributes.onePassProp.isModernAuthEnabled">
									<label class="col-xs-12 col-sm-4" for="azureApps"><cv:msg key="label.addAzureApp" bundle="exchange" /></label>
									<div class="col-xs-12 col-sm-6">
										<span>{{addMailbox.mailbox.attributes.onePassProp.azureAppList.azureApps[0].azureAppId}}</span>
									</div>
									<div class="col-xs-12 col-sm-2" ng-if="addMailbox.mailbox.attributes.onePassProp.azureAppList.azureApps.length === 0">
										<a data-ng-click="addMailbox.addEditAzureAppSettings()"	class="float-right"><cv:msg key="label.add"	bundle="exchange" /></a>
									</div>
									<div class="col-xs-12 col-sm-2" ng-if="addMailbox.mailbox.attributes.onePassProp.azureAppList.azureApps.length !== 0">
										<a data-ng-click="addMailbox.addEditAzureAppSettings(addMailbox.mailbox.attributes.onePassProp.azureAppList.azureApps[0])"	class="float-right"><cv:msg key="label.edit" bundle="alerts" /></a>
									</div>
									<div class="text-muted text-danger incomplete" data-ng-if="addMailbox.mailbox.attributes.onePassProp.azureAppList.azureApps.length === 0 && addMailboxForm.$submitted">
										<cv:msg key="label.azureAppRequired" bundle="exchange" />
									</div>
								</div>
								<div class="form-group">
									<!-- data-ng-if="!addMailbox.dontUseExchangeOAuth"> -->
									<label class="col-xs-12 col-lg-4" for="serviceAccounts"><cv:msg
											key="label.serviceAccountlabel" bundle="exchange" /></label>
									<div class="col-xs-12 col-lg-8">
										<a data-ng-click="addMailbox.openAddServiceAccountModal( param1, param2, addMailbox.isInfrastructurePoolConfigured, false)"
											class="float-right"><cv:msg key="label.add"
												bundle="exchange" /></a>
										<table class="table table-borderless table-striped">
											<tbody>
												<tr
													data-ng-repeat="userAccount in addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts">
													<td
														data-ng-if="addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index].serviceType !== 'EXCHANGE_ONLINE'"><button id="createMailbox_button_#8246" 
															type="button" class="btn btn-link float-left"
															data-ng-click="addMailbox.openAddServiceAccountModal(addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index], $index, addMailbox.isInfrastructurePoolConfigured, false)">{{addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index].userAccount.userName}}</button></td>
													<td
														data-ng-if="addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'EXCHANGE_ONLINE'"><button id="createMailbox_button_#2135" 
															type="button" class="btn btn-link float-left"
															data-ng-click="addMailbox.openAddServiceAccountModal(addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index], $index, addMailbox.isInfrastructurePoolConfigured, false)">{{addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index].exchangeAdminSmtpAddress}}</button></td>
													<td>{{addMailbox.getSimplifiedName(addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index].serviceType)}}</td>
													<td><button id="createMailbox_button_#8887" type="button" 
															class="btn btn-link float-right"
															data-ng-click="addMailbox.deleteAccountConfirmation(addMailbox.mailbox.attributes.onePassProp.accounts.adminAccounts[$index], $index)">
															<span class="glyphicon glyphicon-remove"></span>
														</button></td>
												</tr>
											</tbody>
										</table>
										<div class="text-muted">
											<div>
												<cv:msg key="label.needAtLeastOneOfTheFollowing"
													bundle="exchange" />
											</div>
											<ul>
												<li
													data-ng-class="addMailbox.mailbox.hasExchangeVersionAccount() ? 'text-success complete' : 'text-danger incomplete'"
													data-ng-if="addMailbox.mailbox.mailboxType.toLowerCase() !== 'contentstore' && addMailbox.mailbox.attributes.onePassProp.environmentType !== 'EXCHANGE_ONLINE_ONLY' && addMailbox.mailbox.attributes.onePassProp.environmentType !== 'EXCHANGE_ONLINE_WITH_ONPREM_AD'"><cv:msg
														key="label.needExchangeVersion" bundle="exchange" /></li>
												<li
													data-ng-class="addMailbox.mailbox.hasAccountType('EXCHANGE_ONLINE') ? 'text-success complete' : 'text-danger incomplete'"
													data-ng-if="addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY' || addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_HYBRID' || addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_WITH_ONPREM_AD'"><cv:msg
														key="label.needExchangeOnline" bundle="exchange" /></li>
												<li
													data-ng-class="addMailbox.mailbox.hasAccountType('SYSTEM_ACCOUNT') ? 'text-success complete' : 'text-danger incomplete'"
													data-ng-if="!addMailbox.isInfrastructurePoolConfigured && (addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_ONLY' || addMailbox.mailbox.attributes.onePassProp.environmentType === 'EXCHANGE_ONLINE_WITH_ONPREM_AD')"><cv:msg
														key="label.needLocalSystem" bundle="exchange" /></li>
											</ul>
										</div>
									</div>
								</div>
								<!-- New Service Account List -->
							</div>
						</div>
						<!--  Service Accounts -->
						<!-- End Step 3-->
					</div>
					<span data-ng-class="text-danger incomplete"
						data-ng-if="addMailbox.clientCreationFailed">
						{{addMailbox.clientCreationError}}
					</span>
					<!-- Buttons -->
					<div class="text-right">
						<button id="createMailbox_button_#0850" type="button" data-ng-if="addMailbox.step > 1" 
							class="btn btn-primary cvBusyOnAjax"
							data-ng-disabled="addMailbox.processingRequest"
							data-ng-click="addMailbox.previous()">
							<cv:msg key="previous" bundle="messages" />
						</button>
						<button id="createMailbox_button_#9276" type="submit" class="btn btn-primary cvBusyOnAjax" 
							data-ng-disabled="addMailbox.processingRequest">
							{{addMailbox.getButtonLabel()}}<i
								data-ng-if="addMailbox.processingRequest"
								class="fa fa-spinner fa-spin"></i>
						</button>
						<!-- Buttons -->
					</div>
				</div>
			</form>
		</div>
	</div>
	<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
</div>
