<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.restoreOpts" bundle="restore" />
		<cv-help-component
			help-text="<cv:msg key="label.db.restoreMessage.help.text" bundle="exchange"/>"></cv-help-component>
	</h1>
</div>
<form name="restoreForm" class="form-horizontal bootstrap-wrapper"
	novalidate data-cv-submit="exchDbRestoreMsgOptionsCtrl.restore()"
	autocomplete="off">
	<div class="modal-body">
	
		<span class="serverMessage {{exchDbRestoreMsgOptionsCtrl.restoreMessage.type}}"
			data-ng-bind="exchDbRestoreMsgOptionsCtrl.restoreMessage.message"></span>
			
		<div class="form-group">
			<label class="col-xs-5" for="clientDestination"><cv:msg
					key="label.destHost" bundle="exchange"></cv:msg></label>
			<div class="col-xs-7">
				<select id="clientDestination" name="clientDestination"
				    data-ng-disabled="true"
					data-ng-model="exchDbRestoreMsgOptionsCtrl.selectedDestinationServer"
					data-ng-options="ds.clientName for ds in exchDbRestoreMsgOptionsCtrl.destinationServerList | orderBy: 'clientName' track by ds.clientId"
					required="required">
					<option value=""><cv:msg key="label.selectDestination"
							bundle="exchange"></cv:msg></option>
				</select>
				<div class="help-block"
					data-ng-show="cv.restoreForm.needsAttention(restoreForm.clientDestination)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.selectDestinationHost" bundle="exchange"></cv:msg>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label for="destinationPath" class="col-xs-5"> <cv:msg
					key="label.restoreToPSTFile" bundle="exchange"></cv:msg></label>
			<div class="col-xs-7">
				<div class="input-group">
					<input type="text" id="destinationPath" name="destinationPath"
						data-ng-disabled="!exchDbRestoreMsgOptionsCtrl.selectedDestinationServer"
						data-ng-model="exchDbRestoreMsgOptionsCtrl.destinationPath"
						required="required" /> <span class="input-group-btn">
						<button id="exchDbRestoreMessagesOptions_button_#8284" class="btn btn-default" type="button" 
							data-ng-disabled="!exchDbRestoreMsgOptionsCtrl.selectedDestinationServer"
							data-ng-click="exchDbRestoreMsgOptionsCtrl.openDestinationModal()">
							<cv:msg key="label.browse" bundle="restore"/>
						</button>
				</span>
			</div>
				<div class="help-block"
					data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationPath)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.selectDestinationPstPath" bundle="exchange"></cv:msg>
				</div>
				<div class="help-block"
					data-ng-show="exchDbRestoreMsgOptionsCtrl.inputAlerts.pstPath">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.selectDestinationPstPath" bundle="exchange" />
				</div>
		</div>
	</div>
	</div>
	<div class="modal-footer">
		<button id="exchDbRestoreMessagesOptions_button_#6666" class="btn btn-default cvBusyOnAjax" type="button" 
			data-ng-click="exchDbRestoreMsgOptionsCtrl.cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="exchDbRestoreMessagesOptions_button_#7821" class="btn btn-primary cvBusyOnAjax" type="submit"> 
			<cv:msg key="Submit" bundle="messages" />
		</button>
	</div>
</form>