<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div>
<!-- directive added for reuse in edit proxy tile -->
	<div class="cv-modal-wrapper no-pad">
		<input id="useProxy" type="checkbox" data-ng-model="ctrl.clientDetails.useProxy" data-ng-change="ctrl.proxyChange()" />
		<label for="useProxy" class="checkbox-label checkbox-label-wrap margin-top-10"><cv:msg key="label.useProxy" bundle="exchange" /></label>
		<div class="cv-inline-wrapper">
			<label class="select-label">
				<select
					name="proxyList"
					data-ng-model="ctrl.clientDetails.proxy"
					data-ng-disabled="!ctrl.clientDetails.useProxy"
					data-ng-options="proxy as proxy.clientName for proxy in ctrl.proxyList | orderBy: 'clientName'"
					data-ng-change="ctrl.proxyChange()"
					class="modal-select">
				</select>
			</label>
			<span class="cv-help-block" data-ng-show="ctrl.clientDetails.useProxy && ctrl.inputAlerts.proxyList"><cv:msg key="error.useProxy" bundle="exchange" /></span>
		</div>
	</div>
	<!-- buffer between ddl + checkbox row and next ddl row -->
	<div data-ng-show="ctrl.showDagServers">
		<div class="cv-modal-wrapper">
			<label for="dagServerList" class="cv-label"><cv:msg key="label.DAGServers" bundle="exchange" /></label>
			<div class="cv-inline-wrapper">
				<label class="select-label">
					<select
						name="dagServerList"
						data-ng-init="ctrl.clientDetails.dagServer = ctrl.dagServerList[0]"
						data-ng-model="ctrl.clientDetails.dagServer"
						data-ng-options="dagServer as dagServer.dagName for dagServer in ctrl.dagServerList track by dagServer.dagName"
						data-ng-change="ctrl.filterMemberServers()"
						class="modal-select">
						<option value=""><cv:msg key="placeholder.dagServerList" bundle="exchange" /></option>
					</select>
				</label>
				<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.dagServer"><cv:msg key="error.dagServers" bundle="exchange" /></span>
			</div>
		</div>
		<p class="serverMessage {{ctrl.exchDbProxyMessage.type}} exch-proxy-buffer" data-ng-show="ctrl.exchDbProxyMessage && ctrl.exchDbProxyMessage.message != ''" >{{ctrl.exchDbProxyMessage.message}}</p>
		<!-- multi select dropdown -->
		<div class="cv-modal-wrapper">
			<label for="dagMemberServerList" class="cv-label"><cv:msg key="label.MemberServers" bundle="exchange"/></label>
			<span class="cv-help-block" data-ng-show="ctrl.inputAlerts.dagMemberServers"><cv:msg key="error.dagMemberServers" bundle="exchange" /></span>
			<div class="cv-inline-wrapper exch-isteven-wrapper" data-ng-disabled="!dagMemberServers || dagMemberServers.length == 0">
					<isteven-multi-select
						input-model="dagMemberServers"
						output-model="selected.DagMemberServers"
						button-label="serverName"
			  			item-label="serverName"
						tick-property="selectedForDAGClient"
						class="isteven-multi-select user-group-select"
						id="dagMemberServerList"
						disable-property="disableSelect"
			   			max-labels="1"
						translation="ctrl.localLang"
						helper-elements="all none reset filter"
						on-reset="resetMulti()"	/>
			</div>
		</div>
	</div>
</div>