<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvEnum name="App.ExchangeVersion"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.createRecoveryPoint" bundle="exchange" />
		<cv-help-component help-text="<cv:msg key="help.text.create.recovery.point" bundle="exchange"/>"></cv-help-component>
	</h1>
</div>
<form name="createRecoveryPoint" class="form-horizontal bootstrap-wrapper" novalidate data-cv-submit="exchDbCreateRecoveryPointCtrl.doCreateRecoveryPoint()" autocomplete="off">
	<div class="modal-body">
		<span class="serverMessage {{exchDbCreateRecoveryPointCtrl.serverMessage.type}}" data-ng-bind="exchDbCreateRecoveryPointCtrl.serverMessage.message"></span>
        <!-- Begin: Destination Severs -->
		<div class="form-group">
			<label for="destinationServer" class="col-xs-5">
				<cv:msg key="label.rp.selectMediaAgent" bundle="exchange" />
				<cv-help-component help-text='<cv:msg key="label.rp.selectMediaAgent.help.text" bundle="exchange"/>'></cv-help-component>
			</label>
			<div class="col-xs-7" >
                <isteven-multi-select
                	id="destinationServer"
                 	input-model="exchDbCreateRecoveryPointCtrl.destinationServerList"
                 	output-model="exchDbCreateRecoveryPointCtrl.selectedDestinationServerList"
                 	button-label="maName"
                 	item-label="maName"
                 	search-property="maName"
                 	tick-property="selected"
                 	class="isteven-multi-select user-group-select single-select"
                 	helper-elements="filter"
                 	search-limit="10"
                 	max-labels="1"
                    selection-mode="single"
                    translation="exchDbCreateRecoveryPointCtrl.localLang">
                </isteven-multi-select>
				<span class="help-block" data-ng-show="cv.createRecoveryPoint.needsAttention(exchDbCreateRecoveryPointCtrl.destinationServerList && exchDbCreateRecoveryPointCtrl.destinationServerList.length == 0)">
					<cv:msg key="error.destinationServer" bundle="restore" />
				</span>
			</div>
		</div>
		<!-- End: Destination Severs -->
		<!-- Begin: recovery point options -->
		<hr>
		<div class="form-group">
			<div class="col-xs-12">
				<label>
					<cv:msg key="label.rp.configure" bundle="exchange"></cv:msg>
					<cv-help-component help-text='<cv:msg key="label.rp.expireDateMsg.help.text" bundle="exchange"/>'></cv-help-component>
				</label>
			</div>
		</div>
		<!-- <div class="form-group" data-ng-disabled="true">
			<label for="createRecPoint" class="col-xs-9">
				<cv:msg key="label.rp.expireDateMsg.snapBackup" bundle="exchange"></cv:msg>
			</label>
			<div class="col-xs-3">
				<label>
					<input id="snapBackupDismountImage" name="snapBackupDismountImage" type="number" min="1" data-ng-model="exchDbCreateRecoveryPointCtrl.snapBackupDismountImage" class="storage-retention-input"/>
				</label>
			</div>
		</div> -->
		<div class="form-group">
			<label for="createRecPoint" class="col-xs-9">
				<cv:msg key="label.rp.expireDateMsg.blockLevelBackup" bundle="exchange"></cv:msg>
			</label>
			<div class="col-xs-3">
				<input id="blockLevelCache" name="blockLevelCache" type="number" min="1" data-ng-model="exchDbCreateRecoveryPointCtrl.blockLevelCache" class="storage-retention-input"/>
			</div>
		</div>
		<!--  End: recovery point options -->
	</div>
	<div class="modal-footer">
		<button id="exchDbCreateRecoveryPointOptions_button_#7979" type="button"
			class="btn btn-default cvBusyOnAjax setup-btn--hidden"
			data-ng-click="exchDbCreateRecoveryPointCtrl.cancelModal()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="exchDbCreateRecoveryPointOptions_button_#3028" class="btn btn-primary cvBusyOnAjax" type="submit">
			<cv:msg key="Submit" bundle="messages" />
		</button>
	</div>
</form>
